/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.blocks;

import com.legacy.good_nights_sleep.capabillity.DreamPlayer;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.registry.GNSDimensions;
import com.legacy.good_nights_sleep.tile_entity.DreamBedBlockEntity;
import com.legacy.good_nights_sleep.world.GNSTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;

public class GNSBedBlock
extends BedBlock {
    public GNSBedBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.WHITE, properties);
    }

    public DreamType getDreamType() {
        return this == GNSBlocks.luxurious_bed ? DreamType.DREAM : (this == GNSBlocks.wretched_bed ? DreamType.NIGHTMARE : DreamType.RANDOM);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    public static void onWakeUp(PlayerWakeUpEvent event, Player player, BlockState bedState, BlockPos sleepPos) {
        Block block = bedState.getBlock();
        if (block instanceof GNSBedBlock) {
            GNSBedBlock bed = (GNSBedBlock)block;
            bed.setBedOccupied(bedState, player.level(), sleepPos, (LivingEntity)player, false);
            bed.travelToDream(player, bed.getDreamType());
        }
    }

    private void travelToDream(Player player, DreamType dreamType) {
        ResourceKey transferDimension;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ResourceKey ow = Level.OVERWORLD;
        ResourceKey sleepDim = dreamType.getDreamDestination(player.getRandom());
        ResourceKey resourceKey = transferDimension = player.level().dimension().equals(ow) ? sleepDim : ow;
        if (transferDimension != Level.OVERWORLD) {
            DreamPlayer d = DreamPlayer.get((Player)serverPlayer);
            d.setEnteredDreamTime(serverPlayer.level().getGameTime());
            d.syncDataToClient();
        }
        ServerLevel overworldLevel = player.getServer().getLevel(ow);
        BlockPos pos = overworldLevel.getSharedSpawnPos();
        if (serverPlayer.getRespawnConfig() != null) {
            pos = serverPlayer.getRespawnConfig().pos();
        }
        GNSTeleporter.changeDimension((ResourceKey<Level>)transferDimension, (Entity)player, pos);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DreamBedBlockEntity(pos, state);
    }

    private static enum DreamType implements StringRepresentable
    {
        DREAM("dream"),
        NIGHTMARE("nightmare"),
        RANDOM("random");

        private String name;

        private DreamType(String name) {
            this.name = name;
        }

        public ResourceKey<Level> getDreamDestination(RandomSource rand) {
            return switch (this.ordinal()) {
                case 0 -> GNSDimensions.dreamKey();
                case 1 -> GNSDimensions.nightmareKey();
                default -> rand.nextBoolean() ? GNSDimensions.dreamKey() : GNSDimensions.nightmareKey();
            };
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

