/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.blocks;

import com.legacy.good_nights_sleep.blocks.RainbowBlock;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.registry.GNSSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PotOfGoldBlock
extends Block {
    protected static final int MAX_DISTANCE = 100;
    private static final VoxelShape INSIDE = PotOfGoldBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)PotOfGoldBlock.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{PotOfGoldBlock.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), PotOfGoldBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final IntegerProperty PLACEMENTS = IntegerProperty.create((String)"placements", (int)0, (int)100);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public PotOfGoldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PLACEMENTS, (Comparable)Integer.valueOf(0))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (level.isClientSide) {
            if (level.getBlockState(pos.above()).is(GNSBlocks.rainbow)) {
                for (int i = 0; i < 1 + rand.nextInt(2); ++i) {
                    float x = (float)pos.getX() + 0.25f + rand.nextFloat() * 0.5f;
                    float z = (float)pos.getZ() + 0.25f + rand.nextFloat() * 0.5f;
                    float scale = 0.5f;
                    level.addParticle((ParticleOptions)ParticleTypes.FIREWORK, (double)x, (double)((float)pos.getY() + 0.9f), (double)z, (double)((x - ((float)pos.getX() + 0.6f)) * scale), (double)(0.05f + rand.nextFloat() * 0.2f), (double)((z - ((float)pos.getZ() + 0.5f)) * scale));
                }
            }
            float x = (float)pos.getX() + 0.25f + rand.nextFloat() * 0.5f;
            float z = (float)pos.getZ() + 0.25f + rand.nextFloat() * 0.5f;
            level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)ARGB.color((int)Mth.floor((float)38.25f), (int)15845719)), (double)x, (double)((float)pos.getY() + 0.9f), (double)z, 1.0, 1.0, 1.0);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return INSIDE;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 180, 0, false, true));
            sl.playSound(null, pos, GNSSounds.BLOCK_POT_OF_GOLD_USE, SoundSource.BLOCKS);
            sl.sendParticles((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)ARGB.color((int)100, (int)((MobEffect)MobEffects.REGENERATION.value()).getColor())), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.9f), (double)((float)pos.getZ() + 0.5f), 20, (double)0.3f, (double)0.1f, (double)0.3f, 1.0);
        }
        return InteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.scheduleTick(pos, (Block)this, 1);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection());
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.hasProperty((Property)PLACEMENTS) && state.hasProperty(FACING) && (Integer)state.getValue((Property)PLACEMENTS) < 100) {
            if (PotOfGoldBlock.placeRainbows((Integer)state.getValue((Property)PLACEMENTS), (Level)level, pos, state, (Direction)state.getValue(FACING))) {
                level.setBlock(pos, (BlockState)state.setValue((Property)PLACEMENTS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PLACEMENTS) + 1)), 2);
                level.scheduleTick(pos, (Block)this, 1);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)PLACEMENTS, (Comparable)Integer.valueOf(100)), 2);
            }
        }
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    private static boolean placeRainbows(int iteration, Level level, BlockPos pos, BlockState state, Direction dir) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel sl = (ServerLevel)level;
        if (iteration == 0) {
            return true;
        }
        Direction.Axis axis = dir.getAxis();
        boolean flipped = dir == Direction.NORTH || dir == Direction.EAST;
        int maxHeight = 20;
        int maxLength = 40;
        BlockPos placementPos = null;
        if (iteration <= maxHeight) {
            if (level.getBlockState(pos.above(iteration)).isAir()) {
                BlockState rainbow = (BlockState)((BlockState)GNSBlocks.rainbow.defaultBlockState().setValue(RainbowBlock.AXIS, (Comparable)axis)).setValue((Property)RainbowBlock.SIDE_TYPE, (Comparable)Integer.valueOf(flipped ? 2 : 0));
                if (iteration == maxHeight) {
                    rainbow = (BlockState)rainbow.setValue((Property)RainbowBlock.CORNER_TYPE, (Comparable)Integer.valueOf(flipped ? 2 : 1));
                }
                placementPos = pos.above(iteration);
                level.setBlock(placementPos, (BlockState)rainbow.setValue((Property)RainbowBlock.DISTANCE, (Comparable)Integer.valueOf(iteration)), 3);
            } else {
                iteration = 101;
            }
        }
        int currentLength = iteration - maxHeight;
        if (iteration > maxHeight && currentLength <= maxLength) {
            if (level.getBlockState(pos.above(maxHeight).relative(dir, currentLength)).isAir()) {
                BlockState rainbow = (BlockState)((BlockState)GNSBlocks.rainbow.defaultBlockState().setValue(RainbowBlock.AXIS, (Comparable)axis)).setValue((Property)RainbowBlock.SIDE_TYPE, (Comparable)Integer.valueOf(1));
                if (currentLength == maxLength) {
                    rainbow = (BlockState)rainbow.setValue((Property)RainbowBlock.CORNER_TYPE, (Comparable)Integer.valueOf(flipped ? 1 : 2));
                }
                placementPos = pos.above(maxHeight).relative(dir, currentLength);
                level.setBlock(placementPos, (BlockState)rainbow.setValue((Property)RainbowBlock.DISTANCE, (Comparable)Integer.valueOf(iteration)), 3);
            } else {
                iteration = 101;
            }
        }
        if (currentLength > maxLength) {
            int heightDecrease = iteration - (maxHeight + maxLength);
            if (level.getBlockState(pos.above(maxHeight - heightDecrease).relative(dir, maxLength)).isAir()) {
                BlockState rainbow = (BlockState)((BlockState)GNSBlocks.rainbow.defaultBlockState().setValue(RainbowBlock.AXIS, (Comparable)axis)).setValue((Property)RainbowBlock.SIDE_TYPE, (Comparable)Integer.valueOf(flipped ? 0 : 2));
                placementPos = pos.above(maxHeight - heightDecrease).relative(dir, maxLength);
                level.setBlock(placementPos, (BlockState)rainbow.setValue((Property)RainbowBlock.DISTANCE, (Comparable)Integer.valueOf(iteration)), 3);
            } else {
                iteration = 101;
            }
        }
        if (placementPos != null) {
            sl.sendParticles((ParticleOptions)ParticleTypes.FIREWORK, (double)((float)placementPos.getX() + 0.5f), (double)((float)placementPos.getY() + 0.5f), (double)((float)placementPos.getZ() + 0.5f), 10, 0.5, 0.5, 0.5, (double)0.3f);
            if (iteration % 2 == 0) {
                sl.playSound(null, placementPos, GNSSounds.BLOCK_RAINBOW_APPEAR, SoundSource.BLOCKS, 5.0f, sl.getRandom().nextBoolean() ? (sl.getRandom().nextBoolean() ? 1.1f : 1.2f) : 1.0f);
            }
            return true;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PLACEMENTS, FACING});
    }
}

