/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.blocks;

import com.legacy.good_nights_sleep.registry.GNSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RainbowBlock
extends Block {
    private static final int MAX_DISTANCE = 100;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected static final VoxelShape X_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final IntegerProperty CORNER_TYPE = IntegerProperty.create((String)"corner_type", (int)0, (int)2);
    public static final IntegerProperty SIDE_TYPE = IntegerProperty.create((String)"side_type", (int)0, (int)2);
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"distance", (int)0, (int)100);
    public static final BooleanProperty DECAY = BooleanProperty.create((String)"decay");

    public RainbowBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)CORNER_TYPE, (Comparable)Integer.valueOf(0))).setValue((Property)SIDE_TYPE, (Comparable)Integer.valueOf(0))).setValue((Property)DECAY, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.getValue(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public Integer getBeaconColorMultiplier(BlockState state, LevelReader reader, BlockPos pos, BlockPos beaconPos) {
        if (reader instanceof Level) {
            Level level = (Level)reader;
            int offsetAmount = 360;
            int speed = 10;
            int zOffset = pos.getZ() % offsetAmount;
            if (zOffset < 0) {
                zOffset += offsetAmount;
            }
            zOffset *= speed;
            int xOffset = pos.getX() % offsetAmount;
            if (xOffset < 0) {
                xOffset += offsetAmount;
            }
            xOffset *= speed;
            long gameTime = level.getGameTime() + Long.MAX_VALUE + (long)zOffset + (long)xOffset;
            float h = (float)(gameTime % 360L) / 360.0f;
            if (h < 0.0f) {
                h += 1.0f;
            }
            int rgb = Mth.hsvToRgb((float)h, (float)1.0f, (float)0.9f);
            return ARGB.color((Vec3)new Vec3((double)((float)ARGB.red((int)rgb) / 255.0f), (double)((float)ARGB.green((int)rgb) / 255.0f), (double)((float)ARGB.blue((int)rgb) / 255.0f)));
        }
        return super.getBeaconColorMultiplier(state, reader, pos, beaconPos);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource rand) {
        int i = RainbowBlock.getDistance(state, facingState) + 1;
        if (i != 1 || (Integer)state.getValue((Property)DISTANCE) != i) {
            tickAccess.scheduleTick(currentPos, (Block)this, 1);
        }
        return state;
    }

    private static int getDistance(BlockState state, BlockState neighbor) {
        if (neighbor.is(GNSBlocks.pot_of_gold)) {
            return 0;
        }
        return neighbor.hasProperty(AXIS) && neighbor.getValue(AXIS) == state.getValue(AXIS) && neighbor.hasProperty((Property)DISTANCE) ? (Integer)neighbor.getValue((Property)DISTANCE) : 100;
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        RainbowBlock.decayNeighbors((BlockState)state.setValue((Property)DECAY, (Comparable)Boolean.valueOf(true)), level, pos);
    }

    public void onDestroyedByPushReaction(BlockState state, Level level, BlockPos pos, Direction pushDirection, FluidState fluid) {
        RainbowBlock.decayNeighbors((BlockState)state.setValue((Property)DECAY, (Comparable)Boolean.valueOf(true)), (LevelAccessor)level, pos);
        super.onDestroyedByPushReaction(state, level, pos, pushDirection, fluid);
    }

    private static boolean decayNeighbors(BlockState state, LevelAccessor level, BlockPos pos) {
        if ((Integer)state.getValue((Property)DISTANCE) <= 1 && !level.getBlockState(pos.below()).is(GNSBlocks.pot_of_gold) || ((Boolean)state.getValue((Property)DECAY)).booleanValue()) {
            BlockPos.MutableBlockPos neighborPos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                if (direction.getAxis() != state.getValue(AXIS) && direction.getAxis() != Direction.Axis.Y) continue;
                neighborPos.setWithOffset((Vec3i)pos, direction);
                BlockState neighbor = level.getBlockState((BlockPos)neighborPos);
                if (!neighbor.hasProperty(AXIS) || neighbor.getValue(AXIS) != state.getValue(AXIS)) continue;
                level.setBlock((BlockPos)neighborPos, (BlockState)neighbor.setValue((Property)DECAY, (Comparable)Boolean.valueOf(true)), 3);
                level.scheduleTick((BlockPos)neighborPos, state.getBlock(), 1);
            }
            return true;
        }
        return false;
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 100;
        if (RainbowBlock.decayNeighbors(state, level, pos)) {
            return (BlockState)((BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i))).setValue((Property)DECAY, (Comparable)Boolean.valueOf(true));
        }
        BlockPos.MutableBlockPos neighborPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            if (direction.getAxis() != state.getValue(AXIS) && direction.getAxis() != Direction.Axis.Y) continue;
            neighborPos.setWithOffset((Vec3i)pos, direction);
            int neighborDistance = RainbowBlock.getDistance(state, level.getBlockState((BlockPos)neighborPos));
            i = Math.min(i, Math.min((Integer)state.getValue((Property)DISTANCE), neighborDistance) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState newState = RainbowBlock.updateDistance(state, (LevelAccessor)level, pos);
        level.setBlock(pos, newState, 2);
        if ((Integer)state.getValue((Property)DISTANCE) >= 100 || ((Boolean)state.getValue((Property)DECAY)).booleanValue()) {
            level.destroyBlock(pos, false);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effect) {
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return ItemStack.EMPTY;
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, CORNER_TYPE, SIDE_TYPE, DISTANCE, DECAY});
    }
}

