/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.blocks.natural;

import com.legacy.good_nights_sleep.registry.GNSBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class DreamFarmlandBlock
extends FarmBlock {
    public DreamFarmlandBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            DreamFarmlandBlock.turnToDreamDirt(null, state, (Level)level, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int i = (Integer)state.getValue((Property)MOISTURE);
        if (!DreamFarmlandBlock.isNearWater((LevelReader)level, (BlockPos)pos) && !level.isRainingAt(pos.above())) {
            if (i > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!DreamFarmlandBlock.shouldMaintainFarmland((BlockGetter)level, (BlockPos)pos)) {
                DreamFarmlandBlock.turnToDreamDirt(null, state, (Level)level, pos);
            }
        } else if (i < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public static void turnToDreamDirt(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        BlockState blockstate = DreamFarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)GNSBlocks.dream_dirt.defaultBlockState(), (LevelAccessor)level, (BlockPos)pos);
        level.setBlockAndUpdate(pos, blockstate);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
    }
}

