/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.blocks.natural;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LightEngine;
import net.neoforged.neoforge.common.util.Lazy;

public class DreamGrassBlock
extends GrassBlock {
    private final Lazy<Block> dirt;
    private final Lazy<Block> tallGrass;

    public DreamGrassBlock(BlockBehaviour.Properties props, Supplier<Block> dirt, Supplier<Block> tallGrass) {
        super(props);
        this.dirt = Lazy.of(dirt);
        this.tallGrass = Lazy.of(tallGrass);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource rand) {
        Block block = level.getBlockState(pos.above()).getBlock();
        return (BlockState)state.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(block == Blocks.SNOW || block == Blocks.SNOW_BLOCK));
    }

    public void randomTick(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        Block dirtBlock = (Block)this.dirt.get();
        if (!DreamGrassBlock.canBeGrass(state, (LevelReader)serverLevel, pos)) {
            if (!serverLevel.isLoaded(pos)) {
                return;
            }
            serverLevel.setBlockAndUpdate(pos, dirtBlock.defaultBlockState());
        } else if (serverLevel.getMaxLocalRawBrightness(pos.above()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockState spreadState;
                DreamGrassBlock spreadResult;
                BlockPos spreadPos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                DreamGrassBlock dreamGrassBlock = spreadResult = serverLevel.getBlockState(spreadPos).getBlock() == dirtBlock ? this : null;
                if (spreadResult == null || !DreamGrassBlock.canPropagate(spreadState = spreadResult.defaultBlockState(), (LevelReader)serverLevel, spreadPos)) continue;
                if (spreadState.hasProperty((Property)SNOWY)) {
                    spreadState = (BlockState)spreadState.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(serverLevel.getBlockState(spreadPos.above()).is(Blocks.SNOW)));
                }
                serverLevel.setBlockAndUpdate(spreadPos, spreadState);
            }
        }
    }

    private static boolean canBeGrass(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos abovePos = pos.above();
        BlockState aboveState = level.getBlockState(abovePos);
        if (aboveState.is(Blocks.SNOW) && (Integer)aboveState.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (aboveState.getFluidState().getAmount() == 8) {
            return false;
        }
        int light = LightEngine.getLightBlockInto((BlockState)state, (BlockState)aboveState, (Direction)Direction.UP, (int)aboveState.getLightBlock());
        return light < 15;
    }

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos abovePos = pos.above();
        return DreamGrassBlock.canBeGrass(state, level, pos) && !level.getFluidState(abovePos).is(FluidTags.WATER);
    }

    public void performBonemeal(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.above();
        BlockState grassState = ((Block)this.tallGrass.get()).defaultBlockState();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos placePos = abovePos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.getBlockState((placePos = placePos.offset(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).below()).is((Block)this) || level.getBlockState(placePos).isCollisionShapeFullBlock((BlockGetter)level, placePos)) continue block0;
            }
            BlockState blockAtPlace = level.getBlockState(placePos);
            if (!blockAtPlace.isAir()) continue;
            if (rand.nextInt(8) == 0) {
                List flowerFeatures = ((Biome)level.getBiome(placePos).value()).getGenerationSettings().getFlowerFeatures();
                if (flowerFeatures.isEmpty()) continue;
                PlacedFeature placedFeature = (PlacedFeature)((RandomPatchConfiguration)((ConfiguredFeature)flowerFeatures.get(rand.nextInt(flowerFeatures.size()))).config()).feature().value();
                placedFeature.place((WorldGenLevel)level, level.getChunkSource().getGenerator(), rand, placePos);
                continue;
            }
            level.setBlockAndUpdate(placePos, grassState);
        }
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        if (plant.getBlock() instanceof SaplingBlock) {
            return TriState.TRUE;
        }
        return super.canSustainPlant(state, level, soilPosition, facing, plant);
    }

    public boolean onTreeGrow(BlockState state, LevelReader level, BiConsumer<BlockPos, BlockState> placeFunction, RandomSource randomSource, BlockPos pos, TreeConfiguration config) {
        placeFunction.accept(pos, ((Block)this.dirt.get()).defaultBlockState());
        return true;
    }
}

