/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.capabillity;

import com.legacy.good_nights_sleep.network.PacketHandler;
import com.legacy.good_nights_sleep.network.SyncPlayerPayload;
import com.legacy.good_nights_sleep.registry.GNSDimensions;
import com.legacy.good_nights_sleep.registry.GNSRegistry;
import com.legacy.good_nights_sleep.world.GNSTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;

public class DreamPlayer {
    private final Player player;
    private long enteredGameTime = 0L;
    public static final StreamCodec<RegistryFriendlyByteBuf, DreamPlayer> STREAM_CODEC = StreamCodec.of(DreamPlayer::writeToStream, DreamPlayer::createFromStream);

    public DreamPlayer(Player player) {
        this.player = player;
    }

    public static DreamPlayer get(Player player) {
        return (DreamPlayer)player.getData(GNSRegistry.PLAYER_ATTACHMENT);
    }

    public void serverTick() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            long worldTime = sp.level().getGameTime() - this.getEnteredDreamTime();
            if (worldTime > 25000L && GNSDimensions.inSleepDimension((Entity)this.player)) {
                ServerLevel serverLevel = sp.level();
                if (serverLevel instanceof ServerLevel) {
                    ServerLevel sl = serverLevel;
                    BlockPos pos = sp.getRespawnConfig() != null ? sp.getRespawnConfig().pos() : sl.getSharedSpawnPos();
                    GNSTeleporter.changeDimension((ResourceKey<Level>)Level.OVERWORLD, (Entity)sp, pos);
                }
            } else if (!GNSDimensions.inSleepDimension((Entity)this.player)) {
                this.setEnteredDreamTime(sp.level().getGameTime());
            }
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public long getEnteredDreamTime() {
        return this.enteredGameTime;
    }

    public void setEnteredDreamTime(long timeIn) {
        this.enteredGameTime = timeIn;
    }

    public void onDeath() {
    }

    public void syncDataToClient() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)player;
            PacketHandler.sendToClient(new SyncPlayerPayload(this), s);
        }
    }

    public void copyFrom(DreamPlayer player) {
        this.setEnteredDreamTime(player.getEnteredDreamTime());
    }

    private static void writeToStream(RegistryFriendlyByteBuf buffer, DreamPlayer player) {
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess());
        Serializer.INSTANCE.write(player, (ValueOutput)output);
        buffer.writeNbt((Tag)output.buildResult());
    }

    public static DreamPlayer createFromStream(RegistryFriendlyByteBuf buffer) {
        ValueInput input = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt());
        DreamPlayer attachment = Serializer.INSTANCE.read(null, input);
        return attachment;
    }

    public static class Serializer
    implements IAttachmentSerializer<DreamPlayer> {
        public static final Serializer INSTANCE = new Serializer();
        static final String ENTERED_TIME_KEY = "EnteredDreamTime";

        public boolean write(DreamPlayer attachment, ValueOutput output) {
            output.putLong(ENTERED_TIME_KEY, attachment.getEnteredDreamTime());
            return true;
        }

        public DreamPlayer read(IAttachmentHolder holder, ValueInput input) {
            DreamPlayer attachment = new DreamPlayer((Player)holder);
            input.getLong(ENTERED_TIME_KEY).ifPresent(time -> attachment.setEnteredDreamTime((long)time));
            return attachment;
        }
    }
}

