/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.client;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.data.GNSBiomeTags;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.registry.GNSDimensions;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EventBusSubscriber(modid="good_nights_sleep", value={Dist.CLIENT})
public class GNSBlockColoring
implements IModBusEvent {
    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        Minecraft mc = Minecraft.getInstance();
        event.register((state, level, pos, index) -> {
            if (mc.level != null && pos != null && (mc.level.dimension().equals(GNSDimensions.dreamKey()) || mc.level.getBiome(pos).is(GNSBiomeTags.IS_DREAM))) {
                return level != null ? GNSBlockColoring.getAverageGrassColor(level, pos) : 0xFFFFFF;
            }
            return 0xFFFFFF;
        }, new Block[]{GNSBlocks.dream_grass_block, GNSBlocks.short_dream_grass});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(GoodNightSleep.locate("dream_grass"), DreamGrassTintSource.CODEC);
    }

    public static int getAverageGrassColor(BlockAndTintGetter pLevel, BlockPos pBlockPos) {
        return pLevel.getBlockTint(pBlockPos, BiomeColors.GRASS_COLOR_RESOLVER);
    }

    public static void getVanillaGrassColor(BlockAndTintGetter pLevel, BlockPos pBlockPos, CallbackInfoReturnable<Integer> callback) {
        ResourceKey dim;
        LocalPlayer player = null;
        player = Minecraft.getInstance().player;
        if (player != null && (dim = player.level().dimension()).equals(GNSDimensions.dreamKey())) {
            callback.setReturnValue((Object)7990142);
        }
    }

    public record DreamGrassTintSource() implements ItemTintSource
    {
        static final MapCodec<DreamGrassTintSource> CODEC = MapCodec.unit(DreamGrassTintSource::new);

        public int calculate(ItemStack stack, ClientLevel level, LivingEntity entity) {
            return 0xFFFFFF;
        }

        public MapCodec<? extends ItemTintSource> type() {
            return CODEC;
        }
    }
}

