/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.client;

import com.legacy.good_nights_sleep.capabillity.DreamPlayer;
import com.legacy.good_nights_sleep.client.render.gui.DreamTransitionScreen;
import com.legacy.good_nights_sleep.client.render.gui.layers.WakeOverlayLayer;
import com.legacy.good_nights_sleep.data.GNSBiomeProv;
import com.legacy.good_nights_sleep.data.GNSBiomeTags;
import com.legacy.good_nights_sleep.mixin.LevelRendererInvoker;
import com.legacy.good_nights_sleep.registry.GNSDimensions;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.sounds.MusicInfo;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionTransitionScreenEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.SelectMusicEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;

public class GNSClientEvents {
    private static final DimensionSpecialEffects DREAM_RENDER_INFO = new DreamRenderInfo();
    private static final DimensionSpecialEffects NIGHTMARE_RENDER_INFO = new NightmareRenderInfo();

    public static Minecraft mc() {
        return Minecraft.getInstance();
    }

    public static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAboveAll(WakeOverlayLayer.KEY, (GuiLayer)new WakeOverlayLayer());
    }

    @SubscribeEvent
    public static void selectMusic(SelectMusicEvent event) {
        LocalPlayer player = GNSClientEvents.mc().player;
        if (player == null) {
            return;
        }
        Holder biome = player.level().getBiome(player.blockPosition());
        if (biome.is(GNSBiomeTags.IS_DREAM)) {
            event.setMusic(new MusicInfo((Music)GNSBiomeProv.DREAM.get()));
        } else if (biome.is(GNSBiomeTags.IS_NIGHTMARE)) {
            event.setMusic(new MusicInfo((Music)GNSBiomeProv.NIGHTMARE.get()));
        }
    }

    @SubscribeEvent
    public static void modifyFog(ViewportEvent.RenderFog event) {
        Camera cam;
        FogType fogtype;
        if (GNSClientEvents.mc().player != null && GNSClientEvents.mc().player.level().dimensionType().effectsLocation().equals((Object)GNSDimensions.NIGHTMARE_ID) && (fogtype = (cam = event.getCamera()).getFluidInCamera()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !((LevelRendererInvoker)GNSClientEvents.mc().levelRenderer).gns$doesMobEffectBlockSky(cam)) {
            event.setNearPlaneDistance(GNSClientEvents.mc().gameRenderer.getRenderDistance() * 0.05f);
            event.setFarPlaneDistance(Math.min(GNSClientEvents.mc().gameRenderer.getRenderDistance(), 192.0f) * 0.8f);
        }
    }

    public static void registerDimensionTransitions(RegisterDimensionTransitionScreenEvent event) {
        event.registerIncomingEffect(GNSDimensions.dreamKey(), DreamTransitionScreen::new);
        event.registerOutgoingEffect(GNSDimensions.dreamKey(), DreamTransitionScreen::new);
        event.registerIncomingEffect(GNSDimensions.nightmareKey(), DreamTransitionScreen::new);
        event.registerOutgoingEffect(GNSDimensions.nightmareKey(), DreamTransitionScreen::new);
    }

    public static void initDimensionRenderInfo(RegisterDimensionSpecialEffectsEvent event) {
        event.register(GNSDimensions.DREAM_ID, DREAM_RENDER_INFO);
        event.register(GNSDimensions.NIGHTMARE_ID, NIGHTMARE_RENDER_INFO);
    }

    public static float calculateSunAngle(long dayTime, float partialTicks) {
        LocalPlayer player = GNSClientEvents.mc().player;
        long worldTime = player != null && player.level().isClientSide && DreamPlayer.get((Player)player) != null ? GNSClientEvents.mc().level.getGameTime() - DreamPlayer.get((Player)player).getEnteredDreamTime() : dayTime;
        int j = (int)(worldTime % 48000L);
        float angle = ((float)j + partialTicks) / 48000.0f - 0.25f;
        if (player != null && player.level() != null && player.level().dimension().equals(GNSDimensions.nightmareKey())) {
            angle += 0.5f;
        }
        if (angle < 0.0f) {
            angle += 1.0f;
        }
        if (angle > 1.0f) {
            angle -= 1.0f;
        }
        float f2 = angle;
        angle = 1.0f - (float)((Math.cos((double)angle * Math.PI) + 1.0) / 2.0);
        angle = f2 + (angle - f2) / 3.0f;
        return angle;
    }

    public static class DreamRenderInfo
    extends DimensionSpecialEffects.OverworldEffects {
    }

    public static class NightmareRenderInfo
    extends DimensionSpecialEffects.OverworldEffects {
        public Vec3 getBrightnessDependentFogColor(Vec3 fogColor, float fogBrightness) {
            return fogColor;
        }

        public boolean isFoggyAt(int posX, int posZ) {
            return false;
        }
    }
}

