/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.client.render.entity;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.client.render.GNSRenderRefs;
import com.legacy.good_nights_sleep.client.render.models.BabyCreeperModel;
import com.legacy.good_nights_sleep.entity.dream.BabyCreeperEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BabyCreeperRenderer<T extends BabyCreeperEntity>
extends MobRenderer<T, CreeperRenderState, BabyCreeperModel> {
    private static final ResourceLocation TEXTURE = GoodNightSleep.locate("textures/entity/baby_creeper.png");

    public BabyCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BabyCreeperModel(context.bakeLayer(GNSRenderRefs.BABY_CREEPER)), 0.5f);
    }

    protected void scale(CreeperRenderState state, PoseStack pose) {
        float f = state.swelling;
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        pose.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(CreeperRenderState state) {
        float f = state.swelling;
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    public void extractRenderState(T entity, CreeperRenderState state, float partialTicks) {
        super.extractRenderState(entity, (LivingEntityRenderState)state, partialTicks);
        state.swelling = entity.getSwelling(partialTicks);
        state.isPowered = entity.isPowered();
    }

    public ResourceLocation getTextureLocation(CreeperRenderState entity) {
        return TEXTURE;
    }

    public CreeperRenderState createRenderState() {
        return new CreeperRenderState();
    }
}

