/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.client.render.entity;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.client.render.GNSRenderRefs;
import com.legacy.good_nights_sleep.client.render.entity.state.UnicornRenderState;
import com.legacy.good_nights_sleep.client.render.models.UnicornModel;
import com.legacy.good_nights_sleep.entity.dream.UnicornEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.EquineSaddleModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SimpleEquipmentLayer;
import net.minecraft.client.renderer.entity.state.EquineRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public class UnicornRenderer
extends AbstractHorseRenderer<UnicornEntity, UnicornRenderState, UnicornModel> {
    public UnicornRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new UnicornModel(context.bakeLayer(GNSRenderRefs.UNICORN)), (EntityModel)new UnicornModel(context.bakeLayer(GNSRenderRefs.UNICORN_BABY)));
        this.addLayer((RenderLayer)new SimpleEquipmentLayer((RenderLayerParent)this, context.getEquipmentRenderer(), EquipmentClientInfo.LayerType.HORSE_SADDLE, state -> state.saddle, (EntityModel)new EquineSaddleModel(context.bakeLayer(ModelLayers.HORSE_SADDLE)), (EntityModel)new EquineSaddleModel(context.bakeLayer(ModelLayers.HORSE_BABY_SADDLE))));
    }

    public ResourceLocation getTextureLocation(UnicornRenderState state) {
        String type = state.variant == 1 ? "green" : (state.variant == 2 ? "yellow" : (state.variant == 3 ? "blue" : "pink"));
        return GoodNightSleep.locate("textures/entity/unicorn/unicorn_" + type + ".png");
    }

    public void extractRenderState(UnicornEntity entity, UnicornRenderState state, float partialTicks) {
        super.extractRenderState((AbstractHorse)entity, (EquineRenderState)state, partialTicks);
        state.variant = entity.getUnicornType();
    }

    public UnicornRenderState createRenderState() {
        return new UnicornRenderState();
    }
}

