/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.client.render.models;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.util.Mth;

public class BabyCreeperModel
extends EntityModel<CreeperRenderState> {
    public ModelPart root;
    public ModelPart head;
    public ModelPart body;
    public ModelPart rightHindLeg;
    public ModelPart leftHindLeg;
    public ModelPart rightFrontLeg;
    public ModelPart leftFrontLeg;

    public BabyCreeperModel(ModelPart model) {
        super(model);
        this.root = model;
        this.head = model.getChild("head");
        this.body = model.getChild("body");
        this.rightFrontLeg = model.getChild("right_front_leg");
        this.leftFrontLeg = model.getChild("left_front_leg");
        this.rightHindLeg = model.getChild("right_hind_leg");
        this.leftHindLeg = model.getChild("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation size) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, size), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 8.0f, 4.0f, size), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        CubeListBuilder frontLeg = CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 4.0f, 4.0f, size);
        CubeListBuilder backLeg = CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, size);
        partdefinition.addOrReplaceChild("right_front_leg", frontLeg, PartPose.offset((float)-2.0f, (float)20.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("left_front_leg", frontLeg, PartPose.offset((float)2.0f, (float)20.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", backLeg, PartPose.offset((float)-2.0f, (float)20.0f, (float)2.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", backLeg, PartPose.offset((float)2.0f, (float)20.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(CreeperRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        this.head.yRot = state.yRot / 57.295776f;
        this.head.xRot = state.xRot / 57.295776f;
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }
}

