/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.client.render.models;

import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EquineRenderState;

public class UnicornModel
extends HorseModel {
    private final ModelPart horn;

    public UnicornModel(ModelPart model) {
        super(model);
        this.horn = model.getChild("horn");
    }

    public static LayerDefinition createUniBodyLayer() {
        MeshDefinition meshdefinition = HorseModel.createBodyMesh((CubeDeformation)CubeDeformation.NONE);
        PartDefinition root = meshdefinition.getRoot();
        root.addOrReplaceChild("horn", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -16.0f, 2.0f, 2.0f, 7.0f, 2.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)-10.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private static MeshDefinition createFullScaleBabyUniMesh(CubeDeformation scale) {
        MeshDefinition meshdefinition = HorseModel.createFullScaleBabyMesh((CubeDeformation)scale);
        PartDefinition root = meshdefinition.getRoot();
        root.addOrReplaceChild("horn", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -16.0f, 2.0f, 2.0f, 7.0f, 2.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)-10.0f));
        return meshdefinition;
    }

    public static MeshDefinition createBabyUniMesh(CubeDeformation scale) {
        return BABY_TRANSFORMER.apply(UnicornModel.createFullScaleBabyUniMesh(scale));
    }

    public void setupAnim(EquineRenderState state) {
        super.setupAnim(state);
        this.horn.y = this.headParts.y;
        this.horn.z = this.headParts.z;
        this.horn.copyFrom(this.headParts);
    }
}

