/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.client.render.tile;

import com.legacy.good_nights_sleep.client.render.GNSRenderRefs;
import com.legacy.good_nights_sleep.registry.GNSBlockEntityTypes;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.tile_entity.DreamBedBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Set;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GNSBedBlockEntityRenderer
implements BlockEntityRenderer<DreamBedBlockEntity> {
    private final Model headModel;
    private final Model footModel;

    public GNSBedBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this(context.getModelSet());
    }

    public GNSBedBlockEntityRenderer(EntityModelSet modelSet) {
        this.headModel = new Model.Simple(modelSet.bakeLayer(ModelLayers.BED_HEAD), RenderType::entitySolid);
        this.footModel = new Model.Simple(modelSet.bakeLayer(ModelLayers.BED_FOOT), RenderType::entitySolid);
    }

    public void render(DreamBedBlockEntity bed, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight, int packedOverlay, Vec3 cameraPos) {
        Material material = bed.getBlockState().is(GNSBlocks.luxurious_bed) ? GNSRenderRefs.LUXURIOUS_BED_MATERIAL : (bed.getBlockState().is(GNSBlocks.wretched_bed) ? GNSRenderRefs.WRETCHED_BED_MATERIAL : GNSRenderRefs.STRANGE_BED_MATERIAL);
        Level level = bed.getLevel();
        if (level != null) {
            BlockState blockstate = bed.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = DoubleBlockCombiner.combineWithNeigbour(GNSBlockEntityTypes.DREAM_BED.get(), BedBlock::getBlockType, BedBlock::getConnectedDirection, (Property)ChestBlock.FACING, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)bed.getBlockPos(), (p_112202_, p_112203_) -> false);
            int i = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(packedLight);
            this.renderPiece(stack, buffer, blockstate.getValue((Property)BedBlock.PART) == BedPart.HEAD ? this.headModel : this.footModel, (Direction)blockstate.getValue((Property)BedBlock.FACING), material, i, packedOverlay, false);
        } else {
            this.renderPiece(stack, buffer, this.headModel, Direction.SOUTH, material, packedLight, packedOverlay, false);
            this.renderPiece(stack, buffer, this.footModel, Direction.SOUTH, material, packedLight, packedOverlay, true);
        }
    }

    public void renderInHand(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Material material) {
        this.renderPiece(poseStack, bufferSource, this.headModel, Direction.SOUTH, material, packedLight, packedOverlay, false);
        this.renderPiece(poseStack, bufferSource, this.footModel, Direction.SOUTH, material, packedLight, packedOverlay, true);
    }

    private void renderPiece(PoseStack poseStack, MultiBufferSource bufferSource, Model model, Direction direction, Material material, int packedLight, int packedOverlay, boolean isFeet) {
        poseStack.pushPose();
        GNSBedBlockEntityRenderer.preparePose(poseStack, isFeet, direction);
        VertexConsumer vertexconsumer = material.buffer(bufferSource, RenderType::entitySolid);
        model.renderToBuffer(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    private static void preparePose(PoseStack p_428361_, boolean p_428252_, Direction p_428231_) {
        p_428361_.translate(0.0f, 0.5625f, p_428252_ ? -1.0f : 0.0f);
        p_428361_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        p_428361_.translate(0.5f, 0.5f, 0.5f);
        p_428361_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f + p_428231_.toYRot()));
        p_428361_.translate(-0.5f, -0.5f, -0.5f);
    }

    public void getExtents(Set<Vector3f> p_428359_) {
        PoseStack posestack = new PoseStack();
        GNSBedBlockEntityRenderer.preparePose(posestack, false, Direction.SOUTH);
        this.headModel.root().getExtentsForGui(posestack, p_428359_);
        posestack.setIdentity();
        GNSBedBlockEntityRenderer.preparePose(posestack, true, Direction.SOUTH);
        this.footModel.root().getExtentsForGui(posestack, p_428359_);
    }
}

