/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.client.resource_pack;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.locating.IModFile;

public class GNSResourcePackHandler {
    public static final Pack LEGACY_PACK = GNSResourcePackHandler.createPack(Component.literal((String)"Good Night's Sleep Programmer Art"), "legacy_pack").hidden();

    public static void packRegistry(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            // empty if block
        }
    }

    private static void register(AddPackFindersEvent event, MutableComponent name, String folder) {
        event.addRepositorySource(consumer -> consumer.accept(GNSResourcePackHandler.createPack(name, folder)));
    }

    public static Pack createPack(MutableComponent name, String folder) {
        IModFile file = ModList.get().getModFileById(GNSResourcePackHandler.modid()).getFile();
        PackLocationInfo loc = new PackLocationInfo(GNSResourcePackHandler.modid() + ":" + folder, (Component)name, PackSource.BUILT_IN, Optional.empty());
        PathPackResources packResources = new PathPackResources(loc, file.findResource(new String[]{"assets/" + GNSResourcePackHandler.modid() + "/" + folder}));
        return Pack.readMetaAndCreate((PackLocationInfo)loc, (Pack.ResourcesSupplier)BuiltInPackSource.fixedResources((PackResources)packResources), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
    }

    private static String modid() {
        return "good_nights_sleep";
    }
}

