/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.commands;

import com.legacy.good_nights_sleep.capabillity.DreamPlayer;
import com.legacy.good_nights_sleep.registry.GNSDimensions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class GNSCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = Commands.literal((String)"good_nights_sleep");
        LiteralArgumentBuilder setProgression = (LiteralArgumentBuilder)Commands.literal((String)"remaining_time").requires(GNSCommand::isOp);
        setProgression.then(Commands.literal((String)"add").then(Commands.argument((String)"time", (ArgumentType)TimeArgument.time()).executes(context -> GNSCommand.setTime((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), false))));
        setProgression.then(Commands.literal((String)"remove").then(Commands.argument((String)"time", (ArgumentType)TimeArgument.time()).executes(context -> GNSCommand.setTime((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), true))));
        command.then((ArgumentBuilder)setProgression);
        dispatcher.register(command);
    }

    private static boolean isOp(CommandSourceStack source) {
        return source.hasPermission(2);
    }

    private static int setTime(CommandContext<CommandSourceStack> context, int time, boolean isRemoving) {
        try {
            DreamPlayer player = DreamPlayer.get((Player)((CommandSourceStack)context.getSource()).getPlayerOrException());
            if (((CommandSourceStack)context.getSource()).getPlayer() != null) {
                if (!GNSDimensions.inSleepDimension((Entity)player.getPlayer())) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Player is not inside a dream dimension."), true);
                    return 0;
                }
                long newTime = player.getEnteredDreamTime() + (long)(isRemoving ? -time : time);
                boolean capped = false;
                if (!isRemoving && newTime > player.getPlayer().level().getGameTime()) {
                    capped = true;
                    newTime = player.getPlayer().level().getGameTime();
                }
                player.setEnteredDreamTime(newTime);
                player.syncDataToClient();
                boolean capFinal = capped;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Modified dream time for " + ((CommandSourceStack)context.getSource()).getPlayer().getName().getString() + (capFinal ? " (Limit reached, capped at the maximum.)" : ""))), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"That command needs to be run by a player."), true);
            return 0;
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"That command needs to be run by a player."), true);
            return 0;
        }
    }
}

