/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.registry.GNSDimensions;
import com.legacy.good_nights_sleep.registry.GNSEntityTypes;
import com.legacy.good_nights_sleep.registry.GNSItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.TameAnimalTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GNSAdvancementProv
extends AdvancementProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static AdvancementHolder root;
    public static AdvancementHolder enterDream;
    public static AdvancementHolder eatRainbowBerries;
    public static AdvancementHolder killBabyCreeper;
    public static AdvancementHolder obtainSpectriteIngot;
    public static AdvancementHolder obtainPositite;
    public static AdvancementHolder obtainPotOfGold;
    public static AdvancementHolder obtainPresent;
    public static AdvancementHolder tameUnicorn;
    public static AdvancementHolder enterNightmare;
    public static AdvancementHolder killTormenter;
    public static AdvancementHolder obtainZitriteIngot;
    public static AdvancementHolder obtainZitriteSword;
    public static AdvancementHolder obtainNegatite;
    public static AdvancementHolder killHerobrine;

    public GNSAdvancementProv(DataGenerator gen, CompletableFuture<HolderLookup.Provider> lookup) {
        super(gen.getPackOutput(), lookup, List.of(new Adv()));
    }

    private static class Adv
    implements AdvancementSubProvider {
        private Adv() {
        }

        public void generate(HolderLookup.Provider lookup, Consumer<AdvancementHolder> saver) {
            HolderLookup.RegistryLookup blockReg = lookup.lookupOrThrow(Registries.BLOCK);
            HolderLookup.RegistryLookup itemReg = lookup.lookupOrThrow(Registries.ITEM);
            HolderLookup.RegistryLookup entityReg = lookup.lookupOrThrow(Registries.ENTITY_TYPE);
            root = this.builder((ItemLike)GNSItems.strange_bed, "root", GoodNightSleep.locate("block/dream_dirt"), AdvancementType.TASK, false, false, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("dream", this.changeDim(GNSDimensions.dreamKey())).addCriterion("nightmare", this.changeDim(GNSDimensions.nightmareKey())).save(saver, GoodNightSleep.find("root"));
            enterDream = this.builder((ItemLike)GNSItems.luxurious_bed, "dream", AdvancementType.TASK, true, true, false).parent(root).addCriterion("dream", this.changeDim(GNSDimensions.dreamKey())).save(saver, GoodNightSleep.find("enter_dream"));
            eatRainbowBerries = this.builder((ItemLike)GNSItems.rainbow_berries, "eat_rainbow_berry", AdvancementType.TASK, true, true, false).parent(enterDream).addCriterion("eat", ConsumeItemTrigger.TriggerInstance.usedItem((HolderGetter)itemReg, (ItemLike)GNSItems.rainbow_berries)).save(saver, GoodNightSleep.find("eat_rainbow_berries"));
            killBabyCreeper = this.builder((ItemLike)GNSItems.baby_creeper_spawn_egg, "kill_baby_creeper", AdvancementType.TASK, true, true, false).parent(enterDream).addCriterion("kill_creeper", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityReg, GNSEntityTypes.BABY_CREEPER))).save(saver, GoodNightSleep.find("kill_baby_creeper"));
            obtainSpectriteIngot = this.builder((ItemLike)GNSItems.spectrite_ingot, "obtain_spectrite_ingot", AdvancementType.TASK, true, true, false).parent(killBabyCreeper).addCriterion("collect_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{GNSItems.spectrite_ingot})).save(saver, GoodNightSleep.find("obtain_rainbow_ingot"));
            obtainPositite = this.builder((ItemLike)GNSItems.positite, "obtain_positite", AdvancementType.GOAL, true, true, false).parent(obtainSpectriteIngot).addCriterion("collect_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{GNSItems.positite})).save(saver, GoodNightSleep.find("obtain_positite"));
            obtainPotOfGold = this.builder((ItemLike)GNSBlocks.pot_of_gold, "obtain_pot_of_gold", AdvancementType.TASK, true, true, false).parent(obtainSpectriteIngot).addCriterion("collect_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{GNSBlocks.pot_of_gold})).save(saver, GoodNightSleep.find("obtain_pot_of_gold"));
            obtainPresent = this.builder((ItemLike)GNSBlocks.present, "obtain_present", AdvancementType.TASK, true, true, false).parent(obtainSpectriteIngot).addCriterion("collect_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{GNSBlocks.present})).save(saver, GoodNightSleep.find("obtain_present"));
            tameUnicorn = this.builder((ItemLike)Items.SADDLE, "tame_unicorn", AdvancementType.TASK, true, true, false).parent(enterDream).addCriterion("tame", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of((HolderGetter)entityReg, GNSEntityTypes.UNICORN)))).save(saver, GoodNightSleep.find("tame_unicorn"));
            enterNightmare = this.builder((ItemLike)GNSItems.wretched_bed, "nightmare", AdvancementType.TASK, true, true, false).parent(root).addCriterion("nightmare", this.changeDim(GNSDimensions.nightmareKey())).save(saver, GoodNightSleep.find("enter_nightmare"));
            killTormenter = this.builder((ItemLike)GNSItems.necrum, "kill_tormenter", AdvancementType.TASK, true, true, false).parent(enterNightmare).addCriterion("kill_tormenter", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityReg, GNSEntityTypes.TORMENTER))).save(saver, GoodNightSleep.find("kill_tormeter"));
            obtainZitriteIngot = this.builder((ItemLike)GNSItems.zitrite_ingot, "obtain_zitrite_ingot", AdvancementType.TASK, true, true, false).parent(killTormenter).addCriterion("collect_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{GNSItems.zitrite_ingot})).save(saver, GoodNightSleep.find("obtain_zitrite_ingot"));
            obtainZitriteSword = this.builder((ItemLike)GNSItems.zitrite_sword, "obtain_zitrite_sword", AdvancementType.TASK, true, true, false).parent(obtainZitriteIngot).addCriterion("collect_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{GNSItems.zitrite_sword})).save(saver, GoodNightSleep.find("obtain_zitrite_sword"));
            obtainNegatite = this.builder((ItemLike)GNSItems.negatite, "obtain_negatite", AdvancementType.GOAL, true, true, false).parent(obtainZitriteIngot).addCriterion("collect_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{GNSItems.negatite})).save(saver, GoodNightSleep.find("obtain_negatite"));
            killHerobrine = this.builder((ItemLike)GNSItems.negatite_sword, "kill_herobrine", AdvancementType.CHALLENGE, true, true, false).parent(killTormenter).addCriterion("kill_herobrine", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityReg, GNSEntityTypes.HEROBRINE))).save(saver, GoodNightSleep.find("kill_herobrine"));
        }

        private Criterion<ChangeDimensionTrigger.TriggerInstance> changeDim(ResourceKey<Level> type) {
            return ChangeDimensionTrigger.TriggerInstance.changedDimensionTo(type);
        }

        private Component translate(String key) {
            return Component.translatable((String)("advancements.good_nights_sleep." + key));
        }

        private Advancement.Builder builder(ItemStack displayItem, String name, ResourceLocation background, AdvancementType AdvancementType2, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.advancement().display(displayItem, this.translate(name + ".title"), this.translate(name + ".desc"), background, AdvancementType2, showToast, announceToChat, hidden);
        }

        private Advancement.Builder builder(ItemLike displayItem, String name, ResourceLocation background, AdvancementType AdvancementType2, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.advancement().display(displayItem, this.translate(name + ".title"), this.translate(name + ".desc"), background, AdvancementType2, showToast, announceToChat, hidden);
        }

        private Advancement.Builder builder(ItemStack displayItem, String name, AdvancementType AdvancementType2, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.builder(displayItem, name, (ResourceLocation)null, AdvancementType2, showToast, announceToChat, hidden);
        }

        private Advancement.Builder builder(ItemLike displayItem, String name, AdvancementType AdvancementType2, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.builder(displayItem, name, (ResourceLocation)null, AdvancementType2, showToast, announceToChat, hidden);
        }
    }
}

