/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.data;

import com.legacy.good_nights_sleep.registry.GNSEntityTypes;
import com.legacy.good_nights_sleep.registry.GNSFeatures;
import com.legacy.good_nights_sleep.registry.GNSSounds;
import com.legacy.good_nights_sleep.util.Pointer;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.util.Lazy;

public class GNSBiomeProv {
    public static final Lazy<Music> DREAM = Lazy.of(() -> new Music(GNSSounds.MUSIC_DREAM, 1200, 1500, true));
    public static final Lazy<Music> NIGHTMARE = Lazy.of(() -> new Music(GNSSounds.MUSIC_NIGHTMARE, 1300, 1800, true));
    private static final int NIGHTMARE_SKY = 9193801;

    public static Biome sleepyHills(BootstrapContext<?> bootstrap, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, 5, new MobSpawnSettings.SpawnerData(GNSEntityTypes.UNICORN, 1, 4));
        spawns.addSpawn(MobCategory.MONSTER, 10, new MobSpawnSettings.SpawnerData(GNSEntityTypes.BABY_CREEPER, 1, 4));
        RegistrarBuilder builder = new RegistrarBuilder((HolderGetter<PlacedFeature>)bootstrap.lookup(Registries.PLACED_FEATURE), bootstrap.lookup(Registries.CONFIGURED_CARVER));
        GNSFeatures.addDreamTrees(builder);
        GNSFeatures.addHugeHopeMushrooms(builder);
        GNSFeatures.addScatteredDreamFeatures(builder);
        GNSFeatures.addDreamOres(builder);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.DREAM_GRASS_NOISE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.DREAM_FLOWERS_3);
        GNSFeatures.addCarvers(builder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(tempIn).downfall(downfallIn).specialEffects(new BiomeSpecialEffects.Builder().grassColorOverride(0xFFFFFF).waterColor(waterColorIn).waterFogColor(waterFogColorIn).fogColor(12638463).skyColor(GNSBiomeProv.calculateSkyColor(tempIn)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawns.build()).generationSettings(builder.build()).build();
    }

    public static Biome goodDreamPlains(BootstrapContext<?> bootstrap, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, 5, new MobSpawnSettings.SpawnerData(GNSEntityTypes.UNICORN, 1, 4));
        spawns.addSpawn(MobCategory.MONSTER, 10, new MobSpawnSettings.SpawnerData(GNSEntityTypes.BABY_CREEPER, 1, 4));
        RegistrarBuilder builder = new RegistrarBuilder((HolderGetter<PlacedFeature>)bootstrap.lookup(Registries.PLACED_FEATURE), bootstrap.lookup(Registries.CONFIGURED_CARVER));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.PLAINS_DIAMOND_TREE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.PLAINS_HOPE_MUSHROOM);
        GNSFeatures.addScatteredDreamFeatures(builder);
        GNSFeatures.addDreamOres(builder);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.DREAM_GRASS_NOISE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.DREAM_FLOWERS_3);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.DREAM_LOLLIPOPS_5);
        GNSFeatures.addCarvers(builder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(tempIn).downfall(downfallIn).specialEffects(new BiomeSpecialEffects.Builder().grassColorOverride(0xFFFFFF).waterColor(waterColorIn).waterFogColor(waterFogColorIn).fogColor(12638463).skyColor(GNSBiomeProv.calculateSkyColor(tempIn)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawns.build()).generationSettings(builder.build()).build();
    }

    public static Biome dreamyForest(BootstrapContext<?> bootstrap, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.MONSTER, 10, new MobSpawnSettings.SpawnerData(GNSEntityTypes.BABY_CREEPER, 1, 4));
        RegistrarBuilder builder = new RegistrarBuilder((HolderGetter<PlacedFeature>)bootstrap.lookup(Registries.PLACED_FEATURE), bootstrap.lookup(Registries.CONFIGURED_CARVER));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.FOREST_DREAM_TREE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.FOREST_CANDY_TREE);
        GNSFeatures.addDreamSponges(builder);
        GNSFeatures.addDreamOres(builder);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.DREAM_GRASS_NOISE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.DREAM_FLOWERS_3);
        GNSFeatures.addCarvers(builder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(tempIn).downfall(downfallIn).specialEffects(new BiomeSpecialEffects.Builder().grassColorOverride(0xFFFFFF).waterColor(waterColorIn).waterFogColor(waterFogColorIn).fogColor(12638463).skyColor(GNSBiomeProv.calculateSkyColor(tempIn)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawns.build()).generationSettings(builder.build()).build();
    }

    public static Biome lollipopLands(BootstrapContext<?> bootstrap, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.MONSTER, 10, new MobSpawnSettings.SpawnerData(GNSEntityTypes.BABY_CREEPER, 1, 4));
        RegistrarBuilder builder = new RegistrarBuilder((HolderGetter<PlacedFeature>)bootstrap.lookup(Registries.PLACED_FEATURE), bootstrap.lookup(Registries.CONFIGURED_CARVER));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.LANDS_CANDY_TREE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.LANDS_DREAM_TREE);
        GNSFeatures.addDreamSponges(builder);
        GNSFeatures.addDreamOres(builder);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.DREAM_GRASS_NOISE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.DREAM_FLOWERS_3);
        GNSFeatures.addCarvers(builder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(tempIn).downfall(downfallIn).specialEffects(new BiomeSpecialEffects.Builder().grassColorOverride(0xFFFFCC).waterColor(waterColorIn).waterFogColor(waterFogColorIn).fogColor(12638463).skyColor(GNSBiomeProv.calculateSkyColor(tempIn)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawns.build()).generationSettings(builder.build()).build();
    }

    public static Biome nightmareMound(BootstrapContext<?> bootstrap, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
        MobSpawnSettings.Builder spawns = GNSBiomeProv.getDefaultNightmareSpawns();
        RegistrarBuilder builder = new RegistrarBuilder((HolderGetter<PlacedFeature>)bootstrap.lookup(Registries.PLACED_FEATURE), bootstrap.lookup(Registries.CONFIGURED_CARVER));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.HILLS_DEAD_TREE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.HILLS_BLOOD_TREE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.HUGE_DESPAIR_MUSHROOM);
        GNSFeatures.addScatteredNightmareFeatures(builder);
        GNSFeatures.addNightmareOres(builder);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.NIGHTMARE_GRASS_NOISE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.PRICKLY_NIGHTMARE_GRASS_3);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.NIGHTMARE_FLOWERS_5);
        GNSFeatures.addCarvers(builder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)builder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(tempIn).downfall(downfallIn).specialEffects(new BiomeSpecialEffects.Builder().waterColor(waterColorIn).waterFogColor(waterFogColorIn).fogColor(0x330808).skyColor(9193801).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawns.build()).generationSettings(builder.build()).build();
    }

    public static Biome shamefulPlains(BootstrapContext<?> bootstrap, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
        MobSpawnSettings.Builder spawns = GNSBiomeProv.getDefaultNightmareSpawns();
        spawns.addSpawn(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE_HORSE, 1, 3));
        spawns.addSpawn(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.SKELETON_HORSE, 1, 3));
        RegistrarBuilder builder = new RegistrarBuilder((HolderGetter<PlacedFeature>)bootstrap.lookup(Registries.PLACED_FEATURE), bootstrap.lookup(Registries.CONFIGURED_CARVER));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.PLAINS_BLOOD_TREE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.PLAINS_DESPAIR_MUSHROOM);
        GNSFeatures.addScatteredNightmareFeatures(builder);
        GNSFeatures.addNightmareOres(builder);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.NIGHTMARE_GRASS_NOISE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.PRICKLY_NIGHTMARE_GRASS_5);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.NIGHTMARE_FLOWERS_5);
        GNSFeatures.addCarvers(builder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)builder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(tempIn).downfall(downfallIn).specialEffects(new BiomeSpecialEffects.Builder().waterColor(waterColorIn).waterFogColor(waterFogColorIn).fogColor(0x330808).skyColor(9193801).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawns.build()).generationSettings(builder.build()).build();
    }

    public static Biome wastedForest(BootstrapContext<?> bootstrap, float tempIn, float downfallIn, int waterColorIn, int waterFogColorIn) {
        MobSpawnSettings.Builder spawns = GNSBiomeProv.getDefaultNightmareSpawns();
        RegistrarBuilder builder = new RegistrarBuilder((HolderGetter<PlacedFeature>)bootstrap.lookup(Registries.PLACED_FEATURE), bootstrap.lookup(Registries.CONFIGURED_CARVER));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.FOREST_DEAD_TREE);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.FOREST_BLOOD_TREE);
        GNSFeatures.addScatteredNightmareFeatures(builder);
        GNSFeatures.addNightmareOres(builder);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.NIGHTMARE_GRASS_5);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.PRICKLY_NIGHTMARE_GRASS_5);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, GNSFeatures.Placements.NIGHTMARE_FLOWERS_5);
        GNSFeatures.addCarvers(builder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)builder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(tempIn).downfall(downfallIn).specialEffects(new BiomeSpecialEffects.Builder().waterColor(waterColorIn).waterFogColor(waterFogColorIn).fogColor(0x330808).skyColor(9193801).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(spawns.build()).generationSettings(builder.build()).build();
    }

    private static MobSpawnSettings.Builder getDefaultNightmareSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        spawns.addSpawn(MobCategory.MONSTER, 100, new MobSpawnSettings.SpawnerData(GNSEntityTypes.TORMENTER, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, 10, new MobSpawnSettings.SpawnerData(GNSEntityTypes.HEROBRINE, 1, 1));
        spawns.addSpawn(MobCategory.MONSTER, 100, new MobSpawnSettings.SpawnerData(EntityType.SPIDER, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, 95, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, 5, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE_VILLAGER, 1, 1));
        spawns.addSpawn(MobCategory.MONSTER, 100, new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, 100, new MobSpawnSettings.SpawnerData(EntityType.CREEPER, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, 100, new MobSpawnSettings.SpawnerData(EntityType.SLIME, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, 10, new MobSpawnSettings.SpawnerData(EntityType.ENDERMAN, 1, 4));
        spawns.addSpawn(MobCategory.MONSTER, 5, new MobSpawnSettings.SpawnerData(EntityType.WITCH, 1, 1));
        spawns.addSpawn(MobCategory.MONSTER, 30, new MobSpawnSettings.SpawnerData(EntityType.GHAST, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, 30, new MobSpawnSettings.SpawnerData(EntityType.ZOMBIFIED_PIGLIN, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, 2, new MobSpawnSettings.SpawnerData(EntityType.MAGMA_CUBE, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, 5, new MobSpawnSettings.SpawnerData(EntityType.SILVERFISH, 4, 4));
        return spawns;
    }

    private static int calculateSkyColor(float tempIn) {
        float lvt_1_1_ = tempIn / 3.0f;
        lvt_1_1_ = Mth.clamp((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }

    public static class RegistrarBuilder
    extends BiomeGenerationSettings.Builder {
        public RegistrarBuilder(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
            super(featureGetter, carverGetter);
        }

        public BiomeGenerationSettings.Builder addFeature(GenerationStep.Decoration step, Pointer<PlacedFeature> registrar) {
            return super.addFeature(step, registrar.getKey());
        }
    }
}

