/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.data;

import com.legacy.good_nights_sleep.blocks.GNSBedBlock;
import com.legacy.good_nights_sleep.blocks.natural.RainbowBerriesBlock;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.registry.GNSEntityTypes;
import com.legacy.good_nights_sleep.registry.GNSItems;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaEntityLoot;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class GNSLootProv
extends LootTableProvider {
    public GNSLootProv(DataGenerator gen, CompletableFuture<HolderLookup.Provider> lookup) {
        super(gen.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(GNSBlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(GNSEntityLoot::new, LootContextParamSets.ENTITY)), lookup);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        writableregistry.listElements().forEach(lootTable -> ((LootTable)lootTable.value()).validate(validationcontext.setContextKeySet(((LootTable)lootTable.value()).getParamSet()).enterElement((ProblemReporter.PathElement)new ProblemReporter.RootElementPathElement(lootTable.key()), lootTable.key())));
    }

    public static interface LootPoolUtil {
        default public LootTable.Builder tableOf(List<LootPool.Builder> pools) {
            LootTable.Builder table = LootTable.lootTable();
            pools.forEach(pool -> table.withPool(pool));
            return table;
        }

        default public LootTable.Builder tableOf(LootPool.Builder pool) {
            return LootTable.lootTable().withPool(pool);
        }

        default public LootPool.Builder basicPool(ItemLike item, int min, int max) {
            return LootPool.lootPool().add(this.basicEntry(item, min, max));
        }

        default public LootPool.Builder basicPool(ItemLike item) {
            return LootPool.lootPool().add(this.basicEntry(item));
        }

        default public LootPool.Builder randItemPool(List<ItemLike> items) {
            return this.poolOf(items.stream().map(i -> this.basicEntry((ItemLike)i)).collect(Collectors.toList()));
        }

        default public LootPool.Builder poolOf(List<LootPoolEntryContainer.Builder<?>> lootEntries) {
            LootPool.Builder pool = LootPool.lootPool();
            lootEntries.forEach(entry -> pool.add(entry));
            return pool;
        }

        default public LootPoolSingletonContainer.Builder<?> basicEntry(ItemLike item, int min, int max) {
            return this.basicEntry(item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)));
        }

        default public LootPoolSingletonContainer.Builder<?> basicEntry(ItemLike item) {
            return LootItem.lootTableItem((ItemLike)item);
        }
    }

    private static class GNSBlockLoot
    extends BlockLootSubProvider {
        private float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        protected GNSBlockLoot(HolderLookup.Provider lookup) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookup);
        }

        protected void generate() {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.blocks().forEach(block -> {
                if (block == GNSBlocks.short_dream_grass) {
                    this.add((Block)block, this.dropRainbowSeeds((Block)block));
                } else if (block == GNSBlocks.short_nightmare_grass) {
                    this.add((Block)block, this.createGrassDrops((Block)block));
                } else if (block == GNSBlocks.prickly_nightmare_grass) {
                    this.add((Block)block, this.createGrassDrops((Block)block));
                } else if (block == GNSBlocks.dream_grass_block) {
                    this.silkOrElse((Block)block, (ItemLike)GNSBlocks.dream_dirt);
                } else if (block == GNSBlocks.nightmare_grass_block) {
                    this.silkOrElse((Block)block, (ItemLike)Blocks.DIRT);
                } else if (block == GNSBlocks.dream_farmland) {
                    this.dropOther((Block)block, (ItemLike)GNSBlocks.dream_dirt);
                } else if (block == GNSBlocks.delusion_stone) {
                    this.silkOrElse((Block)block, (ItemLike)GNSBlocks.delusion_cobblestone);
                } else if (block == GNSBlocks.dream_leaves) {
                    this.add((Block)block, b -> this.leaves((Block)b, (ItemLike)GNSBlocks.dream_sapling, (ItemLike)Items.STICK));
                } else if (block == GNSBlocks.candy_leaves) {
                    this.add((Block)block, b -> this.leaves((Block)b, (ItemLike)GNSBlocks.candy_sapling, (ItemLike)Items.STICK));
                } else if (block == GNSBlocks.diamond_leaves) {
                    this.add((Block)block, b -> this.leaves((Block)b, (ItemLike)GNSBlocks.dream_sapling, (ItemLike)Items.STICK));
                } else if (block instanceof SlabBlock) {
                    this.add((Block)block, this.createSlabItemTable((Block)block));
                } else if (block == GNSBlocks.candy_ore) {
                    this.add((Block)block, b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)GNSItems.candy).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))))));
                } else if (block == GNSBlocks.fossilized_necrum) {
                    this.add((Block)block, b -> this.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)GNSItems.necrum).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))))));
                } else if (block == GNSBlocks.positite_ore) {
                    this.add((Block)block, b -> this.createOreDrop((Block)b, GNSItems.positite));
                } else if (block == GNSBlocks.negatite_ore) {
                    this.add((Block)block, b -> this.createOreDrop((Block)b, GNSItems.negatite));
                } else if (block == GNSBlocks.zitrite_ore) {
                    this.add((Block)block, b -> this.createOreDrop((Block)b, GNSItems.raw_zitrite));
                } else if (block == GNSBlocks.spectrite_ore) {
                    this.add((Block)block, b -> this.dropRainbow((Block)b));
                } else if (block == GNSBlocks.present) {
                    this.add((Block)block, b -> this.dropPresent((Block)b));
                } else if (block instanceof DoorBlock) {
                    this.add((Block)block, b -> this.createSinglePropConditionTable((Block)b, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
                } else if (block instanceof FlowerPotBlock) {
                    this.dropPottedContents((Block)block);
                } else if (block == GNSBlocks.delusion_lapis_ore) {
                    this.add((Block)block, b -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.LAPIS_LAZULI).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)9.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))))));
                } else if (block == GNSBlocks.delusion_coal_ore) {
                    this.add((Block)block, b -> this.createOreDrop((Block)block, Items.COAL));
                } else if (block == GNSBlocks.hope_mushroom_block) {
                    this.add((Block)block, b -> this.createMushroomBlockDrop((Block)b, (ItemLike)GNSBlocks.hope_mushroom));
                } else if (block == GNSBlocks.despair_mushroom_block) {
                    this.add((Block)block, b -> this.createMushroomBlockDrop((Block)b, (ItemLike)GNSBlocks.despair_mushroom));
                } else if (block instanceof GNSBedBlock) {
                    this.add((Block)block, bed -> this.createSinglePropConditionTable((Block)bed, (Property)GNSBedBlock.PART, (Comparable)BedPart.HEAD));
                } else if (block instanceof RainbowBerriesBlock) {
                    LootItemBlockStatePropertyCondition.Builder growthCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)RainbowBerriesBlock.AGE, ((RainbowBerriesBlock)((Object)block)).getMaxAge()));
                    if (block == GNSBlocks.rainbow_berries) {
                        this.add((Block)block, arg_0 -> this.lambda$generate$16((LootItemCondition.Builder)growthCondition, arg_0));
                    }
                } else {
                    this.dropSelf((Block)block);
                }
            });
        }

        protected LootTable.Builder dropRainbow(Block block) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)GNSItems.raw_spectrite).setWeight(50))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RAW_GOLD).setWeight(10))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RAW_IRON).setWeight(10))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).setWeight(1))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)GNSItems.candy).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))));
        }

        protected LootTable.Builder dropPresent(Block block) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)GNSItems.spectrite_ingot).setWeight(30))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(10))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_INGOT).setWeight(10))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).setWeight(5))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)GNSItems.candy).setWeight(30).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)GNSItems.positite).setWeight(5))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.blocks()::iterator;
        }

        private Stream<Block> blocks() {
            return BuiltInRegistries.BLOCK.stream().filter(b -> BuiltInRegistries.BLOCK.getKey(b).getNamespace().equals("good_nights_sleep") && (b.asItem() != Blocks.AIR.asItem() || b instanceof FlowerPotBlock));
        }

        private void droppingSeedTag(Block block, TagKey<Item> tag) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.add(block, this.createShearsDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)TagEntry.expandTag(tag).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (int)2)))));
        }

        protected LootTable.Builder dropRainbowSeeds(Block block) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return this.createShearsDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)GNSItems.rainbow_seeds).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (int)2))));
        }

        private void silkOrElse(Block withSilk, ItemLike without) {
            this.add(withSilk, b -> this.createSingleItemTableWithSilkTouch((Block)b, without));
        }

        private LootTable.Builder leaves(Block block, ItemLike sapling, ItemLike stick) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return this.createSilkTouchOrShearsDispatchTable(block, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)sapling))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])this.DEFAULT_SAPLING_DROP_RATES))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.hasShears().invert()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)stick).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }

        private LootTable.Builder leavesFruit(Block block, ItemLike sapling, ItemLike stick, ItemLike fruit) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            float baseChance = 0.05f;
            float[] fortuneChances = new float[]{1.1111112f, 1.25f, 1.6666667f, 5.0f};
            return this.leaves(block, sapling, stick).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)this.hasShears().invert().and(this.doesNotHaveSilkTouch())).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)fruit))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{baseChance, baseChance * fortuneChances[0], baseChance * fortuneChances[1], baseChance * fortuneChances[2], baseChance * fortuneChances[3]}))));
        }

        private LootTable.Builder crop(LootItemCondition.Builder growthCondition, Block block, ItemLike food) {
            return this.crop(growthCondition, block, food, food);
        }

        private LootTable.Builder crop(LootItemCondition.Builder growthCondition, Block block, ItemLike food, ItemLike seed) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            LootPool.Builder seedPool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seed).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3).when(growthCondition)));
            LootPool.Builder foodPool = LootPool.lootPool().when(growthCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)food).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)1)));
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(seedPool).withPool(foodPool));
        }

        private /* synthetic */ LootTable.Builder lambda$generate$16(LootItemCondition.Builder growthCondition, Block b) {
            return this.crop(growthCondition, b, (ItemLike)GNSItems.rainbow_berries, (ItemLike)GNSItems.rainbow_seeds);
        }
    }

    private static class GNSEntityLoot
    extends VanillaEntityLoot
    implements LootPoolUtil {
        public GNSEntityLoot(HolderLookup.Provider registries) {
            super(registries);
        }

        public void generate() {
            HolderLookup.RegistryLookup entityReg = this.registries.lookupOrThrow(Registries.ENTITY_TYPE);
            this.add(GNSEntityTypes.UNICORN, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add(GNSEntityTypes.BABY_CREEPER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GUNPOWDER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)TagEntry.expandTag((TagKey)ItemTags.CREEPER_DROP_MUSIC_DISCS)).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityReg, EntityTypeTags.SKELETONS)))));
            this.add(GNSEntityTypes.HEROBRINE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)GNSItems.negatite).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))))));
            this.add(GNSEntityTypes.TORMENTER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)GNSItems.necrum).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))))));
        }

        private LootPool.Builder lootingPool(ItemLike item, int min, int max, int minLooting, int maxLooting) {
            return this.basicPool(item, min, max).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)minLooting, (float)maxLooting)));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return BuiltInRegistries.ENTITY_TYPE.stream().filter(e -> BuiltInRegistries.ENTITY_TYPE.getKey(e).getNamespace().contains("good_nights_sleep"));
        }
    }
}

