/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.data;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.blocks.RainbowBlock;
import com.legacy.good_nights_sleep.client.GNSBlockColoring;
import com.legacy.good_nights_sleep.client.render.GNSRenderRefs;
import com.legacy.good_nights_sleep.client.render.tile.GNSBedSpecialRenderer;
import com.legacy.good_nights_sleep.data.GNSBlockFamilies;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.registry.GNSEquipmentAssets;
import com.legacy.good_nights_sleep.registry.GNSItems;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.EquipmentAssetProvider;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplate;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;

public class GNSModelProv
extends ModelProvider {
    public GNSModelProv(PackOutput output) {
        super(output, "good_nights_sleep");
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return super.run(output);
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        Items items = new Items(itemModels.itemModelOutput, itemModels.modelOutput);
        items.run();
        States states = new States(blockModels.blockStateOutput, blockModels.itemModelOutput, blockModels.modelOutput);
        states.run();
    }

    public static class Items
    extends ItemModelGenerators {
        public Items(ItemModelOutput output, BiConsumer<ResourceLocation, ModelInstance> models) {
            super(output, models);
        }

        public void run() {
            this.basicItem(GNSItems.candy);
            this.basicItem(GNSItems.lollipop);
            this.basicItem(GNSItems.powdered_sugar);
            this.basicItem(GNSItems.spectrite_ingot);
            this.basicItem(GNSItems.positite);
            this.basicItem(GNSItems.necrum);
            this.basicItem(GNSItems.necrotic_extract);
            this.basicItem(GNSItems.zitrite_ingot);
            this.basicItem(GNSItems.negatite);
            this.basicItem(GNSItems.candy_bar);
            this.basicItem(GNSItems.raw_spectrite);
            this.basicItem(GNSItems.raw_zitrite);
            this.basicItem(GNSItems.luxurious_soup);
            this.basicItem(GNSItems.wretched_soup);
            this.basicItem(GNSItems.rainbow_berries);
            this.handheldItem(GNSItems.candy_sword);
            this.handheldItem(GNSItems.candy_pickaxe);
            this.handheldItem(GNSItems.candy_axe);
            this.handheldItem(GNSItems.candy_shovel);
            this.handheldItem(GNSItems.candy_hoe);
            this.handheldItem(GNSItems.spectrite_sword);
            this.handheldItem(GNSItems.spectrite_pickaxe);
            this.handheldItem(GNSItems.spectrite_axe);
            this.handheldItem(GNSItems.spectrite_shovel);
            this.handheldItem(GNSItems.spectrite_hoe);
            this.handheldItem(GNSItems.positite_sword);
            this.handheldItem(GNSItems.positite_pickaxe);
            this.handheldItem(GNSItems.positite_axe);
            this.handheldItem(GNSItems.positite_shovel);
            this.handheldItem(GNSItems.positite_hoe);
            this.handheldItem(GNSItems.necrum_sword);
            this.handheldItem(GNSItems.necrum_pickaxe);
            this.handheldItem(GNSItems.necrum_axe);
            this.handheldItem(GNSItems.necrum_shovel);
            this.handheldItem(GNSItems.necrum_hoe);
            this.handheldItem(GNSItems.zitrite_sword);
            this.handheldItem(GNSItems.zitrite_pickaxe);
            this.handheldItem(GNSItems.zitrite_axe);
            this.handheldItem(GNSItems.zitrite_shovel);
            this.handheldItem(GNSItems.zitrite_hoe);
            this.handheldItem(GNSItems.negatite_sword);
            this.handheldItem(GNSItems.negatite_pickaxe);
            this.handheldItem(GNSItems.negatite_axe);
            this.handheldItem(GNSItems.negatite_shovel);
            this.handheldItem(GNSItems.negatite_hoe);
            this.generateTrimmableItem(GNSItems.candy_helmet, GNSEquipmentAssets.CANDY, TRIM_PREFIX_HELMET, false);
            this.generateTrimmableItem(GNSItems.candy_chestplate, GNSEquipmentAssets.CANDY, TRIM_PREFIX_CHESTPLATE, false);
            this.generateTrimmableItem(GNSItems.candy_leggings, GNSEquipmentAssets.CANDY, TRIM_PREFIX_LEGGINGS, false);
            this.generateTrimmableItem(GNSItems.candy_boots, GNSEquipmentAssets.CANDY, TRIM_PREFIX_BOOTS, false);
            this.generateTrimmableItem(GNSItems.spectrite_helmet, GNSEquipmentAssets.CANDY, TRIM_PREFIX_HELMET, false);
            this.generateTrimmableItem(GNSItems.spectrite_chestplate, GNSEquipmentAssets.CANDY, TRIM_PREFIX_CHESTPLATE, false);
            this.generateTrimmableItem(GNSItems.spectrite_leggings, GNSEquipmentAssets.CANDY, TRIM_PREFIX_LEGGINGS, false);
            this.generateTrimmableItem(GNSItems.spectrite_boots, GNSEquipmentAssets.CANDY, TRIM_PREFIX_BOOTS, false);
            this.generateTrimmableItem(GNSItems.positite_helmet, GNSEquipmentAssets.CANDY, TRIM_PREFIX_HELMET, false);
            this.generateTrimmableItem(GNSItems.positite_chestplate, GNSEquipmentAssets.CANDY, TRIM_PREFIX_CHESTPLATE, false);
            this.generateTrimmableItem(GNSItems.positite_leggings, GNSEquipmentAssets.CANDY, TRIM_PREFIX_LEGGINGS, false);
            this.generateTrimmableItem(GNSItems.positite_boots, GNSEquipmentAssets.CANDY, TRIM_PREFIX_BOOTS, false);
            this.generateTrimmableItem(GNSItems.zitrite_helmet, GNSEquipmentAssets.CANDY, TRIM_PREFIX_HELMET, false);
            this.generateTrimmableItem(GNSItems.zitrite_chestplate, GNSEquipmentAssets.CANDY, TRIM_PREFIX_CHESTPLATE, false);
            this.generateTrimmableItem(GNSItems.zitrite_leggings, GNSEquipmentAssets.CANDY, TRIM_PREFIX_LEGGINGS, false);
            this.generateTrimmableItem(GNSItems.zitrite_boots, GNSEquipmentAssets.CANDY, TRIM_PREFIX_BOOTS, false);
            this.generateTrimmableItem(GNSItems.negatite_helmet, GNSEquipmentAssets.CANDY, TRIM_PREFIX_HELMET, false);
            this.generateTrimmableItem(GNSItems.negatite_chestplate, GNSEquipmentAssets.CANDY, TRIM_PREFIX_CHESTPLATE, false);
            this.generateTrimmableItem(GNSItems.negatite_leggings, GNSEquipmentAssets.CANDY, TRIM_PREFIX_LEGGINGS, false);
            this.generateTrimmableItem(GNSItems.negatite_boots, GNSEquipmentAssets.CANDY, TRIM_PREFIX_BOOTS, false);
            this.generateLegacySpawnEgg(GNSItems.unicorn_spawn_egg, 0xFFFFFF, 14650616);
            this.generateLegacySpawnEgg(GNSItems.baby_creeper_spawn_egg, 45079, 0xFF00DD);
            this.generateLegacySpawnEgg(GNSItems.tormenter_spawn_egg, 10516796, 5525034);
            this.generateLegacySpawnEgg(GNSItems.herobrine_spawn_egg, 1598464, 30652);
        }

        @Deprecated
        public void generateLegacySpawnEgg(Item item, int base, int spots) {
            ResourceLocation model = ModelTemplates.TWO_LAYERED_ITEM.create(item, TextureMapping.layered((ResourceLocation)GoodNightSleep.locate("item/legacy_spawn_egg"), (ResourceLocation)GoodNightSleep.locate("item/legacy_spawn_egg_overlay")), this.modelOutput);
            this.itemModelOutput.accept(item, ItemModelUtils.tintedModel((ResourceLocation)model, (ItemTintSource[])new ItemTintSource[]{ItemModelUtils.constantTint((int)base), ItemModelUtils.constantTint((int)spots)}));
        }

        private void basicItem(Item item) {
            this.generateFlatItem(item, ModelTemplates.FLAT_ITEM);
        }

        private void handheldItem(Item item) {
            this.generateFlatItem(item, ModelTemplates.FLAT_HANDHELD_ITEM);
        }
    }

    public static class States
    extends BlockModelGenerators {
        public static final TextureSlot OVERLAY_SLOT = TextureSlot.create((String)"overlay");
        public static final TextureSlot PORTAL_SLOT = TextureSlot.create((String)"portal");
        public static final ModelTemplate TINTED_CROSS_OVERLAY = ModelTemplates.create((String)GoodNightSleep.find("tinted_cross_overlay"), (TextureSlot[])new TextureSlot[]{TextureSlot.CROSS, OVERLAY_SLOT}).extend().renderType("cutout").build();
        private static final ExtendedModelTemplate EW_RAINBOW = States.frontBackTemplate().element(e -> {
            e.from(6.0f, 0.0f, 0.0f).to(10.0f, 16.0f, 16.0f);
            e.face(Direction.EAST, f -> f.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(TextureSlot.FRONT));
            e.face(Direction.WEST, f -> f.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(TextureSlot.BACK));
        }).renderType("translucent").build();
        private static final ExtendedModelTemplate NS_RAINBOW = States.frontBackTemplate().element(e -> {
            e.from(0.0f, 0.0f, 6.0f).to(16.0f, 16.0f, 10.0f);
            e.face(Direction.NORTH, f -> f.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(TextureSlot.BACK));
            e.face(Direction.SOUTH, f -> f.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(TextureSlot.FRONT));
        }).renderType("translucent").build();

        public States(Consumer<BlockModelDefinitionGenerator> blockStateOutput, ItemModelOutput itemModelOutput, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
            super(blockStateOutput, itemModelOutput, modelOutput);
        }

        public void run() {
            FULL_BLOCK_MODEL_CUSTOM_GENERATORS = new HashMap(FULL_BLOCK_MODEL_CUSTOM_GENERATORS);
            FULL_BLOCK_MODEL_CUSTOM_GENERATORS.put(GNSBlocks.delusion_stone, BlockModelGenerators::createMirroredCubeGenerator);
            GNSBlockFamilies.getFamilies().stream().filter(BlockFamily::shouldGenerateModel).forEach(fam -> this.family(fam.getBaseBlock()).generateFor(fam));
            this.woodProvider(GNSBlocks.dream_log).logWithHorizontal(GNSBlocks.dream_log).wood(GNSBlocks.dream_wood);
            this.woodProvider(GNSBlocks.stripped_dream_log).logWithHorizontal(GNSBlocks.stripped_dream_log).wood(GNSBlocks.stripped_dream_wood);
            this.createHangingSign(GNSBlocks.stripped_dream_log, GNSBlocks.dream_hanging_sign, GNSBlocks.dream_wall_hanging_sign);
            this.createPlantWithDefaultItem(GNSBlocks.dream_sapling, GNSBlocks.potted_dream_sapling, BlockModelGenerators.PlantType.NOT_TINTED);
            this.createTrivialBlock(GNSBlocks.dream_leaves, TexturedModel.LEAVES);
            this.createTrivialBlock(GNSBlocks.diamond_leaves, TexturedModel.LEAVES);
            this.woodProvider(GNSBlocks.white_log).logWithHorizontal(GNSBlocks.white_log).wood(GNSBlocks.white_wood);
            this.woodProvider(GNSBlocks.stripped_white_log).logWithHorizontal(GNSBlocks.stripped_white_log).wood(GNSBlocks.stripped_white_wood);
            this.createHangingSign(GNSBlocks.stripped_white_log, GNSBlocks.white_hanging_sign, GNSBlocks.white_wall_hanging_sign);
            this.createPlantWithDefaultItem(GNSBlocks.candy_sapling, GNSBlocks.potted_candy_sapling, BlockModelGenerators.PlantType.NOT_TINTED);
            this.createTrivialBlock(GNSBlocks.candy_leaves, TexturedModel.LEAVES);
            this.woodProvider(GNSBlocks.dead_log).logWithHorizontal(GNSBlocks.dead_log).wood(GNSBlocks.dead_wood);
            this.woodProvider(GNSBlocks.stripped_dead_log).logWithHorizontal(GNSBlocks.stripped_dead_log).wood(GNSBlocks.stripped_dead_wood);
            this.createHangingSign(GNSBlocks.stripped_dead_log, GNSBlocks.dead_hanging_sign, GNSBlocks.dead_wall_hanging_sign);
            this.woodProvider(GNSBlocks.blood_log).logWithHorizontal(GNSBlocks.blood_log).wood(GNSBlocks.blood_wood);
            this.woodProvider(GNSBlocks.stripped_blood_log).logWithHorizontal(GNSBlocks.stripped_blood_log).wood(GNSBlocks.stripped_blood_wood);
            this.createHangingSign(GNSBlocks.stripped_blood_log, GNSBlocks.blood_hanging_sign, GNSBlocks.blood_wall_hanging_sign);
            this.createRotatedMirroredVariantBlock(GNSBlocks.dream_dirt);
            this.createGrassBlock(GNSBlocks.dream_grass_block, GNSBlocks.dream_dirt, new GNSBlockColoring.DreamGrassTintSource());
            this.createTexturedFarmland(GNSBlocks.dream_dirt, GNSBlocks.dream_farmland);
            this.createGrassBlock(GNSBlocks.nightmare_grass_block, Blocks.DIRT, null);
            this.createTintedCrossWithOverlay(GNSBlocks.short_dream_grass);
            this.createPlantWithItemNoPot(GNSBlocks.short_nightmare_grass);
            this.createPlantWithDefaultItem(GNSBlocks.lollipop_bush, GNSBlocks.potted_lollipop_bush, BlockModelGenerators.PlantType.NOT_TINTED);
            this.createPlantWithDefaultItem(GNSBlocks.prickly_nightmare_grass, GNSBlocks.potted_prickly_nightmare_grass, BlockModelGenerators.PlantType.NOT_TINTED);
            this.createPlantWithDefaultItem(GNSBlocks.cyan_flower, GNSBlocks.potted_cyan_flower, BlockModelGenerators.PlantType.NOT_TINTED);
            this.createPlantWithDefaultItem(GNSBlocks.orange_flower, GNSBlocks.potted_orange_flower, BlockModelGenerators.PlantType.NOT_TINTED);
            this.createPlantWithDefaultItem(GNSBlocks.dead_flower, GNSBlocks.potted_dead_flower, BlockModelGenerators.PlantType.NOT_TINTED);
            this.createPlantWithDefaultItem(GNSBlocks.hope_mushroom, GNSBlocks.potted_hope_mushroom, BlockModelGenerators.PlantType.NOT_TINTED);
            this.createPlantWithDefaultItem(GNSBlocks.despair_mushroom, GNSBlocks.potted_despair_mushroom, BlockModelGenerators.PlantType.NOT_TINTED);
            this.createMushroomBlock(GNSBlocks.hope_mushroom_block);
            this.createMushroomBlock(GNSBlocks.despair_mushroom_block);
            this.simpleBlock(GNSBlocks.delusion_coal_ore);
            this.simpleBlock(GNSBlocks.delusion_lapis_ore);
            this.simpleBlock(GNSBlocks.candy_ore);
            this.simpleBlock(GNSBlocks.hard_candy_block);
            this.simpleBlock(GNSBlocks.spectrite_ore);
            this.simpleBlock(GNSBlocks.raw_spectrite_block);
            this.simpleBlock(GNSBlocks.spectrite_block);
            this.simpleBlock(GNSBlocks.positite_ore);
            this.simpleBlock(GNSBlocks.positite_block);
            this.simpleBlock(GNSBlocks.fossilized_necrum);
            this.simpleBlock(GNSBlocks.necrum_block);
            this.simpleBlock(GNSBlocks.zitrite_ore);
            this.simpleBlock(GNSBlocks.raw_zitrite_block);
            this.simpleBlock(GNSBlocks.zitrite_block);
            this.simpleBlock(GNSBlocks.negatite_ore);
            this.simpleBlock(GNSBlocks.negatite_block);
            this.createPotOfGold();
            this.createRainbow();
            this.createTrivialBlock(GNSBlocks.present, TexturedModel.CUBE_TOP_BOTTOM);
            this.createCropBlock(GNSBlocks.rainbow_berries, (Property)BlockStateProperties.AGE_3, new int[]{0, 1, 2, 3});
            this.createDreamBed(GNSBlocks.strange_bed, GNSRenderRefs.STRANGE_BED_MATERIAL);
            this.createDreamBed(GNSBlocks.luxurious_bed, GNSRenderRefs.LUXURIOUS_BED_MATERIAL);
            this.createDreamBed(GNSBlocks.wretched_bed, GNSRenderRefs.WRETCHED_BED_MATERIAL);
        }

        public void createPlantWithItemNoPot(Block block) {
            this.createCrossBlock(block, BlockModelGenerators.PlantType.NOT_TINTED);
            this.registerSimpleItemModel(block, this.createFlatItemModelWithBlockTexture(block.asItem(), block));
        }

        public void createTintedCrossWithOverlay(Block block) {
            this.blockStateOutput.accept(States.createSimpleBlock((Block)block, (MultiVariant)States.plainVariant((ResourceLocation)TINTED_CROSS_OVERLAY.create(block, TextureMapping.cross((Block)block).put(OVERLAY_SLOT, TextureMapping.getBlockTexture((Block)block, (String)"_overlay")), this.modelOutput))));
            this.registerSimpleItemModel(block, this.createFlatItemModelWithBlockTextureAndOverlay(block.asItem(), block, "_overlay"));
        }

        public void createPotOfGold() {
            Block block = GNSBlocks.pot_of_gold;
            this.registerSimpleItemModel(block, this.createFlatItemModel(block.asItem()));
            this.blockStateOutput.accept(States.createSimpleBlock((Block)block, (MultiVariant)States.plainVariant((ResourceLocation)ModelTemplates.CAULDRON_FULL.create(block, TextureMapping.cauldron((ResourceLocation)TextureMapping.getBlockTexture((Block)block)), this.modelOutput))));
        }

        private static final ExtendedModelTemplateBuilder frontBackTemplate() {
            return ModelTemplates.create((TextureSlot[])new TextureSlot[]{TextureSlot.FRONT, TextureSlot.BACK}).extend().parent(ResourceLocation.withDefaultNamespace((String)"block/block"));
        }

        public void createRainbow() {
            Block block = GNSBlocks.rainbow;
            MultiVariant start = this.rainbowVariant("start", "end", false);
            MultiVariant startCorner = this.rainbowVariant("start_corner", "end_corner", false);
            MultiVariant top = this.rainbowVariant("top", false);
            MultiVariant endCorner = this.rainbowVariant("end_corner", "start_corner", false);
            MultiVariant end = this.rainbowVariant("end", "start", false);
            MultiVariant startEW = this.rainbowVariant("start", "end", true);
            MultiVariant startCornerEW = this.rainbowVariant("start_corner", "end_corner", true);
            MultiVariant topEW = this.rainbowVariant("top", true);
            MultiVariant endCornerEW = this.rainbowVariant("end_corner", "start_corner", true);
            MultiVariant endEW = this.rainbowVariant("end", "start", true);
            this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(PropertyDispatch.initial((Property)BlockStateProperties.HORIZONTAL_AXIS, (Property)RainbowBlock.CORNER_TYPE, (Property)RainbowBlock.SIDE_TYPE).generate((dir, cornerType, sideType) -> {
                boolean ew;
                boolean bl = ew = dir == Direction.Axis.Z;
                return cornerType == 1 ? (ew ? startCornerEW : startCorner) : (cornerType == 2 ? (ew ? endCornerEW : endCorner) : (sideType == 1 ? (ew ? topEW : top) : (sideType == 2 ? (ew ? endEW : end) : (ew ? startEW : start))));
            })));
        }

        private final MultiVariant rainbowVariant(String suffix, boolean ew) {
            return this.rainbowVariant(suffix, suffix, ew);
        }

        private final MultiVariant rainbowVariant(String suffix, String backTexSuffix, boolean ew) {
            ExtendedModelTemplate nsTemplate = NS_RAINBOW;
            ExtendedModelTemplate ewTemplate = EW_RAINBOW;
            ResourceLocation tex = TextureMapping.getBlockTexture((Block)GNSBlocks.rainbow, (String)("_" + suffix));
            ResourceLocation backTex = TextureMapping.getBlockTexture((Block)GNSBlocks.rainbow, (String)("_" + backTexSuffix));
            return States.plainVariant((ResourceLocation)(ew ? ewTemplate : nsTemplate).createWithSuffix(GNSBlocks.rainbow, "_" + suffix + "_" + (ew ? "ew" : "ns"), new TextureMapping().put(TextureSlot.FRONT, tex).put(TextureSlot.BACK, backTex).copyForced(TextureSlot.FRONT, TextureSlot.PARTICLE), this.modelOutput));
        }

        public void createBush(Block block) {
            this.createCrossBlock(block, BlockModelGenerators.PlantType.NOT_TINTED);
            this.registerSimpleItemModel(block, this.createFlatItemModelWithBlockTexture(block.asItem(), block));
        }

        public void createDreamBed(Block block, Material mat) {
            ResourceLocation resourcelocation = ModelLocationUtils.decorateBlockModelLocation((String)"bed");
            this.blockStateOutput.accept(States.createSimpleBlock((Block)block, (MultiVariant)States.plainVariant((ResourceLocation)resourcelocation)));
            Item item = block.asItem();
            ResourceLocation resourcelocation1 = ModelTemplates.BED_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.particle((Block)Blocks.OAK_PLANKS), this.modelOutput);
            this.itemModelOutput.accept(item, ItemModelUtils.specialModel((ResourceLocation)resourcelocation1, (SpecialModelRenderer.Unbaked)new GNSBedSpecialRenderer.Unbaked(mat)));
        }

        public void createPlant(Block flower, Block pot, BlockModelGenerators.PlantType type) {
            this.createCrossBlock(flower, type);
            TextureMapping texturemapping = type.getPlantTextureMapping(flower);
            ResourceLocation resourcelocation = type.getCrossPot().extend().renderType(ResourceLocation.parse((String)"cutout")).build().create(pot, texturemapping, this.modelOutput);
            this.blockStateOutput.accept(States.createSimpleBlock((Block)pot, (MultiVariant)States.plainVariant((ResourceLocation)resourcelocation)));
        }

        public void createCrossBlock(Block flower, BlockModelGenerators.PlantType type, TextureMapping mapping) {
            ResourceLocation resourcelocation = type.getCross().extend().renderType(ResourceLocation.parse((String)"cutout")).build().create(flower, mapping, this.modelOutput);
            this.blockStateOutput.accept(States.createSimpleBlock((Block)flower, (MultiVariant)States.plainVariant((ResourceLocation)resourcelocation)));
        }

        public void ladder(Block block) {
            ResourceLocation modelName = ModelTemplates.create((String)"ladder", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.PARTICLE}).extend().renderType("cutout").build().create(block, new TextureMapping().put(TextureSlot.TEXTURE, TextureMapping.getBlockTexture((Block)block)).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)block)), this.modelOutput);
            MultiVariantGenerator gen = MultiVariantGenerator.dispatch((Block)block, (MultiVariant)States.plainVariant((ResourceLocation)modelName));
            this.blockStateOutput.accept(gen);
            this.registerSimpleFlatItemModel(block);
        }

        public void createTexturedFarmland(Block dirt, Block farmland) {
            TextureMapping texturemapping = new TextureMapping().put(TextureSlot.DIRT, TextureMapping.getBlockTexture((Block)dirt)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)farmland));
            TextureMapping texturemapping1 = new TextureMapping().put(TextureSlot.DIRT, TextureMapping.getBlockTexture((Block)dirt)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)farmland, (String)"_moist"));
            ResourceLocation resourcelocation = ModelTemplates.FARMLAND.create(farmland, texturemapping, this.modelOutput);
            ResourceLocation resourcelocation1 = ModelTemplates.FARMLAND.create(TextureMapping.getBlockTexture((Block)farmland, (String)"_moist"), texturemapping1, this.modelOutput);
            this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)farmland).with(States.createEmptyOrFullDispatch((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7), (MultiVariant)States.plainVariant((ResourceLocation)resourcelocation1), (MultiVariant)States.plainVariant((ResourceLocation)resourcelocation))));
        }

        public void createDoor(Block door) {
            String renderType = "cutout";
            TextureMapping texturemapping = TextureMapping.door((Block)door);
            MultiVariant variant = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.DOOR_BOTTOM_LEFT).create(door, texturemapping, this.modelOutput));
            MultiVariant variant1 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.DOOR_BOTTOM_LEFT_OPEN).create(door, texturemapping, this.modelOutput));
            MultiVariant variant2 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.DOOR_BOTTOM_RIGHT).create(door, texturemapping, this.modelOutput));
            MultiVariant variant3 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.DOOR_BOTTOM_RIGHT_OPEN).create(door, texturemapping, this.modelOutput));
            MultiVariant variant4 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.DOOR_TOP_LEFT).create(door, texturemapping, this.modelOutput));
            MultiVariant variant5 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.DOOR_TOP_LEFT_OPEN).create(door, texturemapping, this.modelOutput));
            MultiVariant variant6 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.DOOR_TOP_RIGHT).create(door, texturemapping, this.modelOutput));
            MultiVariant variant7 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.DOOR_TOP_RIGHT_OPEN).create(door, texturemapping, this.modelOutput));
            this.registerSimpleFlatItemModel(door.asItem());
            this.blockStateOutput.accept(States.createDoor((Block)door, (MultiVariant)variant, (MultiVariant)variant1, (MultiVariant)variant2, (MultiVariant)variant3, (MultiVariant)variant4, (MultiVariant)variant5, (MultiVariant)variant6, (MultiVariant)variant7));
        }

        public void createGlassBlocks(Block block, Block pane) {
            this.createTrivialCube(block);
            String renderType = "cutout";
            TextureMapping texturemapping = TextureMapping.pane((Block)block, (Block)pane);
            MultiVariant multivariant = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.STAINED_GLASS_PANE_POST).create(pane, texturemapping, this.modelOutput));
            MultiVariant multivariant1 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.STAINED_GLASS_PANE_SIDE).create(pane, texturemapping, this.modelOutput));
            MultiVariant multivariant2 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.STAINED_GLASS_PANE_SIDE_ALT).create(pane, texturemapping, this.modelOutput));
            MultiVariant multivariant3 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.STAINED_GLASS_PANE_NOSIDE).create(pane, texturemapping, this.modelOutput));
            MultiVariant multivariant4 = States.plainVariant((ResourceLocation)States.extendWithType(renderType, ModelTemplates.STAINED_GLASS_PANE_NOSIDE_ALT).create(pane, texturemapping, this.modelOutput));
            Item item = pane.asItem();
            this.registerSimpleItemModel(item, this.createFlatItemModelWithBlockTexture(item, block));
            this.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)pane).with(multivariant).with(States.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true)), multivariant1).with(States.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true)), multivariant1.with(Y_ROT_90)).with(States.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true)), multivariant2).with(States.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)), multivariant2.with(Y_ROT_90)).with(States.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)), multivariant3).with(States.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)), multivariant4).with(States.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)), multivariant4.with(Y_ROT_90)).with(States.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), multivariant3.with(Y_ROT_270)));
        }

        private static ModelTemplate extendWithType(String renderType, ModelTemplate template) {
            return template.extend().renderType(ResourceLocation.parse((String)renderType)).build();
        }

        public void simpleBlock(Block block) {
            this.simpleBlock(block, null);
        }

        public void simpleBlock(Block block, @Nullable String renderType) {
            this.createTrivialBlock(block, renderType != null ? TexturedModel.createDefault(TextureMapping::cube, (ModelTemplate)ModelTemplates.CUBE_ALL.extend().renderType(ResourceLocation.parse((String)renderType)).build()) : TexturedModel.CUBE);
        }

        public ResourceLocation createSuffixedVariant(Block block, String suffix, ModelTemplate modelTemplate, Function<ResourceLocation, TextureMapping> textureMappingGetter) {
            return modelTemplate == ModelTemplates.CROP ? super.createSuffixedVariant(block, suffix, States.extendWithType("cutout", modelTemplate), textureMappingGetter) : super.createSuffixedVariant(block, suffix, modelTemplate, textureMappingGetter);
        }

        public void createGrassBlock(Block grass, Block dirt, @Nullable ItemTintSource tint) {
            ResourceLocation resourcelocation = TextureMapping.getBlockTexture((Block)dirt);
            TextureMapping snowMapping = new TextureMapping().put(TextureSlot.BOTTOM, resourcelocation).copyForced(TextureSlot.BOTTOM, TextureSlot.PARTICLE).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)grass, (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)grass, (String)"_snow"));
            if (tint == null) {
                MultiVariant variant = States.plainVariant((ResourceLocation)ModelTemplates.CUBE_BOTTOM_TOP.createWithSuffix(grass, "_snow", snowMapping, this.modelOutput));
                Variant resourcelocation1 = States.plainModel((ResourceLocation)TexturedModel.CUBE_TOP_BOTTOM.get(grass).updateTextures(p_388599_ -> p_388599_.put(TextureSlot.BOTTOM, resourcelocation)).create(grass, this.modelOutput));
                this.createGrassLikeBlock(grass, States.createRotatedVariants((Variant)resourcelocation1), variant);
                return;
            }
            ExtendedModelTemplate grassTemplate = ModelTemplates.create((TextureSlot[])new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.SIDE, OVERLAY_SLOT}).extend().parent(ResourceLocation.withDefaultNamespace((String)"block/grass_block")).renderType("cutout_mipped").build();
            TextureMapping texturemapping = new TextureMapping().put(TextureSlot.BOTTOM, resourcelocation).copyForced(TextureSlot.BOTTOM, TextureSlot.PARTICLE).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)grass, (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)grass, (String)"_side")).put(OVERLAY_SLOT, TextureMapping.getBlockTexture((Block)grass, (String)"_side_overlay"));
            Variant normalVariant = States.plainModel((ResourceLocation)grassTemplate.create(grass, texturemapping, this.modelOutput));
            MultiVariant snowVariant = States.plainVariant((ResourceLocation)ModelTemplates.CUBE_BOTTOM_TOP.createWithSuffix(grass, "_snow", snowMapping, this.modelOutput));
            this.createGrassLikeBlock(grass, States.createRotatedVariants((Variant)normalVariant), snowVariant);
        }
    }

    public static class Equipment
    extends EquipmentAssetProvider {
        private final PackOutput.PathProvider pathProvider;

        public Equipment(PackOutput output) {
            super(output);
            this.pathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "equipment");
        }

        public CompletableFuture<?> run(CachedOutput p_387304_) {
            HashMap map = new HashMap();
            Equipment.bootstrap((asset, info) -> {
                if (map.putIfAbsent(asset, info) != null) {
                    throw new IllegalStateException("Tried to register equipment asset twice for id: " + String.valueOf(asset));
                }
            });
            return DataProvider.saveAll((CachedOutput)p_387304_, (Codec)EquipmentClientInfo.CODEC, arg_0 -> ((PackOutput.PathProvider)this.pathProvider).json(arg_0), map);
        }

        static void bootstrap(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> output) {
            output.accept(GNSEquipmentAssets.CANDY, Equipment.onlyHumanoid((String)GoodNightSleep.find("candy")));
            output.accept(GNSEquipmentAssets.SPECTRITE, Equipment.onlyHumanoid((String)GoodNightSleep.find("spectrite")));
            output.accept(GNSEquipmentAssets.POSITITE, Equipment.onlyHumanoid((String)GoodNightSleep.find("positite")));
            output.accept(GNSEquipmentAssets.ZITRITE, Equipment.onlyHumanoid((String)GoodNightSleep.find("zitrite")));
            output.accept(GNSEquipmentAssets.NEGATITE, Equipment.onlyHumanoid((String)GoodNightSleep.find("negatite")));
        }
    }
}

