/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.data.GNSItemTags;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.registry.GNSItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.neoforged.neoforge.common.Tags;

public class GNSRecipeProv
extends VanillaRecipeProvider {
    private String hasItem = "has_item";
    private HolderGetter<Item> items;

    private GNSRecipeProv(HolderLookup.Provider lookupProvider, RecipeOutput output) {
        super(lookupProvider, output);
        this.items = lookupProvider.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        this.simple2x2(RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSBlocks.delusion_stone, (ItemLike)GNSBlocks.delusion_stone_bricks, 4);
        this.slabsStairsWalls(RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSBlocks.delusion_cobblestone, (ItemLike)GNSBlocks.delusion_cobblestone_slab, (ItemLike)GNSBlocks.delusion_cobblestone_stairs, (ItemLike)GNSBlocks.delusion_cobblestone_wall);
        this.slabsStairsWalls(RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSBlocks.delusion_stone_bricks, (ItemLike)GNSBlocks.delusion_stone_brick_slab, (ItemLike)GNSBlocks.delusion_stone_brick_stairs, (ItemLike)GNSBlocks.delusion_stone_brick_wall);
        this.slabsStairs(RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSBlocks.delusion_stone, (ItemLike)GNSBlocks.delusion_stone_slab, (ItemLike)GNSBlocks.delusion_stone_stairs);
        this.stoneCutting((ItemLike)GNSBlocks.delusion_cobblestone, (ImmutableList<ItemLike>)ImmutableList.of((Object)GNSBlocks.delusion_cobblestone_slab, (Object)GNSBlocks.delusion_cobblestone_stairs, (Object)GNSBlocks.delusion_cobblestone_wall));
        this.stoneCutting((ItemLike)GNSBlocks.delusion_stone_bricks, (ImmutableList<ItemLike>)ImmutableList.of((Object)GNSBlocks.delusion_stone_brick_slab, (Object)GNSBlocks.delusion_stone_brick_stairs, (Object)GNSBlocks.delusion_stone_brick_wall));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)GNSBlocks.delusion_button).requires((ItemLike)GNSBlocks.delusion_stone).unlockedBy(this.hasItem, this.has((ItemLike)GNSBlocks.delusion_stone)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)GNSBlocks.delusion_pressure_plate).define(Character.valueOf('#'), (ItemLike)GNSBlocks.delusion_stone).pattern("##").unlockedBy(this.hasItem, this.has((ItemLike)GNSBlocks.delusion_stone)).save(this.output);
        ImmutableList woodMapping = ImmutableList.of((Object)new WoodMap(GNSItemTags.DREAM_LOGS, (ItemLike)GNSBlocks.dream_log, (ItemLike)GNSBlocks.dream_wood, (ItemLike)GNSBlocks.stripped_dream_log, (ItemLike)GNSBlocks.stripped_dream_wood, (ItemLike)GNSBlocks.dream_planks, (ItemLike)GNSBlocks.dream_slab, (ItemLike)GNSBlocks.dream_stairs, (ItemLike)GNSBlocks.dream_pressure_plate, (ItemLike)GNSBlocks.dream_button, (ItemLike)GNSBlocks.dream_door, (ItemLike)GNSBlocks.dream_trapdoor, (ItemLike)GNSBlocks.dream_fence, (ItemLike)GNSBlocks.dream_fence_gate, (ItemLike)GNSBlocks.dream_sign, (ItemLike)GNSBlocks.dream_hanging_sign), (Object)new WoodMap(GNSItemTags.WHITE_LOGS, (ItemLike)GNSBlocks.white_log, (ItemLike)GNSBlocks.white_wood, (ItemLike)GNSBlocks.stripped_white_log, (ItemLike)GNSBlocks.stripped_white_wood, (ItemLike)GNSBlocks.white_planks, (ItemLike)GNSBlocks.white_slab, (ItemLike)GNSBlocks.white_stairs, (ItemLike)GNSBlocks.white_pressure_plate, (ItemLike)GNSBlocks.white_button, (ItemLike)GNSBlocks.white_door, (ItemLike)GNSBlocks.white_trapdoor, (ItemLike)GNSBlocks.white_fence, (ItemLike)GNSBlocks.white_fence_gate, (ItemLike)GNSBlocks.white_sign, (ItemLike)GNSBlocks.white_hanging_sign), (Object)new WoodMap(GNSItemTags.DEAD_LOGS, (ItemLike)GNSBlocks.dead_log, (ItemLike)GNSBlocks.dead_wood, (ItemLike)GNSBlocks.stripped_dead_log, (ItemLike)GNSBlocks.stripped_dead_wood, (ItemLike)GNSBlocks.dead_planks, (ItemLike)GNSBlocks.dead_slab, (ItemLike)GNSBlocks.dead_stairs, (ItemLike)GNSBlocks.dead_pressure_plate, (ItemLike)GNSBlocks.dead_button, (ItemLike)GNSBlocks.dead_door, (ItemLike)GNSBlocks.dead_trapdoor, (ItemLike)GNSBlocks.dead_fence, (ItemLike)GNSBlocks.dead_fence_gate, (ItemLike)GNSBlocks.dead_sign, (ItemLike)GNSBlocks.dead_hanging_sign), (Object)new WoodMap(GNSItemTags.BLOOD_LOGS, (ItemLike)GNSBlocks.blood_log, (ItemLike)GNSBlocks.blood_wood, (ItemLike)GNSBlocks.stripped_blood_log, (ItemLike)GNSBlocks.stripped_blood_wood, (ItemLike)GNSBlocks.blood_planks, (ItemLike)GNSBlocks.blood_slab, (ItemLike)GNSBlocks.blood_stairs, (ItemLike)GNSBlocks.blood_pressure_plate, (ItemLike)GNSBlocks.blood_button, (ItemLike)GNSBlocks.blood_door, (ItemLike)GNSBlocks.blood_trapdoor, (ItemLike)GNSBlocks.blood_fence, (ItemLike)GNSBlocks.blood_fence_gate, (ItemLike)GNSBlocks.blood_sign, (ItemLike)GNSBlocks.blood_hanging_sign));
        woodMapping.forEach(wood -> {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood.strippedWood, (int)3).define(Character.valueOf('#'), wood.strippedLog).pattern("##").pattern("##").group("stripped_bark").unlockedBy(this.hasItem, this.has(wood.strippedLog)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood.wood, (int)3).define(Character.valueOf('#'), wood.log).pattern("##").pattern("##").group("bark").unlockedBy(this.hasItem, this.has(wood.wood)).save(this.output);
            ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood.plank, (int)4).requires(wood.logTag).group("planks").unlockedBy(this.hasItem, this.has(wood.logTag)).save(this.output);
            this.slabs(RecipeCategory.BUILDING_BLOCKS, wood.plank, wood.slab).group("wooden_slab").save(this.output);
            this.stairs(RecipeCategory.BUILDING_BLOCKS, wood.plank, wood.stair).group("wooden_stairs").save(this.output);
            this.fencesGates(wood.plank, wood.fence, wood.gate);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)wood.door, (int)3).define(Character.valueOf('#'), wood.plank).pattern("##").pattern("##").pattern("##").group("wooden_door").unlockedBy(this.hasItem, this.has(wood.plank)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)wood.trapdoor, (int)2).define(Character.valueOf('#'), wood.plank).pattern("###").pattern("###").group("wooden_trapdoor").unlockedBy(this.hasItem, this.has(wood.plank)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)wood.pressurePlate).define(Character.valueOf('#'), wood.plank).pattern("##").group("wooden_pressure_plate").unlockedBy(this.hasItem, this.has(wood.plank)).save(this.output);
            ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)wood.button).requires(wood.plank).unlockedBy(this.hasItem, this.has(wood.plank)).save(this.output);
            this.signBuilder(wood.sign, Ingredient.of((ItemLike)wood.plank)).unlockedBy(this.hasItem, this.has(wood.plank)).save(this.output);
            this.hangingSign(wood.hangingSign, wood.strippedLog);
        });
        ImmutableList materialMapping = ImmutableList.of((Object)new OreMap(GNSItemTags.CANDY_BLOCKS, (ItemLike)GNSBlocks.hard_candy_block, GNSItemTags.CANDY_BLOCKS, (ItemLike)GNSBlocks.hard_candy_block, (ItemLike)GNSItems.candy_chestplate, (ItemLike)GNSItems.candy_leggings, (ItemLike)GNSItems.candy_boots, (ItemLike)GNSItems.candy_helmet, (ItemLike)GNSItems.candy_sword, (ItemLike)GNSItems.candy_pickaxe, (ItemLike)GNSItems.candy_axe, (ItemLike)GNSItems.candy_shovel, (ItemLike)GNSItems.candy_hoe), (Object)new OreMap(GNSItemTags.SPECTRITE_INGOTS, (ItemLike)GNSItems.spectrite_ingot, GNSItemTags.SPECTRITE_BLOCKS, (ItemLike)GNSBlocks.spectrite_block, (ItemLike)GNSItems.spectrite_chestplate, (ItemLike)GNSItems.spectrite_leggings, (ItemLike)GNSItems.spectrite_boots, (ItemLike)GNSItems.spectrite_helmet, (ItemLike)GNSItems.spectrite_sword, (ItemLike)GNSItems.spectrite_pickaxe, (ItemLike)GNSItems.spectrite_axe, (ItemLike)GNSItems.spectrite_shovel, (ItemLike)GNSItems.spectrite_hoe), (Object)new OreMap(GNSItemTags.POSITITE, (ItemLike)GNSItems.positite, GNSItemTags.POSITITE_BLOCKS, (ItemLike)GNSBlocks.positite_block, (ItemLike)GNSItems.positite_chestplate, (ItemLike)GNSItems.positite_leggings, (ItemLike)GNSItems.positite_boots, (ItemLike)GNSItems.positite_helmet, (ItemLike)GNSItems.positite_sword, (ItemLike)GNSItems.positite_pickaxe, (ItemLike)GNSItems.positite_axe, (ItemLike)GNSItems.positite_shovel, (ItemLike)GNSItems.positite_hoe), (Object)new OreMap(GNSItemTags.ZITRITE_INGOTS, (ItemLike)GNSItems.zitrite_ingot, GNSItemTags.ZITRITE_BLOCKS, (ItemLike)GNSBlocks.zitrite_block, (ItemLike)GNSItems.zitrite_chestplate, (ItemLike)GNSItems.zitrite_leggings, (ItemLike)GNSItems.zitrite_boots, (ItemLike)GNSItems.zitrite_helmet, (ItemLike)GNSItems.zitrite_sword, (ItemLike)GNSItems.zitrite_pickaxe, (ItemLike)GNSItems.zitrite_axe, (ItemLike)GNSItems.zitrite_shovel, (ItemLike)GNSItems.zitrite_hoe), (Object)new OreMap(GNSItemTags.NEGATITE, (ItemLike)GNSItems.negatite, GNSItemTags.NEGATITE_BLOCKS, (ItemLike)GNSBlocks.negatite_block, (ItemLike)GNSItems.negatite_chestplate, (ItemLike)GNSItems.negatite_leggings, (ItemLike)GNSItems.negatite_boots, (ItemLike)GNSItems.negatite_helmet, (ItemLike)GNSItems.negatite_sword, (ItemLike)GNSItems.negatite_pickaxe, (ItemLike)GNSItems.negatite_axe, (ItemLike)GNSItems.negatite_shovel, (ItemLike)GNSItems.negatite_hoe));
        materialMapping.forEach(mat -> {
            if (mat.material != GNSBlocks.hard_candy_block) {
                ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)mat.material, (int)9).requires(mat.blockTag).unlockedBy(this.hasItem, this.has(mat.blockTag)).save(this.output, GoodNightSleep.find(BuiltInRegistries.ITEM.getKey((Object)mat.material.asItem()).getPath() + "_from_block"));
                ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)mat.block).define(Character.valueOf('#'), mat.materialTag).pattern("###").pattern("###").pattern("###").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
            } else {
                this.simple3x3(RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSItems.candy, (ItemLike)GNSBlocks.hard_candy_block, 1);
                ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)GNSItems.candy, (int)9).requires(mat.blockTag).unlockedBy(this.hasItem, this.has(mat.blockTag)).save(this.output, GoodNightSleep.find(BuiltInRegistries.ITEM.getKey((Object)mat.material.asItem()).getPath() + "_from_block"));
            }
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)mat.helmet).define(Character.valueOf('#'), mat.materialTag).pattern("###").pattern("# #").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)mat.chestplate).define(Character.valueOf('#'), mat.materialTag).pattern("# #").pattern("###").pattern("###").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)mat.leggings).define(Character.valueOf('#'), mat.materialTag).pattern("###").pattern("# #").pattern("# #").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)mat.boots).define(Character.valueOf('#'), mat.materialTag).pattern("# #").pattern("# #").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)mat.sword).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), mat.materialTag).pattern("X").pattern("X").pattern("#").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)mat.pickaxe).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), mat.materialTag).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)mat.axe).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), mat.materialTag).pattern("XX").pattern("X#").pattern(" #").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)mat.shovel).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), mat.materialTag).pattern("X").pattern("#").pattern("#").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)mat.hoe).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), mat.materialTag).pattern("XX").pattern(" #").pattern(" #").unlockedBy(this.hasItem, this.has(mat.materialTag)).save(this.output);
        });
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSItems.necrum, (int)9).requires(GNSItemTags.NECRUM_BLOCKS).unlockedBy(this.hasItem, this.has(GNSItemTags.NECRUM_BLOCKS)).save(this.output, GoodNightSleep.find("necrum_from_block"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSBlocks.necrum_block).define(Character.valueOf('#'), GNSItemTags.NECRUM).pattern("###").pattern("###").pattern("###").unlockedBy(this.hasItem, this.has(GNSItemTags.NECRUM)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)GNSItems.necrum_sword).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), GNSItemTags.NECRUM_BLOCKS).pattern("X").pattern("X").pattern("#").unlockedBy(this.hasItem, this.has(GNSItemTags.NECRUM_BLOCKS)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)GNSItems.necrum_pickaxe).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), GNSItemTags.NECRUM_BLOCKS).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy(this.hasItem, this.has(GNSItemTags.NECRUM_BLOCKS)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)GNSItems.necrum_axe).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), GNSItemTags.NECRUM_BLOCKS).pattern("XX").pattern("X#").pattern(" #").unlockedBy(this.hasItem, this.has(GNSItemTags.NECRUM_BLOCKS)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)GNSItems.necrum_shovel).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), GNSItemTags.NECRUM_BLOCKS).pattern("X").pattern("#").pattern("#").unlockedBy(this.hasItem, this.has(GNSItemTags.NECRUM_BLOCKS)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)GNSItems.necrum_hoe).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), GNSItemTags.NECRUM_BLOCKS).pattern("XX").pattern(" #").pattern(" #").unlockedBy(this.hasItem, this.has(GNSItemTags.NECRUM_BLOCKS)).save(this.output);
        ImmutableMap flowerDyeMap = ImmutableMap.of((Object)GNSBlocks.cyan_flower, (Object)Items.CYAN_DYE, (Object)GNSBlocks.orange_flower, (Object)Items.ORANGE_DYE, (Object)GNSBlocks.dead_flower, (Object)Items.GRAY_DYE);
        flowerDyeMap.forEach((flower, dye) -> ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)dye).requires(flower).unlockedBy(this.hasItem, this.has((ItemLike)flower)).save(this.output, GoodNightSleep.find(BuiltInRegistries.ITEM.getKey((Object)dye.asItem()).getPath() + "_from_" + BuiltInRegistries.ITEM.getKey((Object)flower.asItem()).getPath())));
        ImmutableMap cropSeedMap = ImmutableMap.of((Object)GNSItems.rainbow_seeds, (Object)GNSItems.rainbow_berries);
        cropSeedMap.forEach((seed, crop) -> ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)seed).requires(crop).unlockedBy(this.hasItem, this.has((ItemLike)crop)).save(this.output));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.FURNACE).define(Character.valueOf('#'), GNSItemTags.COBBLESTONES).pattern("###").pattern("# #").pattern("###").unlockedBy(this.hasItem, this.has(GNSItemTags.COBBLESTONES)).save(this.output, GoodNightSleep.find("furnace_compat"));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSItems.strange_bed).requires(ItemTags.BEDS).requires((ItemLike)GNSBlocks.hope_mushroom).requires((ItemLike)GNSBlocks.despair_mushroom).unlockedBy(this.hasItem, this.has(ItemTags.BEDS)).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSItems.luxurious_bed).requires((ItemLike)GNSItems.strange_bed).requires((ItemLike)GNSItems.positite).unlockedBy(this.hasItem, this.has((ItemLike)GNSItems.strange_bed)).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSItems.wretched_bed).requires((ItemLike)GNSItems.strange_bed).requires((ItemLike)GNSItems.negatite).unlockedBy(this.hasItem, this.has((ItemLike)GNSItems.strange_bed)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSBlocks.pot_of_gold.asItem()).define(Character.valueOf('I'), (ItemLike)GNSItems.spectrite_ingot).define(Character.valueOf('G'), (ItemLike)Blocks.GOLD_BLOCK.asItem()).define(Character.valueOf('C'), (ItemLike)Blocks.CAULDRON.asItem()).pattern("III").pattern("IGI").pattern("ICI").unlockedBy(this.hasItem, this.has((ItemLike)GNSItems.spectrite_ingot)).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)GNSItems.powdered_sugar).requires(GNSItemTags.SUGARY).unlockedBy(this.hasItem, this.has(GNSItemTags.SUGARY)).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)GNSItems.necrotic_extract).requires(GNSItemTags.NECROTIC_EXTRACTABLES).unlockedBy(this.hasItem, this.has(GNSItemTags.NECROTIC_EXTRACTABLES)).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)GNSItems.luxurious_soup).requires((ItemLike)Items.BOWL).requires((ItemLike)GNSBlocks.hope_mushroom).requires((ItemLike)GNSItems.powdered_sugar).unlockedBy(this.hasItem, this.has((ItemLike)GNSBlocks.hope_mushroom)).save(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)GNSItems.wretched_soup).requires((ItemLike)Items.BOWL).requires((ItemLike)GNSBlocks.despair_mushroom).requires((ItemLike)GNSItems.necrotic_extract).unlockedBy(this.hasItem, this.has((ItemLike)GNSBlocks.despair_mushroom)).save(this.output);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, (ItemLike)GNSItems.raw_spectrite, RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSBlocks.raw_spectrite_block);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, (ItemLike)GNSItems.raw_zitrite, RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSBlocks.raw_zitrite_block);
        this.blasting(RecipeCategory.MISC, GNSItemTags.SPECTRITE_SMELTABLES, (ItemLike)GNSItems.spectrite_ingot, 0.7f);
        this.blasting(RecipeCategory.MISC, GNSItemTags.POSITITE_SMELTABLES, (ItemLike)GNSItems.positite, 0.9f);
        this.blasting(RecipeCategory.MISC, GNSItemTags.NECRUM_SMELTABLES, (ItemLike)GNSItems.necrum, 0.2f);
        this.blasting(RecipeCategory.MISC, GNSItemTags.ZITRITE_SMELTABLES, (ItemLike)GNSItems.zitrite_ingot, 0.9f);
        this.blasting(RecipeCategory.MISC, GNSItemTags.NEGATITE_SMELTABLES, (ItemLike)GNSItems.negatite, 1.0f);
        this.cooking(RecipeCategory.BUILDING_BLOCKS, (ItemLike)GNSBlocks.delusion_cobblestone, (ItemLike)GNSBlocks.delusion_stone, 0.1f);
    }

    private void simple2x2(RecipeCategory cat, ItemLike item, ItemLike output, int amount) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)amount).define(Character.valueOf('#'), item).pattern("##").pattern("##").unlockedBy(this.hasItem, this.has(item)).save(this.output);
    }

    private void simple2x2(RecipeCategory cat, ItemLike item, ItemLike output) {
        this.simple2x2(cat, item, output, 1);
    }

    private void simple3x3(RecipeCategory cat, ItemLike item, ItemLike output, int amount) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)amount).define(Character.valueOf('#'), item).pattern("###").pattern("###").pattern("###").unlockedBy(this.hasItem, this.has(item)).save(this.output);
    }

    private void simple3x3(RecipeCategory cat, ItemLike item, ItemLike output) {
        this.simple3x3(cat, item, output, 1);
    }

    private void slabsStairs(RecipeCategory cat, ItemLike block, ItemLike slab, ItemLike stair) {
        this.slabs(cat, block, slab).save(this.output);
        this.stairs(cat, block, stair).save(this.output);
    }

    private void slabsStairsWalls(RecipeCategory cat, ItemLike block, ItemLike slab, ItemLike stair, ItemLike wall) {
        this.slabsStairs(cat, block, slab, stair);
        this.walls(block, wall);
    }

    private void slabsStairs(RecipeCategory cat, ItemLike block, ItemLike slab, ItemLike stair, boolean withStoneCutting) {
        this.slabsStairs(cat, block, slab, stair);
        this.stoneCutting(block, (ImmutableList<ItemLike>)ImmutableList.of((Object)slab, (Object)stair));
    }

    private void slabsStairsWalls(RecipeCategory cat, ItemLike block, ItemLike slab, ItemLike stair, ItemLike wall, boolean withStoneCutting) {
        this.slabsStairsWalls(cat, block, slab, stair, wall);
        this.stoneCutting(block, (ImmutableList<ItemLike>)ImmutableList.of((Object)slab, (Object)stair, (Object)wall));
    }

    private ShapedRecipeBuilder slabs(RecipeCategory cat, ItemLike ingredient, ItemLike slab) {
        return ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)slab, (int)6).define(Character.valueOf('#'), ingredient).pattern("###").unlockedBy(this.hasItem, this.has(ingredient));
    }

    private ShapedRecipeBuilder stairs(RecipeCategory cat, ItemLike ingredient, ItemLike stair) {
        return ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)stair, (int)4).define(Character.valueOf('#'), ingredient).pattern("#  ").pattern("## ").pattern("###").unlockedBy(this.hasItem, this.has(ingredient));
    }

    private void walls(ItemLike ingredient, ItemLike wall) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (int)6).define(Character.valueOf('#'), ingredient).pattern("###").pattern("###").unlockedBy(this.hasItem, this.has(ingredient)).save(this.output);
    }

    private void fencesGates(ItemLike plank, ItemLike fence, ItemLike gate) {
        this.fences(plank, fence);
        this.gates(plank, gate);
    }

    private void fences(ItemLike plank, ItemLike fence) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fence, (int)3).define(Character.valueOf('P'), plank).define(Character.valueOf('S'), Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.RODS_WOODEN))).pattern("PSP").pattern("PSP").group("wooden_fence").unlockedBy(this.hasItem, this.has(plank)).save(this.output);
    }

    private void gates(ItemLike plank, ItemLike gate) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)gate).define(Character.valueOf('P'), plank).define(Character.valueOf('S'), Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.RODS_WOODEN))).pattern("SPS").pattern("SPS").group("wooden_fence_gate").unlockedBy(this.hasItem, this.has(plank)).save(this.output);
    }

    private void stoneCutting(ItemLike ingredient, ImmutableList<ItemLike> results) {
        results.forEach(result -> SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)ingredient), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)(result instanceof SlabBlock ? 2 : 1)).unlockedBy(this.hasItem, this.has(ingredient)).save(this.output, GoodNightSleep.find(BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath() + "_stonecutting_" + BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem()).getPath())));
    }

    private void cooking(RecipeCategory cat, ItemLike ingredient, ItemLike result, float exp) {
        this.cooking(cat, ingredient, result, exp, 200, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new);
    }

    private <T extends AbstractCookingRecipe> void cooking(RecipeCategory cat, ItemLike ingredient, ItemLike result, float exp, int time, RecipeSerializer<T> smeltingRecipe, AbstractCookingRecipe.Factory<T> recipeFactory) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike)ingredient), (RecipeCategory)cat, (ItemLike)result, (float)exp, (int)time, smeltingRecipe, recipeFactory).unlockedBy(this.hasItem, this.has(ingredient)).save(this.output, GoodNightSleep.find(BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath() + "_from_" + BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem()).getPath()));
    }

    private void smoking(TagKey<Item> ingredient, ItemLike result, float exp) {
        this.cooking(RecipeCategory.FOOD, ingredient, result, exp);
        this.cooking(RecipeCategory.FOOD, ingredient, result, exp, 100, RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new);
        this.cooking(RecipeCategory.FOOD, ingredient, result, exp, 600, RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new);
    }

    private void blasting(RecipeCategory cat, TagKey<Item> ingredient, ItemLike result, float exp) {
        this.cooking(cat, ingredient, result, exp);
        this.cooking(cat, ingredient, result, exp, 100, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new);
    }

    private void cooking(RecipeCategory cat, TagKey<Item> ingredient, ItemLike result, float exp) {
        this.cooking(cat, ingredient, result, exp, 200, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new);
    }

    private <T extends AbstractCookingRecipe> void cooking(RecipeCategory cat, TagKey<Item> ingredient, ItemLike result, float exp, int time, RecipeSerializer<T> smeltingRecipe, AbstractCookingRecipe.Factory<T> recipeFactory) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((HolderSet)this.items.getOrThrow(ingredient)), (RecipeCategory)cat, (ItemLike)result, (float)exp, (int)time, smeltingRecipe, recipeFactory).unlockedBy(this.hasItem, this.has(ingredient)).save(this.output, GoodNightSleep.find(BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath() + "_from_" + BuiltInRegistries.RECIPE_SERIALIZER.getKey(smeltingRecipe).getPath()));
    }

    private void smoking(RecipeCategory cat, ItemLike ingredient, ItemLike result, float exp) {
        this.cooking(cat, ingredient, result, exp, 200, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new);
        this.cooking(cat, ingredient, result, exp, 100, RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new);
        this.cooking(cat, ingredient, result, exp, 600, RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new);
    }

    private void blasting(RecipeCategory cat, ItemLike ingredient, ItemLike result, float exp) {
        this.cooking(cat, ingredient, result, exp, 200, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new);
        this.cooking(cat, ingredient, result, exp, 100, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new);
    }

    protected record WoodMap(TagKey<Item> logTag, ItemLike log, ItemLike wood, ItemLike strippedLog, ItemLike strippedWood, ItemLike plank, ItemLike slab, ItemLike stair, ItemLike pressurePlate, ItemLike button, ItemLike door, ItemLike trapdoor, ItemLike fence, ItemLike gate, ItemLike sign, ItemLike hangingSign) {
    }

    protected record OreMap(TagKey<Item> materialTag, ItemLike material, TagKey<Item> blockTag, ItemLike block, ItemLike chestplate, ItemLike leggings, ItemLike boots, ItemLike helmet, ItemLike sword, ItemLike pickaxe, ItemLike axe, ItemLike shovel, ItemLike hoe) {
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookup, RecipeOutput output) {
            return new GNSRecipeProv(lookup, output);
        }

        public String getName() {
            return "Good Night's Sleep Recipe Gen";
        }
    }
}

