/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.data;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.registry.GNSSounds;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public class GNSSoundProv
extends SoundDefinitionsProvider {
    public static final boolean VALIDATE = true;

    public GNSSoundProv(PackOutput output) {
        super(output, "good_nights_sleep");
    }

    public void registerSounds() {
        String music = "music/";
        this.add((SoundEvent)GNSSounds.MUSIC_DREAM.value(), GNSSoundProv.definition().with(GNSSoundProv.gns(music.concat("good_dream")).stream().preload(true).weight(3)).with(GNSSoundProv.gns(music.concat("sky_blue")).stream().preload(true).weight(2)));
        this.add((SoundEvent)GNSSounds.MUSIC_NIGHTMARE.value(), GNSSoundProv.definition().with(GNSSoundProv.gns(music.concat("tfarcenim")).stream().preload(true)));
        String armorSub = GNSSoundProv.itemSub("armor.equip_");
        this.add((SoundEvent)GNSSounds.ITEM_ARMOR_EQUIP_CANDY.value(), GNSSoundProv.definition().with(GNSSoundProv.event((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value())).subtitle(armorSub.concat("candy")));
        this.add((SoundEvent)GNSSounds.ITEM_ARMOR_EQUIP_SPECTRITE.value(), GNSSoundProv.definition().with(GNSSoundProv.event((SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value())).subtitle(armorSub.concat("spectrite")));
        this.add((SoundEvent)GNSSounds.ITEM_ARMOR_EQUIP_POSITITE.value(), GNSSoundProv.definition().with(GNSSoundProv.event((SoundEvent)SoundEvents.ARMOR_EQUIP_DIAMOND.value())).subtitle(armorSub.concat("positite")));
        this.add((SoundEvent)GNSSounds.ITEM_ARMOR_EQUIP_ZITRITE.value(), GNSSoundProv.definition().with(GNSSoundProv.event((SoundEvent)SoundEvents.ARMOR_EQUIP_DIAMOND.value())).subtitle(armorSub.concat("zitrite")));
        this.add((SoundEvent)GNSSounds.ITEM_ARMOR_EQUIP_NEGATITE.value(), GNSSoundProv.definition().with(GNSSoundProv.event((SoundEvent)SoundEvents.ARMOR_EQUIP_GOLD.value())).subtitle(armorSub.concat("negatite")));
        String block = "pot_of_gold";
        this.add(GNSSounds.BLOCK_POT_OF_GOLD_USE, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.BOTTLE_FILL)).subtitle(GNSSoundProv.blockSub(block + ".use")));
        block = "rainbow";
        this.add(GNSSounds.BLOCK_RAINBOW_APPEAR, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.AMETHYST_BLOCK_RESONATE)).subtitle(GNSSoundProv.blockSub(block + ".appear")));
        String entity = "baby_creeper";
        this.add(GNSSounds.ENTITY_BABY_CREEPER_HURT, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.CREEPER_HURT)).subtitle(GNSSoundProv.entitySub(entity + ".hurt")));
        this.add(GNSSounds.ENTITY_BABY_CREEPER_DEATH, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.CREEPER_DEATH)).subtitle(GNSSoundProv.entitySub(entity + ".death")));
        entity = "tormenter";
        this.add(GNSSounds.ENTITY_TORMENTER_IDLE, GNSSoundProv.definition().with(GNSSoundProv.event((SoundEvent)SoundEvents.AMBIENT_CAVE.value())).subtitle(GNSSoundProv.entitySub(entity + ".idle")));
        this.add(GNSSounds.ENTITY_TORMENTER_HURT, GNSSoundProv.definition().with(GNSSoundProv.event((SoundEvent)SoundEvents.AMBIENT_CAVE.value())).subtitle(GNSSoundProv.entitySub(entity + ".hurt")));
        this.add(GNSSounds.ENTITY_TORMENTER_DEATH, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.ZOMBIE_HORSE_DEATH)).subtitle(GNSSoundProv.entitySub(entity + ".death")));
        this.add(GNSSounds.ENTITY_TORMENTER_TORMENT, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.ELDER_GUARDIAN_CURSE)).subtitle(GNSSoundProv.entitySub(entity + ".torment")));
        entity = "unicorn";
        this.add(GNSSounds.ENTITY_UNICORN_IDLE, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.HORSE_AMBIENT)).subtitle(GNSSoundProv.entitySub(entity + ".idle")));
        this.add(GNSSounds.ENTITY_UNICORN_HURT, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.HORSE_HURT)).subtitle(GNSSoundProv.entitySub(entity + ".hurt")));
        this.add(GNSSounds.ENTITY_UNICORN_DEATH, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.HORSE_DEATH)).subtitle(GNSSoundProv.entitySub(entity + ".death")));
        this.add(GNSSounds.ENTITY_UNICORN_ANGRY, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.HORSE_ANGRY)).subtitle(GNSSoundProv.entitySub(entity + ".angry")));
        this.add(GNSSounds.ENTITY_UNICORN_EAT, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.HORSE_EAT)).subtitle(GNSSoundProv.entitySub(entity + ".eat")));
        this.add(GNSSounds.ENTITY_UNICORN_BREATHE, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.HORSE_BREATHE)).subtitle(GNSSoundProv.entitySub(entity + ".breathe")));
        entity = "herobrine";
        this.add(GNSSounds.ENTITY_HEROBRINE_HURT, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.WITHER_HURT)).subtitle(GNSSoundProv.entitySub(entity + ".hurt")));
        this.add(GNSSounds.ENTITY_HEROBRINE_DEATH, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.WITHER_DEATH)).subtitle(GNSSoundProv.entitySub(entity + ".death")));
        this.add(GNSSounds.ENTITY_HEROBRINE_TELEPORT, GNSSoundProv.definition().with(GNSSoundProv.event(SoundEvents.PLAYER_TELEPORT)).subtitle(GNSSoundProv.entitySub(entity + ".teleport")));
    }

    protected static SoundDefinition def(Dir dir, String name, String subtitle) {
        return GNSSoundProv.def(dir, name, 1, subtitle);
    }

    protected static SoundDefinition def(Dir dir, String name, int count, String subtitle) {
        return GNSSoundProv.def(dir, name, count, subtitle, s -> {});
    }

    protected static SoundDefinition def(Dir dir, String name, int count, String subtitle, Consumer<SoundDefinition.Sound> extra) {
        SoundDefinition def;
        SoundDefinition soundDefinition = def = count > 1 ? GNSSoundProv.definition().with(GNSSoundProv.gns(dir.folderName.concat(name), count, extra)) : GNSSoundProv.definition().with(GNSSoundProv.gns(dir.folderName.concat(name), extra));
        return def.subtitle(dir == Dir.ENTITY ? GNSSoundProv.entitySub(subtitle) : (dir == Dir.BLOCKS ? GNSSoundProv.blockSub(subtitle) : (dir == Dir.ITEMS ? GNSSoundProv.itemSub(subtitle) : subtitle)));
    }

    protected static SoundDefinition.Sound gns(String name) {
        return GNSSoundProv.gns(name, s -> {});
    }

    protected static SoundDefinition.Sound gns(String name, Consumer<SoundDefinition.Sound> extra) {
        SoundDefinition.Sound sound = GNSSoundProv.sound((ResourceLocation)GoodNightSleep.locate(name));
        extra.accept(sound);
        return sound;
    }

    protected static SoundDefinition.Sound[] gns(String name, int count) {
        return GNSSoundProv.gns(name, count, s -> {});
    }

    protected static SoundDefinition.Sound[] gns(String name, int count, Consumer<SoundDefinition.Sound> extra) {
        ArrayList<SoundDefinition.Sound> sounds = new ArrayList<SoundDefinition.Sound>();
        for (int i = 1; i <= count; ++i) {
            SoundDefinition.Sound sound = GNSSoundProv.gns(name.concat("_" + i));
            extra.accept(sound);
            sounds.add(sound);
        }
        return sounds.toArray(new SoundDefinition.Sound[count]);
    }

    protected static SoundDefinition.Sound event(SoundEvent event) {
        return GNSSoundProv.sound((ResourceLocation)BuiltInRegistries.SOUND_EVENT.getKey((Object)event), (SoundDefinition.SoundType)SoundDefinition.SoundType.EVENT);
    }

    protected static String subMc(String name) {
        return "subtitles.".concat(name);
    }

    protected static String sub(String name) {
        return GNSSoundProv.subMc("good_nights_sleep." + name);
    }

    protected static String blockSub(String name) {
        return GNSSoundProv.sub("block.".concat(name));
    }

    protected static String itemSub(String name) {
        return GNSSoundProv.sub("item.".concat(name));
    }

    protected static String entitySub(String name) {
        return GNSSoundProv.sub("entity.".concat(name));
    }

    protected static SoundDefinition musicDef(String name) {
        return GNSSoundProv.musicDef(name, false);
    }

    protected static SoundDefinition musicDef(String name, boolean preload) {
        String music = "music/";
        return GNSSoundProv.definition().with(GNSSoundProv.gns(music.concat(name)).stream().preload(preload));
    }

    protected static SoundDefinition entityDef(String entityName, String soundName, int count, String subtitle) {
        return GNSSoundProv.def(Dir.ENTITY, entityName + "/" + soundName, count, entityName + "." + subtitle);
    }

    protected static SoundDefinition entityDef(String entityName, String soundName, int count) {
        return GNSSoundProv.entityDef(entityName, soundName, count, soundName);
    }

    protected static SoundDefinition blockDef(String blockName, String soundName, int count) {
        return GNSSoundProv.blockDef(blockName, soundName, count, 0);
    }

    protected static SoundDefinition blockDef(String blockName, String soundName, int count, int attenuationDistance) {
        String defName = blockName + "/" + soundName;
        String defSubtitle = blockName + "." + soundName;
        return GNSSoundProv.def(Dir.BLOCKS, defName, count, defSubtitle, s -> {
            if (attenuationDistance > 0) {
                s.attenuationDistance(attenuationDistance);
            }
        });
    }

    protected static SoundDefinition itemDef(String itemName, String soundName, int count, String subtitle) {
        return GNSSoundProv.def(Dir.ITEMS, itemName + "/" + soundName, count, itemName + "." + subtitle);
    }

    protected static SoundDefinition itemDef(String itemName, String soundName, int count) {
        return GNSSoundProv.def(Dir.ITEMS, itemName + "/" + soundName, count, itemName);
    }

    private static enum Dir {
        BLOCKS("block/"),
        ITEMS("item/"),
        ENTITY("entity/"),
        MUSIC("music/");

        public final String folderName;

        private Dir(String folderName) {
            this.folderName = folderName;
        }
    }
}

