/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.data;

import com.legacy.good_nights_sleep.data.GNSBiomeTags;
import com.legacy.good_nights_sleep.data.GNSBlockTags;
import com.legacy.good_nights_sleep.data.GNSItemTags;
import com.legacy.good_nights_sleep.registry.GNSBiomes;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.registry.GNSEntityTypes;
import com.legacy.good_nights_sleep.registry.GNSItems;
import com.legacy.good_nights_sleep.util.Pointer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.TagAppender;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagCopyingItemTagProvider;
import net.neoforged.neoforge.common.data.BlockTagsProvider;

public class GNSTagProv {

    public static class BiomeTagProv
    extends BiomeTagsProvider {
        public BiomeTagProv(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "good_nights_sleep");
        }

        protected void addTags(HolderLookup.Provider prov) {
            this.goodNightsSleep();
            this.vanilla();
            this.forge();
        }

        void goodNightsSleep() {
            this.add(GNSBiomeTags.IS_DREAM, GNSBiomes.GOOD_DREAM_PLAINS, GNSBiomes.SLEEPY_HILLS, GNSBiomes.DREAMY_FOREST, GNSBiomes.LOLLIPOP_LANDS);
            this.add(GNSBiomeTags.IS_NIGHTMARE, GNSBiomes.SHAMEFUL_PLAINS, GNSBiomes.NIGHTMARE_MOUND, GNSBiomes.WASTED_FOREST);
            this.tag(GNSBiomeTags.HAS_HOPE_MUSHROOMS).addTag(BiomeTags.IS_NETHER);
            this.tag(GNSBiomeTags.HAS_DESPAIR_MUSHROOMS).addTag(BiomeTags.IS_NETHER);
        }

        void vanilla() {
            this.tag(BiomeTags.SPAWNS_WARM_VARIANT_FROGS).addTag(GNSBiomeTags.IS_NIGHTMARE);
            this.tag(BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS).addTag(GNSBiomeTags.IS_NIGHTMARE);
        }

        void forge() {
        }

        private void add(TagKey<Biome> tag, Pointer<Biome> ... registrars) {
            this.tag(tag).add((Object[])((ResourceKey[])Arrays.stream(registrars).map(r -> r.getKey()).toArray(ResourceKey[]::new)));
        }

        public String getName() {
            return "Good Night's Sleep Biome Tags";
        }
    }

    public static class EntityTagProv
    extends EntityTypeTagsProvider {
        public EntityTagProv(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "good_nights_sleep");
        }

        protected void addTags(HolderLookup.Provider prov) {
            this.goodNightsSleep();
            this.vanilla();
            this.forge();
        }

        void goodNightsSleep() {
        }

        void vanilla() {
            this.tag(EntityTypeTags.CAN_EQUIP_SADDLE).add(GNSEntityTypes.UNICORN);
        }

        void forge() {
        }

        public String getName() {
            return "Good Night's Sleep EntityType Tags";
        }
    }

    public static class ItemTagProv
    extends BlockTagCopyingItemTagProvider {
        public ItemTagProv(DataGenerator generatorIn, CompletableFuture<TagsProvider.TagLookup<Block>> blocktagProvIn, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, blocktagProvIn, "good_nights_sleep");
        }

        protected void addTags(HolderLookup.Provider prov) {
            this.goodNightsSleep();
            this.vanilla();
            this.forge();
        }

        void goodNightsSleep() {
            this.copy(GNSBlockTags.PLANKS, GNSItemTags.PLANKS);
            this.copy(GNSBlockTags.DREAM_LOGS, GNSItemTags.DREAM_LOGS);
            this.copy(GNSBlockTags.WHITE_LOGS, GNSItemTags.WHITE_LOGS);
            this.copy(GNSBlockTags.DEAD_LOGS, GNSItemTags.DEAD_LOGS);
            this.copy(GNSBlockTags.BLOOD_LOGS, GNSItemTags.BLOOD_LOGS);
            this.copy(GNSBlockTags.COBBLESTONES, GNSItemTags.COBBLESTONES);
            this.copy(GNSBlockTags.STONES, GNSItemTags.STONES);
            this.copy(GNSBlockTags.MUSHROOMS, GNSItemTags.MUSHROOMS);
            this.copy(GNSBlockTags.CANDY_ORES, GNSItemTags.CANDY_ORES);
            this.copy(GNSBlockTags.SPECTRITE_ORES, GNSItemTags.SPECTRITE_ORES);
            this.copy(GNSBlockTags.POSITITE_ORES, GNSItemTags.POSITITE_ORES);
            this.copy(GNSBlockTags.NECRUM_ORES, GNSItemTags.NECRUM_ORES);
            this.copy(GNSBlockTags.ZITRITE_ORES, GNSItemTags.ZITRITE_ORES);
            this.copy(GNSBlockTags.NEGATITE_ORES, GNSItemTags.NEGATITE_ORES);
            this.copy(GNSBlockTags.CANDY_BLOCKS, GNSItemTags.CANDY_BLOCKS);
            this.copy(GNSBlockTags.SPECTRITE_BLOCKS, GNSItemTags.SPECTRITE_BLOCKS);
            this.copy(GNSBlockTags.POSITITE_BLOCKS, GNSItemTags.POSITITE_BLOCKS);
            this.copy(GNSBlockTags.NECRUM_BLOCKS, GNSItemTags.NECRUM_BLOCKS);
            this.copy(GNSBlockTags.ZITRITE_BLOCKS, GNSItemTags.ZITRITE_BLOCKS);
            this.copy(GNSBlockTags.NEGATITE_BLOCKS, GNSItemTags.NEGATITE_BLOCKS);
            this.tag(GNSItemTags.CANDY_MATERIALS).add((Object)GNSBlocks.hard_candy_block.asItem());
            this.tag(GNSItemTags.SPECTRITE_INGOTS).add((Object)GNSItems.spectrite_ingot);
            this.tag(GNSItemTags.POSITITE).add((Object)GNSItems.positite);
            this.tag(GNSItemTags.NECRUM).add((Object)GNSItems.necrum);
            this.tag(GNSItemTags.ZITRITE_INGOTS).add((Object)GNSItems.zitrite_ingot);
            this.tag(GNSItemTags.NEGATITE).add((Object)GNSItems.negatite);
            this.tag(GNSItemTags.SUGARY).add((Object[])new Item[]{Items.SUGAR, GNSItems.candy});
            this.tag(GNSItemTags.NECROTIC_EXTRACTABLES).add((Object)Items.ROTTEN_FLESH).addTag(GNSItemTags.NECRUM);
            this.tag(GNSItemTags.CANDY_SMELTABLES).addTag(GNSItemTags.CANDY_ORES);
            this.tag(GNSItemTags.NECRUM_SMELTABLES).addTag(GNSItemTags.NECRUM_ORES);
            this.tag(GNSItemTags.SPECTRITE_SMELTABLES).add((Object)GNSItems.raw_spectrite).addTag(GNSItemTags.SPECTRITE_ORES);
            this.tag(GNSItemTags.ZITRITE_SMELTABLES).add((Object)GNSItems.raw_zitrite).addTag(GNSItemTags.ZITRITE_ORES);
            this.tag(GNSItemTags.POSITITE_SMELTABLES).addTag(GNSItemTags.POSITITE_ORES);
            this.tag(GNSItemTags.NEGATITE_SMELTABLES).addTag(GNSItemTags.NEGATITE_ORES);
        }

        void vanilla() {
            this.copy(BlockTags.BEDS, ItemTags.BEDS);
            this.copy(BlockTags.SAPLINGS, ItemTags.SAPLINGS);
            this.copy(BlockTags.SLABS, ItemTags.SLABS);
            this.copy(BlockTags.SMALL_FLOWERS, ItemTags.SMALL_FLOWERS);
            this.copy(BlockTags.STAIRS, ItemTags.STAIRS);
            this.copy(BlockTags.WALLS, ItemTags.WALLS);
            this.copy(BlockTags.WOODEN_BUTTONS, ItemTags.WOODEN_BUTTONS);
            this.copy(BlockTags.WOODEN_PRESSURE_PLATES, ItemTags.WOODEN_PRESSURE_PLATES);
            this.copy(BlockTags.PLANKS, ItemTags.PLANKS);
            this.copy(BlockTags.WOODEN_SLABS, ItemTags.WOODEN_SLABS);
            this.copy(BlockTags.WOODEN_STAIRS, ItemTags.WOODEN_STAIRS);
            this.copy(BlockTags.WOODEN_DOORS, ItemTags.WOODEN_DOORS);
            this.copy(BlockTags.WOODEN_TRAPDOORS, ItemTags.WOODEN_TRAPDOORS);
            this.copy(BlockTags.WOODEN_FENCES, ItemTags.WOODEN_FENCES);
            this.copy(BlockTags.FENCE_GATES, ItemTags.FENCE_GATES);
            this.copy(BlockTags.LOGS, ItemTags.LOGS);
            this.copy(BlockTags.LOGS_THAT_BURN, ItemTags.LOGS_THAT_BURN);
            this.copy(BlockTags.LEAVES, ItemTags.LEAVES);
            this.copy(BlockTags.STONE_BRICKS, ItemTags.STONE_BRICKS);
            this.tag(ItemTags.STONE_TOOL_MATERIALS).addTag(GNSItemTags.COBBLESTONES);
            this.tag(ItemTags.STONE_CRAFTING_MATERIALS).addTag(GNSItemTags.COBBLESTONES);
            this.tag(ItemTags.PIGLIN_LOVED).add((Object)GNSBlocks.pot_of_gold.asItem());
            this.copy(BlockTags.STANDING_SIGNS, ItemTags.SIGNS);
            this.copy(BlockTags.CEILING_HANGING_SIGNS, ItemTags.HANGING_SIGNS);
            this.tag(ItemTags.PICKAXES).add((Object[])new Item[]{GNSItems.candy_pickaxe, GNSItems.positite_pickaxe, GNSItems.spectrite_pickaxe, GNSItems.necrum_pickaxe, GNSItems.negatite_pickaxe, GNSItems.zitrite_pickaxe});
            this.tag(ItemTags.AXES).add((Object[])new Item[]{GNSItems.candy_axe, GNSItems.positite_axe, GNSItems.spectrite_axe, GNSItems.necrum_axe, GNSItems.negatite_axe, GNSItems.zitrite_axe});
            this.tag(ItemTags.SHOVELS).add((Object[])new Item[]{GNSItems.candy_shovel, GNSItems.positite_shovel, GNSItems.spectrite_shovel, GNSItems.necrum_shovel, GNSItems.negatite_shovel, GNSItems.zitrite_shovel});
            this.tag(ItemTags.HOES).add((Object[])new Item[]{GNSItems.candy_hoe, GNSItems.positite_hoe, GNSItems.spectrite_hoe, GNSItems.necrum_hoe, GNSItems.negatite_hoe, GNSItems.zitrite_hoe});
            this.tag(ItemTags.SWORDS).add((Object[])new Item[]{GNSItems.candy_sword, GNSItems.positite_sword, GNSItems.spectrite_sword, GNSItems.necrum_sword, GNSItems.negatite_sword, GNSItems.zitrite_sword});
            this.tag(ItemTags.CLUSTER_MAX_HARVESTABLES).add((Object[])new Item[]{GNSItems.candy_pickaxe, GNSItems.positite_pickaxe, GNSItems.spectrite_pickaxe, GNSItems.necrum_pickaxe, GNSItems.negatite_pickaxe, GNSItems.zitrite_pickaxe});
            this.tag(ItemTags.TRIMMABLE_ARMOR).add((Object[])new Item[]{GNSItems.positite_helmet, GNSItems.positite_chestplate, GNSItems.positite_leggings, GNSItems.positite_boots});
            this.tag(ItemTags.TRIMMABLE_ARMOR).add((Object[])new Item[]{GNSItems.candy_helmet, GNSItems.candy_chestplate, GNSItems.candy_leggings, GNSItems.candy_boots});
            this.tag(ItemTags.TRIMMABLE_ARMOR).add((Object[])new Item[]{GNSItems.spectrite_helmet, GNSItems.spectrite_chestplate, GNSItems.spectrite_leggings, GNSItems.spectrite_boots});
            this.tag(ItemTags.TRIMMABLE_ARMOR).add((Object[])new Item[]{GNSItems.negatite_helmet, GNSItems.negatite_chestplate, GNSItems.negatite_leggings, GNSItems.negatite_boots});
            this.tag(ItemTags.TRIMMABLE_ARMOR).add((Object[])new Item[]{GNSItems.zitrite_helmet, GNSItems.zitrite_chestplate, GNSItems.zitrite_leggings, GNSItems.zitrite_boots});
            this.tag(ItemTags.HEAD_ARMOR).add((Object[])new Item[]{GNSItems.candy_helmet, GNSItems.spectrite_helmet, GNSItems.positite_helmet, GNSItems.zitrite_helmet, GNSItems.negatite_helmet});
            this.tag(ItemTags.CHEST_ARMOR).add((Object[])new Item[]{GNSItems.candy_chestplate, GNSItems.spectrite_chestplate, GNSItems.positite_chestplate, GNSItems.zitrite_chestplate, GNSItems.negatite_chestplate});
            this.tag(ItemTags.LEG_ARMOR).add((Object[])new Item[]{GNSItems.candy_leggings, GNSItems.spectrite_leggings, GNSItems.positite_leggings, GNSItems.zitrite_leggings, GNSItems.negatite_leggings});
            this.tag(ItemTags.FOOT_ARMOR).add((Object[])new Item[]{GNSItems.candy_boots, GNSItems.spectrite_boots, GNSItems.positite_boots, GNSItems.zitrite_boots, GNSItems.negatite_boots});
        }

        void forge() {
            this.copy(Tags.Blocks.ORES, Tags.Items.ORES);
            this.copy(Tags.Blocks.ORES_COAL, Tags.Items.ORES_COAL);
            this.copy(Tags.Blocks.ORES_LAPIS, Tags.Items.ORES_LAPIS);
            this.copy(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
            this.tag(Tags.Items.CROPS).add((Object)GNSItems.rainbow_berries);
            this.tag(Tags.Items.FOODS_BERRY).add((Object)GNSItems.rainbow_berries);
            this.tag(Tags.Items.FOODS_CANDY).add((Object[])new Item[]{GNSItems.candy, GNSItems.lollipop});
            this.tag(Tags.Items.FOODS_SOUP).add((Object[])new Item[]{GNSItems.luxurious_soup, GNSItems.wretched_soup});
            this.tag(Tags.Items.GEMS).addTags(new TagKey[]{GNSItemTags.POSITITE, GNSItemTags.NEGATITE});
            this.tag(Tags.Items.INGOTS).addTags(new TagKey[]{GNSItemTags.SPECTRITE_INGOTS, GNSItemTags.ZITRITE_INGOTS});
            this.tag(Tags.Items.SEEDS).add((Object)GNSItems.rainbow_seeds);
            this.tag(Tags.Items.RAW_MATERIALS).add((Object[])new Item[]{GNSItems.raw_spectrite, GNSItems.raw_zitrite});
            this.tag(Tags.Items.MELEE_WEAPON_TOOLS).add((Object[])new Item[]{GNSItems.candy_sword, GNSItems.positite_sword, GNSItems.spectrite_sword, GNSItems.necrum_sword, GNSItems.negatite_sword, GNSItems.zitrite_sword, GNSItems.candy_axe, GNSItems.positite_axe, GNSItems.spectrite_axe, GNSItems.necrum_axe, GNSItems.negatite_axe, GNSItems.zitrite_axe});
            this.tag(Tags.Items.MINING_TOOL_TOOLS).add((Object[])new Item[]{GNSItems.candy_pickaxe, GNSItems.positite_pickaxe, GNSItems.spectrite_pickaxe, GNSItems.necrum_pickaxe, GNSItems.negatite_pickaxe, GNSItems.zitrite_pickaxe});
        }

        public String getName() {
            return "Good Night's Sleep Item Tags";
        }
    }

    public static class BlockTagProv
    extends BlockTagsProvider {
        public BlockTagProv(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "good_nights_sleep");
        }

        protected void addTags(HolderLookup.Provider prov) {
            this.goodNightsSleep(prov);
            this.vanilla(prov);
            this.forge(prov);
        }

        void goodNightsSleep(HolderLookup.Provider prov) {
            this.tag(GNSBlockTags.PLANKS).add((Object[])new Block[]{GNSBlocks.dream_planks, GNSBlocks.white_planks, GNSBlocks.dead_planks, GNSBlocks.blood_planks});
            this.tag(GNSBlockTags.DREAM_LOGS).add((Object[])new Block[]{GNSBlocks.dream_log, GNSBlocks.dream_wood, GNSBlocks.stripped_dream_log, GNSBlocks.stripped_dream_wood});
            this.tag(GNSBlockTags.WHITE_LOGS).add((Object[])new Block[]{GNSBlocks.white_log, GNSBlocks.white_wood, GNSBlocks.stripped_white_log, GNSBlocks.stripped_white_wood});
            this.tag(GNSBlockTags.DEAD_LOGS).add((Object[])new Block[]{GNSBlocks.dead_log, GNSBlocks.dead_wood, GNSBlocks.stripped_dead_log, GNSBlocks.stripped_dead_wood});
            this.tag(GNSBlockTags.BLOOD_LOGS).add((Object[])new Block[]{GNSBlocks.blood_log, GNSBlocks.blood_wood, GNSBlocks.stripped_blood_log, GNSBlocks.stripped_blood_wood});
            this.tag(GNSBlockTags.COBBLESTONES).add((Object)GNSBlocks.delusion_cobblestone);
            this.tag(GNSBlockTags.STONES).add((Object)GNSBlocks.delusion_stone);
            this.tag(GNSBlockTags.MUSHROOMS).add((Object[])new Block[]{GNSBlocks.hope_mushroom, GNSBlocks.despair_mushroom});
            this.tag(GNSBlockTags.CANDY_ORES).add((Object)GNSBlocks.candy_ore);
            this.tag(GNSBlockTags.SPECTRITE_ORES).add((Object)GNSBlocks.spectrite_ore);
            this.tag(GNSBlockTags.POSITITE_ORES).add((Object)GNSBlocks.positite_ore);
            this.tag(GNSBlockTags.NECRUM_ORES).add((Object)GNSBlocks.fossilized_necrum);
            this.tag(GNSBlockTags.ZITRITE_ORES).add((Object)GNSBlocks.zitrite_ore);
            this.tag(GNSBlockTags.NEGATITE_ORES).add((Object)GNSBlocks.negatite_ore);
            this.tag(GNSBlockTags.CANDY_BLOCKS).add((Object)GNSBlocks.hard_candy_block);
            this.tag(GNSBlockTags.SPECTRITE_BLOCKS).add((Object)GNSBlocks.spectrite_block);
            this.tag(GNSBlockTags.POSITITE_BLOCKS).add((Object)GNSBlocks.positite_block);
            this.tag(GNSBlockTags.NECRUM_BLOCKS).add((Object)GNSBlocks.necrum_block);
            this.tag(GNSBlockTags.ZITRITE_BLOCKS).add((Object)GNSBlocks.zitrite_block);
            this.tag(GNSBlockTags.NEGATITE_BLOCKS).add((Object)GNSBlocks.negatite_block);
        }

        void vanilla(HolderLookup.Provider prov) {
            this.addMatching((Block block) -> block instanceof FlowerPotBlock, BlockTags.FLOWER_POTS);
            this.addMatching((Block block) -> block instanceof LeavesBlock, BlockTags.LEAVES);
            this.addMatching((Block block) -> block instanceof SaplingBlock, BlockTags.SAPLINGS);
            this.addMatching((Block block) -> block instanceof SlabBlock, BlockTags.SLABS);
            this.addMatching((Block block) -> block instanceof FlowerBlock, BlockTags.SMALL_FLOWERS);
            this.addMatching((Block block) -> block instanceof StairBlock, BlockTags.STAIRS);
            this.addMatching((Block block) -> block instanceof GrassBlock, BlockTags.VALID_SPAWN);
            this.addMatching((Block block) -> block instanceof WallBlock, BlockTags.WALLS);
            this.tag(BlockTags.WOODEN_BUTTONS).add((Object[])new Block[]{GNSBlocks.dream_button, GNSBlocks.white_button, GNSBlocks.dead_button, GNSBlocks.blood_button});
            this.tag(BlockTags.WOODEN_PRESSURE_PLATES).add((Object[])new Block[]{GNSBlocks.dream_pressure_plate, GNSBlocks.white_pressure_plate, GNSBlocks.dead_pressure_plate, GNSBlocks.blood_pressure_plate});
            this.tag(BlockTags.WOODEN_DOORS).add((Object[])new Block[]{GNSBlocks.dream_door, GNSBlocks.white_door, GNSBlocks.dead_door, GNSBlocks.blood_door});
            this.tag(BlockTags.WOODEN_TRAPDOORS).add((Object[])new Block[]{GNSBlocks.dream_trapdoor, GNSBlocks.white_trapdoor, GNSBlocks.dead_trapdoor, GNSBlocks.blood_trapdoor});
            this.tag(BlockTags.WOODEN_SLABS).add((Object[])new Block[]{GNSBlocks.dream_slab, GNSBlocks.white_slab, GNSBlocks.dead_slab, GNSBlocks.blood_slab});
            this.tag(BlockTags.WOODEN_STAIRS).add((Object[])new Block[]{GNSBlocks.dream_stairs, GNSBlocks.white_stairs, GNSBlocks.dead_stairs, GNSBlocks.blood_stairs});
            this.tag(BlockTags.WOODEN_FENCES).add((Object[])new Block[]{GNSBlocks.dream_fence, GNSBlocks.white_fence, GNSBlocks.dead_fence, GNSBlocks.blood_fence});
            this.tag(BlockTags.FENCE_GATES).add((Object[])new Block[]{GNSBlocks.dream_fence_gate, GNSBlocks.white_fence_gate, GNSBlocks.dead_fence_gate, GNSBlocks.blood_fence_gate});
            this.tag(BlockTags.PLANKS).addTag(GNSBlockTags.PLANKS);
            this.tag(BlockTags.LOGS).addTags(new TagKey[]{GNSBlockTags.DEAD_LOGS, GNSBlockTags.BLOOD_LOGS});
            this.tag(BlockTags.LOGS_THAT_BURN).addTags(new TagKey[]{GNSBlockTags.DREAM_LOGS, GNSBlockTags.WHITE_LOGS});
            this.addMatching((TagKey<Block>)BlockTags.STANDING_SIGNS, (Block b) -> b instanceof StandingSignBlock);
            this.addMatching((TagKey<Block>)BlockTags.WALL_SIGNS, (Block b) -> b instanceof WallSignBlock);
            this.addMatching((TagKey<Block>)BlockTags.CEILING_HANGING_SIGNS, (Block b) -> b instanceof CeilingHangingSignBlock);
            this.addMatching((TagKey<Block>)BlockTags.WALL_HANGING_SIGNS, (Block b) -> b instanceof WallHangingSignBlock);
            this.tag(BlockTags.STONE_BUTTONS).add((Object)GNSBlocks.delusion_button);
            this.tag(BlockTags.STONE_PRESSURE_PLATES).add((Object)GNSBlocks.delusion_pressure_plate);
            this.tag(BlockTags.BEACON_BASE_BLOCKS).addTags(new TagKey[]{GNSBlockTags.SPECTRITE_BLOCKS, GNSBlockTags.POSITITE_BLOCKS, GNSBlockTags.ZITRITE_BLOCKS, GNSBlockTags.NEGATITE_BLOCKS});
            this.tag(BlockTags.ANIMALS_SPAWNABLE_ON).add((Object[])new Block[]{GNSBlocks.dream_grass_block, GNSBlocks.nightmare_grass_block});
            this.tag(BlockTags.DIRT).add((Object[])new Block[]{GNSBlocks.dream_grass_block, GNSBlocks.dream_dirt, GNSBlocks.nightmare_grass_block});
            this.tag(BlockTags.BEDS).add((Object[])new Block[]{GNSBlocks.luxurious_bed, GNSBlocks.wretched_bed, GNSBlocks.strange_bed});
            this.tag(BlockTags.MOSS_REPLACEABLE).add((Object)GNSBlocks.delusion_stone);
            this.tag(BlockTags.SCULK_REPLACEABLE).addTag(GNSBlockTags.STONES);
            this.tag(BlockTags.OVERWORLD_CARVER_REPLACEABLES).add((Object)GNSBlocks.delusion_stone);
            this.tag(BlockTags.GUARDED_BY_PIGLINS).add((Object)GNSBlocks.pot_of_gold);
            this.tag(BlockTags.MUSHROOM_GROW_BLOCK).add((Object[])new Block[]{GNSBlocks.dream_grass_block, GNSBlocks.dream_dirt, GNSBlocks.nightmare_grass_block});
            this.tag(BlockTags.COAL_ORES).add((Object)GNSBlocks.delusion_coal_ore);
            this.tag(BlockTags.LAPIS_ORES).add((Object)GNSBlocks.delusion_lapis_ore);
            this.tag(BlockTags.STONE_BRICKS).add((Object)GNSBlocks.delusion_stone_bricks);
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{GNSBlocks.delusion_button, GNSBlocks.delusion_pressure_plate, GNSBlocks.pot_of_gold});
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{GNSBlocks.delusion_stone, GNSBlocks.delusion_stone_slab, GNSBlocks.delusion_stone_stairs, GNSBlocks.delusion_stone_bricks, GNSBlocks.delusion_stone_brick_slab, GNSBlocks.delusion_stone_brick_stairs, GNSBlocks.delusion_stone_brick_wall, GNSBlocks.delusion_cobblestone, GNSBlocks.delusion_cobblestone_slab, GNSBlocks.delusion_cobblestone_stairs, GNSBlocks.delusion_cobblestone_wall});
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{GNSBlocks.candy_ore, GNSBlocks.spectrite_ore, GNSBlocks.positite_ore, GNSBlocks.fossilized_necrum, GNSBlocks.zitrite_ore, GNSBlocks.negatite_ore, GNSBlocks.delusion_coal_ore, GNSBlocks.delusion_lapis_ore});
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{GNSBlocks.hard_candy_block, GNSBlocks.spectrite_block, GNSBlocks.raw_spectrite_block, GNSBlocks.positite_block, GNSBlocks.necrum_block, GNSBlocks.zitrite_block, GNSBlocks.raw_zitrite_block, GNSBlocks.negatite_block});
            this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object[])new Block[]{GNSBlocks.short_dream_grass, GNSBlocks.short_nightmare_grass, GNSBlocks.prickly_nightmare_grass, GNSBlocks.hope_mushroom, GNSBlocks.hope_mushroom_block, GNSBlocks.despair_mushroom, GNSBlocks.despair_mushroom_block});
            this.addMatching((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE, (Block b) -> b instanceof FlowerBlock || b instanceof BushBlock);
            this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object[])new Block[]{GNSBlocks.dream_grass_block, GNSBlocks.dream_dirt, GNSBlocks.dream_farmland, GNSBlocks.nightmare_grass_block});
            this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object[])new Block[]{GNSBlocks.present, GNSBlocks.necrum_block, GNSBlocks.dream_leaves, GNSBlocks.candy_leaves, GNSBlocks.diamond_leaves});
            this.tag(BlockTags.NEEDS_STONE_TOOL).addTags(new TagKey[]{GNSBlockTags.SPECTRITE_BLOCKS, GNSBlockTags.SPECTRITE_ORES, GNSBlockTags.ZITRITE_BLOCKS, GNSBlockTags.ZITRITE_ORES});
            this.tag(BlockTags.NEEDS_IRON_TOOL).addTags(new TagKey[]{GNSBlockTags.POSITITE_BLOCKS, GNSBlockTags.POSITITE_ORES, GNSBlockTags.NEGATITE_BLOCKS, GNSBlockTags.NEGATITE_ORES});
            this.tag(BlockTags.SNIFFER_DIGGABLE_BLOCK).add((Object[])new Block[]{GNSBlocks.dream_dirt, GNSBlocks.dream_grass_block, GNSBlocks.nightmare_grass_block});
            this.tag(BlockTags.REPLACEABLE_BY_TREES).add((Object[])new Block[]{GNSBlocks.short_dream_grass, GNSBlocks.short_nightmare_grass, GNSBlocks.hope_mushroom, GNSBlocks.despair_mushroom});
            TagAppender appender = this.tag(BlockTags.REPLACEABLE);
            prov.lookupOrThrow(Registries.BLOCK).filterElements(b -> b.defaultBlockState().canBeReplaced()).listElements().filter(b -> b.key().location().getNamespace().equals("good_nights_sleep")).map(r -> (Block)r.value()).forEach(arg_0 -> ((TagAppender)appender).add(arg_0));
        }

        void forge(HolderLookup.Provider prov) {
            this.tag(Tags.Blocks.FENCES_WOODEN).add((Object[])new Block[]{GNSBlocks.dream_fence, GNSBlocks.white_fence, GNSBlocks.dead_fence, GNSBlocks.blood_fence});
            this.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object[])new Block[]{GNSBlocks.dream_fence_gate, GNSBlocks.white_fence_gate, GNSBlocks.dead_fence_gate, GNSBlocks.blood_fence_gate});
            this.tag(Tags.Blocks.COBBLESTONES_NORMAL).addTag(GNSBlockTags.COBBLESTONES);
            this.tag(Tags.Blocks.STONES).addTag(GNSBlockTags.STONES);
            this.tag(Tags.Blocks.ORES).addTags(new TagKey[]{GNSBlockTags.CANDY_ORES, GNSBlockTags.SPECTRITE_ORES, GNSBlockTags.POSITITE_ORES, GNSBlockTags.NECRUM_ORES, GNSBlockTags.ZITRITE_ORES, GNSBlockTags.NEGATITE_ORES});
            this.tag(Tags.Blocks.STORAGE_BLOCKS).addTags(new TagKey[]{GNSBlockTags.CANDY_BLOCKS, GNSBlockTags.SPECTRITE_BLOCKS, GNSBlockTags.POSITITE_BLOCKS, GNSBlockTags.NECRUM_BLOCKS, GNSBlockTags.ZITRITE_BLOCKS, GNSBlockTags.NEGATITE_BLOCKS});
            this.tag(Tags.Blocks.ORES_COAL).add((Object)GNSBlocks.delusion_coal_ore);
            this.tag(Tags.Blocks.ORES_LAPIS).add((Object)GNSBlocks.delusion_lapis_ore);
        }

        private Stream<Block> getMatching(Function<Block, Boolean> condition) {
            return BuiltInRegistries.BLOCK.stream().filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals("good_nights_sleep") && (Boolean)condition.apply((Block)block) != false);
        }

        @SafeVarargs
        private void addMatching(Function<Block, Boolean> condition, TagKey<Block> ... tags) {
            for (TagKey<Block> tag : tags) {
                this.getMatching(condition).forEach(arg_0 -> ((TagAppender)this.tag(tag)).add(arg_0));
            }
        }

        private void addMatching(TagKey<Block> blockTag, Function<Block, Boolean> condition) {
            this.getMatching(condition).forEach(arg_0 -> ((TagAppender)this.tag(blockTag)).add(arg_0));
        }

        public String getName() {
            return "Good Night's Sleep Block Tags";
        }
    }
}

