/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.entity.dream;

import com.legacy.good_nights_sleep.registry.GNSSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;

public class BabyCreeperEntity
extends Creeper {
    public BabyCreeperEntity(EntityType<? extends BabyCreeperEntity> type, Level level) {
        super(type, level);
        this.explosionRadius = level.getDifficulty() == Difficulty.PEACEFUL ? 0 : (level.getDifficulty() == Difficulty.HARD ? 2 : 1);
        this.maxSwell = 20;
    }

    protected boolean shouldDespawnInPeaceful() {
        return this.explosionRadius > 0;
    }

    public void tick() {
        super.tick();
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return GNSSounds.ENTITY_BABY_CREEPER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return GNSSounds.ENTITY_BABY_CREEPER_DEATH;
    }
}

