/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.entity.dream;

import com.legacy.good_nights_sleep.registry.GNSEntityTypes;
import com.legacy.good_nights_sleep.registry.GNSSounds;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class UnicornEntity
extends AbstractHorse {
    public static final EntityDataAccessor<Integer> UNICORN_TYPE = SynchedEntityData.defineId(UnicornEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public UnicornEntity(EntityType<? extends UnicornEntity> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(UNICORN_TYPE, (Object)0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData data) {
        this.setUnicornType(level.getRandom().nextInt(4));
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    public void tick() {
        super.tick();
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("UnicornType", this.getUnicornType());
    }

    public void load(ValueInput compound) {
        super.load(compound);
        this.setUnicornType(compound.getIntOr("UnicornType", 0));
    }

    protected void randomizeAttributes(RandomSource rand) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)UnicornEntity.generateMaxHealth(arg_0 -> ((RandomSource)rand).nextInt(arg_0)));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(UnicornEntity.generateSpeed(() -> ((RandomSource)rand).nextDouble()));
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(UnicornEntity.generateJumpStrength(() -> ((RandomSource)rand).nextDouble()));
    }

    protected SoundEvent getAmbientSound() {
        return GNSSounds.ENTITY_UNICORN_IDLE;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GNSSounds.ENTITY_UNICORN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return GNSSounds.ENTITY_UNICORN_DEATH;
    }

    protected SoundEvent getAngrySound() {
        return GNSSounds.ENTITY_UNICORN_ANGRY;
    }

    protected SoundEvent getEatingSound() {
        return GNSSounds.ENTITY_UNICORN_EAT;
    }

    protected void playGallopSound(SoundType soundType) {
        super.playGallopSound(soundType);
        if (this.random.nextInt(10) == 0) {
            this.playSound(GNSSounds.ENTITY_UNICORN_BREATHE, soundType.getVolume() * 0.6f, soundType.getPitch());
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTicks) {
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTicks).subtract(0.0, (double)0.2f, 0.0);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean flag;
        boolean bl = flag = !this.isBaby() && this.isTamed() && player.isSecondaryUseActive();
        if (!this.isVehicle() && !flag) {
            ItemStack itemstack = player.getItemInHand(hand);
            if (!itemstack.isEmpty()) {
                if (this.isFood(itemstack)) {
                    return this.fedFood(player, itemstack);
                }
                if (!this.isTamed()) {
                    this.makeMad();
                    return InteractionResult.SUCCESS;
                }
            }
            return super.mobInteract(player, hand);
        }
        return super.mobInteract(player, hand);
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal == this || !(otherAnimal instanceof UnicornEntity)) {
            return false;
        }
        UnicornEntity unicorn = (UnicornEntity)otherAnimal;
        return this.canParent() && unicorn.canParent();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        UnicornEntity mate = (UnicornEntity)otherParent;
        UnicornEntity child = (UnicornEntity)GNSEntityTypes.UNICORN.create((Level)level, EntitySpawnReason.BREEDING);
        if (child != null) {
            int aType = this.getUnicornType();
            int bType = mate.getUnicornType();
            child.setUnicornType(child.getRandom().nextBoolean() ? bType : aType);
            this.setOffspringAttributes(otherParent, child);
            return child;
        }
        return null;
    }

    public void setUnicornType(int type) {
        this.entityData.set(UNICORN_TYPE, (Object)type);
    }

    public int getUnicornType() {
        return (Integer)this.entityData.get(UNICORN_TYPE);
    }
}

