/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.event;

import com.legacy.good_nights_sleep.GNSConfig;
import com.legacy.good_nights_sleep.blocks.natural.DreamFarmlandBlock;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.registry.GNSDimensions;
import com.legacy.good_nights_sleep.world.GNSTeleporter;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class GNSEvents {
    @SubscribeEvent
    public static void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if ((event.getTarget() instanceof ZombieHorse || event.getTarget() instanceof SkeletonHorse) && player.level().dimension().equals(GNSDimensions.nightmareKey()) && !((AbstractHorse)event.getTarget()).isTamed() && player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty()) {
            player.swing(InteractionHand.MAIN_HAND);
            player.startRiding(event.getTarget());
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingCheckSpawn(FinalizeSpawnEvent event) {
        Sheep sheep;
        Phantom phantom;
        Mob mob = event.getEntity();
        if (mob instanceof Phantom && (phantom = (Phantom)mob).level().dimension().equals(GNSDimensions.nightmareKey()) && !GNSConfig.WORLD.allowNightmarePhantoms()) {
            event.setSpawnCancelled(true);
        }
        if ((mob = event.getEntity()) instanceof Sheep && (sheep = (Sheep)mob).level().dimension().equals(GNSDimensions.dreamKey())) {
            sheep.setColor((DyeColor)Util.getRandom((Object[])DyeColor.values(), (RandomSource)sheep.getRandom()));
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer player;
        Player player2;
        block5: {
            block4: {
                player2 = event.getEntity();
                if (!(player2 instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)player2;
                player2 = event.getLevel();
                if (player2 instanceof ServerLevel) break block5;
            }
            return;
        }
        ServerLevel level = (ServerLevel)player2;
        BlockState state = level.getBlockState(event.getPos());
        if (!level.isClientSide && state.getBlock() instanceof BedBlock && GNSDimensions.inSleepDimension((Entity)player)) {
            player.swing(InteractionHand.MAIN_HAND, true);
            event.setCanceled(true);
            BlockPos pos = player.getRespawnConfig() != null ? player.getRespawnConfig().pos() : level.getSharedSpawnPos();
            GNSTeleporter.changeDimension((ResourceKey<Level>)Level.OVERWORLD, (Entity)player, pos);
        }
    }

    @SubscribeEvent
    public static void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        LevelAccessor levelAccessor;
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (state.is(GNSBlocks.dream_farmland) && (levelAccessor = event.getLevel()) instanceof Level) {
            Level l = (Level)levelAccessor;
            DreamFarmlandBlock.turnToDreamDirt(event.getEntity(), state, l, event.getPos());
            event.setCanceled(true);
        }
    }
}

