/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.event;

import com.legacy.good_nights_sleep.GNSConfig;
import com.legacy.good_nights_sleep.blocks.GNSBedBlock;
import com.legacy.good_nights_sleep.blocks.util.ToolCompat;
import com.legacy.good_nights_sleep.capabillity.DreamPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class GNSPlayerEvents {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            DreamPlayer.get(p).onDeath();
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            DreamPlayer.get(p).serverTick();
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            DreamPlayer.get((Player)sp).syncDataToClient();
        }
    }

    @SubscribeEvent
    public static void onEntityChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            DreamPlayer.get((Player)sp).syncDataToClient();
        }
    }

    @SubscribeEvent
    public static void onWakeUp(PlayerWakeUpEvent event) {
        if (event.getEntity().isSleepingLongEnough()) {
            event.getEntity().getSleepingPos().ifPresent(pos -> GNSBedBlock.onWakeUp(event, event.getEntity(), event.getEntity().level().getBlockState(pos), pos));
        }
    }

    @SubscribeEvent
    public static void canKeepSleeping(CanContinueSleepingEvent event) {
        if (event.getProblem() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW) {
            event.getEntity().getSleepingPos().ifPresent(pos -> {
                if (event.getEntity().level().getBlockState(pos).getBlock() instanceof GNSBedBlock) {
                    event.setContinueSleeping(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void canSleep(CanPlayerSleepEvent event) {
        if (event.getProblem() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW && !GNSConfig.WORLD.limitSleepTime() && event.getLevel().getBlockState(event.getPos()).getBlock() instanceof GNSBedBlock) {
            event.setProblem(null);
        }
    }

    @SubscribeEvent
    public static void onToolUse(BlockEvent.BlockToolModificationEvent event) {
        Block result;
        ItemAbility toolAction = event.getItemAbility();
        if (toolAction == ItemAbilities.AXE_STRIP) {
            BlockState finalState = event.getFinalState();
            Block result2 = ToolCompat.AXE_STRIPPING.get(finalState.getBlock());
            if (result2 != null) {
                event.setFinalState(result2.withPropertiesOf(finalState));
            }
        } else if (toolAction == ItemAbilities.HOE_TILL && (result = ToolCompat.HOE_TILLING.get(event.getFinalState().getBlock())) != null) {
            event.setFinalState(result.defaultBlockState());
        }
    }
}

