/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.item;

import com.legacy.good_nights_sleep.capabillity.DreamPlayer;
import com.legacy.good_nights_sleep.registry.GNSDimensions;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class SleepyStewItem
extends Item {
    private final boolean isEvil;

    public SleepyStewItem(Item.Properties props, boolean isEvil) {
        super(props);
        this.isEvil = isEvil;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            if (GNSDimensions.inSleepDimension((Entity)entity)) {
                DreamPlayer dp = DreamPlayer.get(player);
                if (!this.isEvil && level.dimension().equals(GNSDimensions.dreamKey()) || this.isEvil && level.dimension().equals(GNSDimensions.nightmareKey())) {
                    dp.setEnteredDreamTime(level.getGameTime());
                } else {
                    dp.setEnteredDreamTime(dp.getEnteredDreamTime() - 25200L);
                }
                dp.syncDataToClient();
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        tooltipAdder.accept((Component)Component.translatable((String)(stack.getItem().getDescriptionId() + ".description")).withStyle(ChatFormatting.GRAY));
    }
}

