/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.network;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.capabillity.DreamPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncPlayerPayload(DreamPlayer attachment) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncPlayerPayload> TYPE = new CustomPacketPayload.Type(GoodNightSleep.locate("sync_player"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncPlayerPayload> STREAM_CODEC = StreamCodec.composite(DreamPlayer.STREAM_CODEC, SyncPlayerPayload::attachment, SyncPlayerPayload::new);

    public CustomPacketPayload.Type<SyncPlayerPayload> type() {
        return TYPE;
    }

    public static void handler(SyncPlayerPayload packet, IPayloadContext context) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            context.enqueueWork(() -> Handler.handlePacket(packet));
        }
    }

    private static final class Handler {
        private Handler() {
        }

        private static void handlePacket(SyncPlayerPayload packet) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                DreamPlayer.get((Player)player).copyFrom(packet.attachment);
            }
        }
    }
}

