/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.registry;

import com.legacy.good_nights_sleep.blocks.GNSCeilingHangingSignBlock;
import com.legacy.good_nights_sleep.blocks.GNSFlowerPotBlock;
import com.legacy.good_nights_sleep.blocks.GNSStandingSignBlock;
import com.legacy.good_nights_sleep.blocks.GNSWallHangingSignBlock;
import com.legacy.good_nights_sleep.blocks.GNSWallSignBlock;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import java.util.function.Supplier;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;

public interface BlockReg {
    public static final Supplier<BlockBehaviour.Properties> LEAVES = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES);
    public static final Supplier<BlockBehaviour.Properties> LOG = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG);
    public static final Supplier<BlockBehaviour.Properties> SAPLING = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING);
    public static final Supplier<BlockBehaviour.Properties> PLANKS = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
    public static final Supplier<BlockBehaviour.Properties> SLAB = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB);
    public static final Supplier<BlockBehaviour.Properties> STAIRS = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS);
    public static final Supplier<BlockBehaviour.Properties> FENCE = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE);
    public static final Supplier<BlockBehaviour.Properties> GATE = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE);
    public static final Supplier<BlockBehaviour.Properties> PRESSURE_PLATE = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE);
    public static final Supplier<BlockBehaviour.Properties> BUTTON = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON);
    public static final Supplier<BlockBehaviour.Properties> DOOR = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR);
    public static final Supplier<BlockBehaviour.Properties> TRAPDOOR = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR);
    public static final Supplier<BlockBehaviour.Properties> GLASS = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS);
    public static final Supplier<BlockBehaviour.Properties> SIGN = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN);
    public static final Supplier<BlockBehaviour.Properties> HANGING_SIGN = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN);
    public static final Supplier<BlockBehaviour.Properties> STONE_BUTTON = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON);
    public static final Supplier<BlockBehaviour.Properties> STONE_PRESSURE_PLATE = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_PRESSURE_PLATE);

    public static Block log(String key) {
        return GNSBlocks.register(key, RotatedPillarBlock::new, LOG);
    }

    public static Block planks(String key) {
        return GNSBlocks.register(key, Block::new, PLANKS);
    }

    public static Block leaves(String key, float leafChance, int tint) {
        return GNSBlocks.register(key, p -> new UntintedParticleLeavesBlock(leafChance, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)tint), p), LEAVES);
    }

    public static Block sign(String key, WoodType type) {
        return GNSBlocks.registerBlock(key, p -> new GNSStandingSignBlock((BlockBehaviour.Properties)p, type), SIGN);
    }

    public static Block wallSign(String key, WoodType type) {
        return GNSBlocks.registerBlock(key, p -> new GNSWallSignBlock((BlockBehaviour.Properties)p, type), SIGN);
    }

    public static Block hangingSign(String key, WoodType type) {
        return GNSBlocks.registerBlock(key, p -> new GNSCeilingHangingSignBlock((BlockBehaviour.Properties)p, type), SIGN);
    }

    public static Block wallHangingSign(String key, WoodType type) {
        return GNSBlocks.registerBlock(key, p -> new GNSWallHangingSignBlock((BlockBehaviour.Properties)p, type), SIGN);
    }

    public static Block woodenButton(String key, BlockSetType type) {
        return GNSBlocks.register(key, p -> new ButtonBlock(type, 30, p), BUTTON);
    }

    public static Block stoneButton(String key, BlockSetType type) {
        return GNSBlocks.register(key, p -> new ButtonBlock(type, 20, p), STONE_BUTTON);
    }

    public static Block woodenPressurePlate(String key, BlockSetType type) {
        return GNSBlocks.register(key, p -> new PressurePlateBlock(type, p), BUTTON);
    }

    public static Block stonePressurePlate(String key, BlockSetType type) {
        return GNSBlocks.register(key, p -> new PressurePlateBlock(type, p), STONE_PRESSURE_PLATE);
    }

    public static Block slab(String key, Block parent) {
        return GNSBlocks.register(key, SlabBlock::new, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)parent));
    }

    public static Block stairs(String key, Block parent) {
        return GNSBlocks.register(key, p -> new StairBlock(parent.defaultBlockState(), p), () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)parent));
    }

    public static Block fence(String key) {
        return GNSBlocks.register(key, FenceBlock::new, FENCE);
    }

    public static Block gate(String key, WoodType type) {
        return GNSBlocks.register(key, p -> new FenceGateBlock(type, p), GATE);
    }

    public static Block door(String key, BlockSetType type) {
        return GNSBlocks.registerBlock(key, p -> new DoorBlock(type, p), DOOR);
    }

    public static Block trapdoor(String key, BlockSetType type) {
        return GNSBlocks.register(key, p -> new TrapDoorBlock(type, p), TRAPDOOR);
    }

    public static Block flowerPot(String key, Supplier<Block> flower) {
        return GNSBlocks.registerBlock(key, p -> new GNSFlowerPotBlock((Supplier<? extends Block>)flower, (BlockBehaviour.Properties)p), () -> BlockBehaviour.Properties.of().strength(0.0f));
    }
}

