/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.registry;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.data.GNSBiomeProv;
import com.legacy.good_nights_sleep.util.Pointer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.animal.sheep.SheepColorSpawnRules;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforge.registries.RegisterEvent;

public class GNSBiomes {
    private static final Map<ResourceLocation, Pointer<Biome>> POINTERS = new HashMap<ResourceLocation, Pointer<Biome>>();
    public static final Pointer<Biome> SLEEPY_HILLS = GNSBiomes.create("sleepy_hills", c -> GNSBiomeProv.sleepyHills(c, 0.5f, 0.0f, 4159204, 329011));
    public static final Pointer<Biome> GOOD_DREAM_PLAINS = GNSBiomes.create("good_dream_plains", c -> GNSBiomeProv.goodDreamPlains(c, 0.5f, 0.0f, 4159204, 329011));
    public static final Pointer<Biome> DREAMY_FOREST = GNSBiomes.create("dreamy_forest", c -> GNSBiomeProv.dreamyForest(c, 0.5f, 0.0f, 4159204, 329011));
    public static final Pointer<Biome> LOLLIPOP_LANDS = GNSBiomes.create("lollipop_lands", c -> GNSBiomeProv.lollipopLands(c, 0.5f, 0.0f, 4159204, 329011));
    public static final Pointer<Biome> NIGHTMARE_MOUND = GNSBiomes.create("nightmare_mound", c -> GNSBiomeProv.nightmareMound(c, 0.8f, 0.0f, 4159204, 329011));
    public static final Pointer<Biome> SHAMEFUL_PLAINS = GNSBiomes.create("shameful_plains", c -> GNSBiomeProv.shamefulPlains(c, 0.8f, 0.0f, 4159204, 329011));
    public static final Pointer<Biome> WASTED_FOREST = GNSBiomes.create("wasted_forest", c -> GNSBiomeProv.wastedForest(c, 0.8f, 0.0f, 4159204, 329011));
    public static final SheepColorSpawnRules.SheepColorSpawnConfiguration DREAM_SHEEP_SPAWN_CONFIGURATION = new SheepColorSpawnRules.SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted((WeightedList)SheepColorSpawnRules.builder().add((Object)SheepColorSpawnRules.single((DyeColor)DyeColor.RED), 1).add((Object)SheepColorSpawnRules.single((DyeColor)DyeColor.ORANGE), 1).add((Object)SheepColorSpawnRules.single((DyeColor)DyeColor.YELLOW), 1).add((Object)SheepColorSpawnRules.single((DyeColor)DyeColor.LIME), 1).add((Object)SheepColorSpawnRules.single((DyeColor)DyeColor.BLUE), 1).add((Object)SheepColorSpawnRules.single((DyeColor)DyeColor.PURPLE), 1).add((Object)SheepColorSpawnRules.single((DyeColor)DyeColor.CYAN), 1).add((Object)SheepColorSpawnRules.commonColors((DyeColor)DyeColor.WHITE), 5).build()));

    public static void bootstrap(BootstrapContext<Biome> bootstrap) {
        POINTERS.forEach((key, pointer) -> bootstrap.register(pointer.getKey(), (Object)((Biome)pointer.getInstance().apply(bootstrap))));
    }

    public static void init(RegisterEvent event) {
    }

    private static Pointer<Biome> create(String name, Function<BootstrapContext<?>, Biome> biome) {
        Pointer<Biome> pointer = new Pointer<Biome>(Registries.BIOME, name, biome);
        if (DatagenModLoader.isRunningDataGen()) {
            POINTERS.put(GoodNightSleep.locate(name), pointer);
        }
        return pointer;
    }
}

