/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.registry;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.blocks.GNSBedBlock;
import com.legacy.good_nights_sleep.blocks.GNSOreBlock;
import com.legacy.good_nights_sleep.blocks.PotOfGoldBlock;
import com.legacy.good_nights_sleep.blocks.RainbowBlock;
import com.legacy.good_nights_sleep.blocks.natural.DreamFarmlandBlock;
import com.legacy.good_nights_sleep.blocks.natural.DreamGrassBlock;
import com.legacy.good_nights_sleep.blocks.natural.GNSTallGrassBlock;
import com.legacy.good_nights_sleep.blocks.natural.PricklyGrassBlock;
import com.legacy.good_nights_sleep.blocks.natural.RainbowBerriesBlock;
import com.legacy.good_nights_sleep.registry.BlockReg;
import com.legacy.good_nights_sleep.registry.GNSBlockSets;
import com.legacy.good_nights_sleep.registry.GNSFeatures;
import com.legacy.good_nights_sleep.registry.GNSWoodTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.registries.RegisterEvent;

public class GNSBlocks {
    public static Block dream_grass_block;
    public static Block dream_dirt;
    public static Block dream_farmland;
    public static Block nightmare_grass_block;
    public static Block short_dream_grass;
    public static Block lollipop_bush;
    public static Block short_nightmare_grass;
    public static Block prickly_nightmare_grass;
    public static Block zitrite_ore;
    public static Block candy_ore;
    public static Block spectrite_ore;
    public static Block positite_ore;
    public static Block negatite_ore;
    public static Block fossilized_necrum;
    public static Block raw_spectrite_block;
    public static Block raw_zitrite_block;
    public static Block delusion_coal_ore;
    public static Block delusion_lapis_ore;
    public static Block candy_leaves;
    public static Block dream_leaves;
    public static Block diamond_leaves;
    public static Block hard_candy_block;
    public static Block spectrite_block;
    public static Block positite_block;
    public static Block necrum_block;
    public static Block zitrite_block;
    public static Block negatite_block;
    public static Block dead_planks;
    public static Block blood_planks;
    public static Block white_planks;
    public static Block dream_planks;
    public static Block dream_sapling;
    public static Block candy_sapling;
    public static Block orange_flower;
    public static Block cyan_flower;
    public static Block dead_flower;
    public static Block despair_mushroom;
    public static Block hope_mushroom;
    public static Block hope_mushroom_block;
    public static Block despair_mushroom_block;
    public static Block rainbow_berries;
    public static Block dream_log;
    public static Block white_log;
    public static Block dead_log;
    public static Block blood_log;
    public static Block dream_wood;
    public static Block white_wood;
    public static Block dead_wood;
    public static Block blood_wood;
    public static Block stripped_dream_log;
    public static Block stripped_white_log;
    public static Block stripped_dead_log;
    public static Block stripped_blood_log;
    public static Block stripped_dream_wood;
    public static Block stripped_white_wood;
    public static Block stripped_dead_wood;
    public static Block stripped_blood_wood;
    public static Block delusion_stone;
    public static Block delusion_cobblestone;
    public static Block delusion_stone_bricks;
    public static Block dream_fence;
    public static Block white_fence;
    public static Block dead_fence;
    public static Block blood_fence;
    public static Block delusion_cobblestone_wall;
    public static Block delusion_stone_brick_wall;
    public static Block dream_fence_gate;
    public static Block white_fence_gate;
    public static Block dead_fence_gate;
    public static Block blood_fence_gate;
    public static Block dream_button;
    public static Block white_button;
    public static Block dead_button;
    public static Block blood_button;
    public static Block delusion_button;
    public static Block dream_pressure_plate;
    public static Block white_pressure_plate;
    public static Block dead_pressure_plate;
    public static Block blood_pressure_plate;
    public static Block delusion_pressure_plate;
    public static Block dream_door;
    public static Block white_door;
    public static Block dead_door;
    public static Block blood_door;
    public static Block dream_trapdoor;
    public static Block white_trapdoor;
    public static Block dead_trapdoor;
    public static Block blood_trapdoor;
    public static Block dream_slab;
    public static Block white_slab;
    public static Block dead_slab;
    public static Block blood_slab;
    public static Block delusion_stone_slab;
    public static Block delusion_cobblestone_slab;
    public static Block delusion_stone_brick_slab;
    public static Block dead_stairs;
    public static Block blood_stairs;
    public static Block white_stairs;
    public static Block dream_stairs;
    public static Block delusion_stone_stairs;
    public static Block delusion_cobblestone_stairs;
    public static Block delusion_stone_brick_stairs;
    public static Block pot_of_gold;
    public static Block present;
    public static Block rainbow;
    public static Block luxurious_bed;
    public static Block wretched_bed;
    public static Block strange_bed;
    public static Block potted_dream_sapling;
    public static Block potted_candy_sapling;
    public static Block potted_hope_mushroom;
    public static Block potted_despair_mushroom;
    public static Block potted_orange_flower;
    public static Block potted_cyan_flower;
    public static Block potted_dead_flower;
    public static Block potted_lollipop_bush;
    public static Block potted_dream_grass;
    public static Block potted_nightmare_grass;
    public static Block potted_prickly_nightmare_grass;
    public static Block dream_sign;
    public static Block dream_wall_sign;
    public static Block white_sign;
    public static Block white_wall_sign;
    public static Block blood_sign;
    public static Block blood_wall_sign;
    public static Block dead_sign;
    public static Block dead_wall_sign;
    public static Block dream_hanging_sign;
    public static Block dream_wall_hanging_sign;
    public static Block white_hanging_sign;
    public static Block white_wall_hanging_sign;
    public static Block blood_hanging_sign;
    public static Block blood_wall_hanging_sign;
    public static Block dead_hanging_sign;
    public static Block dead_wall_hanging_sign;
    private static RegisterEvent registryEvent;
    public static Map<String, Block> blockItemList;
    public static final Lazy<TreeGrower> DREAM_GROWER;
    public static final Lazy<TreeGrower> CANDY_GROWER;

    public static void init(RegisterEvent event) {
        registryEvent = event;
        luxurious_bed = GNSBlocks.registerBlock("luxurious_bed", GNSBedBlock::new, GNSBlocks.copy(Blocks.CYAN_BED));
        wretched_bed = GNSBlocks.registerBlock("wretched_bed", GNSBedBlock::new, GNSBlocks.copy(Blocks.GRAY_BED));
        strange_bed = GNSBlocks.registerBlock("strange_bed", GNSBedBlock::new, GNSBlocks.copy(Blocks.RED_BED));
        short_dream_grass = GNSBlocks.register("short_dream_grass", GNSTallGrassBlock::new, GNSBlocks.copy(Blocks.SHORT_GRASS));
        short_nightmare_grass = GNSBlocks.register("short_nightmare_grass", GNSTallGrassBlock::new, GNSBlocks.copy(Blocks.SHORT_GRASS));
        prickly_nightmare_grass = GNSBlocks.register("prickly_nightmare_grass", PricklyGrassBlock::new, GNSBlocks.copy(Blocks.SHORT_GRASS));
        dream_grass_block = GNSBlocks.register("dream_grass_block", p -> new DreamGrassBlock((BlockBehaviour.Properties)p, () -> dream_dirt, () -> short_dream_grass), GNSBlocks.copy(Blocks.GRASS_BLOCK));
        dream_dirt = GNSBlocks.register("dream_dirt", Block::new, GNSBlocks.copy(Blocks.DIRT));
        dream_farmland = GNSBlocks.register("dream_farmland", DreamFarmlandBlock::new, GNSBlocks.copy(Blocks.FARMLAND));
        delusion_stone = GNSBlocks.register("delusion_stone", Block::new, GNSBlocks.copy(Blocks.STONE));
        delusion_cobblestone = GNSBlocks.register("delusion_cobblestone", Block::new, GNSBlocks.copy(Blocks.COBBLESTONE));
        delusion_stone_bricks = GNSBlocks.register("delusion_stone_bricks", Block::new, GNSBlocks.copy(Blocks.STONE_BRICKS));
        nightmare_grass_block = GNSBlocks.register("nightmare_grass_block", p -> new DreamGrassBlock((BlockBehaviour.Properties)p, () -> Blocks.DIRT, () -> short_nightmare_grass), GNSBlocks.copy(Blocks.GRASS_BLOCK));
        hope_mushroom_block = GNSBlocks.register("hope_mushroom_block", HugeMushroomBlock::new, GNSBlocks.copy(Blocks.RED_MUSHROOM_BLOCK));
        despair_mushroom_block = GNSBlocks.register("despair_mushroom_block", HugeMushroomBlock::new, GNSBlocks.copy(Blocks.BROWN_MUSHROOM_BLOCK));
        candy_ore = GNSBlocks.register("candy_ore", p -> new GNSOreBlock((BlockBehaviour.Properties)p, 0, 1), GNSBlocks.copy(Blocks.COAL_ORE));
        spectrite_ore = GNSBlocks.register("spectrite_ore", p -> new GNSOreBlock((BlockBehaviour.Properties)p, 1, 2), GNSBlocks.copy(Blocks.IRON_ORE));
        positite_ore = GNSBlocks.register("positite_ore", p -> new GNSOreBlock((BlockBehaviour.Properties)p, 3, 7), GNSBlocks.copy(Blocks.DIAMOND_ORE));
        fossilized_necrum = GNSBlocks.register("fossilized_necrum", p -> new GNSOreBlock((BlockBehaviour.Properties)p, 0, 1), GNSBlocks.copy(Blocks.COAL_ORE));
        zitrite_ore = GNSBlocks.register("zitrite_ore", p -> new GNSOreBlock((BlockBehaviour.Properties)p, 1, 2), GNSBlocks.copy(Blocks.IRON_ORE));
        negatite_ore = GNSBlocks.register("negatite_ore", p -> new GNSOreBlock((BlockBehaviour.Properties)p, 3, 7), GNSBlocks.copy(Blocks.DIAMOND_ORE));
        delusion_coal_ore = GNSBlocks.register("delusion_coal_ore", p -> new GNSOreBlock((BlockBehaviour.Properties)p, 0, 2), GNSBlocks.copy(Blocks.COAL_ORE));
        delusion_lapis_ore = GNSBlocks.register("delusion_lapis_ore", p -> new GNSOreBlock((BlockBehaviour.Properties)p, 2, 5), GNSBlocks.copy(Blocks.LAPIS_ORE));
        int dreamLeafTint = 7264396;
        dream_leaves = BlockReg.leaves("dream_leaves", 0.01f, dreamLeafTint);
        candy_leaves = BlockReg.leaves("candy_leaves", 0.01f, 14591956);
        diamond_leaves = BlockReg.leaves("diamond_leaves", 0.02f, dreamLeafTint);
        dream_log = BlockReg.log("dream_log");
        white_log = BlockReg.log("white_log");
        dead_log = BlockReg.log("dead_log");
        blood_log = BlockReg.log("blood_log");
        dream_wood = BlockReg.log("dream_wood");
        white_wood = BlockReg.log("white_wood");
        dead_wood = BlockReg.log("dead_wood");
        blood_wood = BlockReg.log("blood_wood");
        stripped_dream_log = BlockReg.log("stripped_dream_log");
        stripped_white_log = BlockReg.log("stripped_white_log");
        stripped_dead_log = BlockReg.log("stripped_dead_log");
        stripped_blood_log = BlockReg.log("stripped_blood_log");
        stripped_dream_wood = BlockReg.log("stripped_dream_wood");
        stripped_white_wood = BlockReg.log("stripped_white_wood");
        stripped_dead_wood = BlockReg.log("stripped_dead_wood");
        stripped_blood_wood = BlockReg.log("stripped_blood_wood");
        dream_planks = BlockReg.planks("dream_planks");
        white_planks = BlockReg.planks("white_planks");
        dead_planks = BlockReg.planks("dead_planks");
        blood_planks = BlockReg.planks("blood_planks");
        dream_sign = BlockReg.sign("dream_sign", GNSWoodTypes.DREAM);
        white_sign = BlockReg.sign("white_sign", GNSWoodTypes.WHITE);
        dead_sign = BlockReg.sign("dead_sign", GNSWoodTypes.DEAD);
        blood_sign = BlockReg.sign("blood_sign", GNSWoodTypes.BLOOD);
        dream_wall_sign = BlockReg.wallSign("dream_wall_sign", GNSWoodTypes.DREAM);
        white_wall_sign = BlockReg.wallSign("white_wall_sign", GNSWoodTypes.WHITE);
        dead_wall_sign = BlockReg.wallSign("dead_wall_sign", GNSWoodTypes.DEAD);
        blood_wall_sign = BlockReg.wallSign("blood_wall_sign", GNSWoodTypes.BLOOD);
        dream_hanging_sign = BlockReg.hangingSign("dream_hanging_sign", GNSWoodTypes.DREAM);
        white_hanging_sign = BlockReg.hangingSign("white_hanging_sign", GNSWoodTypes.WHITE);
        dead_hanging_sign = BlockReg.hangingSign("dead_hanging_sign", GNSWoodTypes.DEAD);
        blood_hanging_sign = BlockReg.hangingSign("blood_hanging_sign", GNSWoodTypes.BLOOD);
        dream_wall_hanging_sign = BlockReg.wallHangingSign("dream_wall_hanging_sign", GNSWoodTypes.DREAM);
        white_wall_hanging_sign = BlockReg.wallHangingSign("white_wall_hanging_sign", GNSWoodTypes.WHITE);
        dead_wall_hanging_sign = BlockReg.wallHangingSign("dead_wall_hanging_sign", GNSWoodTypes.DEAD);
        blood_wall_hanging_sign = BlockReg.wallHangingSign("blood_wall_hanging_sign", GNSWoodTypes.BLOOD);
        dream_sapling = GNSBlocks.register("dream_sapling", p -> new SaplingBlock((TreeGrower)DREAM_GROWER.get(), p), GNSBlocks.copy(Blocks.OAK_SAPLING));
        candy_sapling = GNSBlocks.register("candy_sapling", p -> new SaplingBlock((TreeGrower)CANDY_GROWER.get(), p), GNSBlocks.copy(Blocks.OAK_SAPLING));
        hope_mushroom = GNSBlocks.register("hope_mushroom", p -> new MushroomBlock(GNSFeatures.Configured.BASE_HUGE_HOPE_MUSHROOM.getKey(), p), () -> GNSBlocks.rawCopy(Blocks.RED_MUSHROOM).sound(SoundType.FUNGUS));
        despair_mushroom = GNSBlocks.register("despair_mushroom", p -> new MushroomBlock(GNSFeatures.Configured.BASE_HUGE_DESPAIR_MUSHROOM.getKey(), p), () -> GNSBlocks.rawCopy(Blocks.BROWN_MUSHROOM).sound(SoundType.FUNGUS));
        orange_flower = GNSBlocks.register("orange_flower", p -> new FlowerBlock(MobEffects.ABSORPTION, 10.0f, p), GNSBlocks.copy(Blocks.POPPY));
        cyan_flower = GNSBlocks.register("cyan_flower", p -> new FlowerBlock(MobEffects.LUCK, 20.0f, p), GNSBlocks.copy(Blocks.POPPY));
        lollipop_bush = GNSBlocks.register("lollipop_bush", BushBlock::new, GNSBlocks.copy(Blocks.POPPY));
        dead_flower = GNSBlocks.register("dead_flower", p -> new FlowerBlock(MobEffects.WEAKNESS, 5.0f, p), GNSBlocks.copy(Blocks.POPPY));
        rainbow_berries = GNSBlocks.registerBlock("rainbow_berries", RainbowBerriesBlock::new, GNSBlocks.copy(Blocks.BEETROOTS));
        dream_door = BlockReg.door("dream_door", GNSBlockSets.DREAM);
        white_door = BlockReg.door("white_door", GNSBlockSets.WHITE);
        dead_door = BlockReg.door("dead_door", GNSBlockSets.DEAD);
        blood_door = BlockReg.door("blood_door", GNSBlockSets.BLOOD);
        dream_trapdoor = BlockReg.trapdoor("dream_trapdoor", GNSBlockSets.DREAM);
        white_trapdoor = BlockReg.trapdoor("white_trapdoor", GNSBlockSets.WHITE);
        dead_trapdoor = BlockReg.trapdoor("dead_trapdoor", GNSBlockSets.DEAD);
        blood_trapdoor = BlockReg.trapdoor("blood_trapdoor", GNSBlockSets.BLOOD);
        dream_fence = BlockReg.fence("dream_fence");
        white_fence = BlockReg.fence("white_fence");
        dead_fence = BlockReg.fence("dead_fence");
        blood_fence = BlockReg.fence("blood_fence");
        delusion_cobblestone_wall = GNSBlocks.register("delusion_cobblestone_wall", WallBlock::new, GNSBlocks.copy(Blocks.COBBLESTONE_WALL));
        delusion_stone_brick_wall = GNSBlocks.register("delusion_stone_brick_wall", WallBlock::new, GNSBlocks.copy(Blocks.STONE_BRICK_WALL));
        dream_fence_gate = BlockReg.gate("dream_fence_gate", GNSWoodTypes.DREAM);
        white_fence_gate = BlockReg.gate("white_fence_gate", GNSWoodTypes.WHITE);
        dead_fence_gate = BlockReg.gate("dead_fence_gate", GNSWoodTypes.DEAD);
        blood_fence_gate = BlockReg.gate("blood_fence_gate", GNSWoodTypes.BLOOD);
        dream_button = BlockReg.woodenButton("dream_button", GNSBlockSets.DREAM);
        white_button = BlockReg.woodenButton("white_button", GNSBlockSets.WHITE);
        dead_button = BlockReg.woodenButton("dead_button", GNSBlockSets.DEAD);
        blood_button = BlockReg.woodenButton("blood_button", GNSBlockSets.BLOOD);
        delusion_button = BlockReg.stoneButton("delusion_button", GNSBlockSets.DELUSION_STONE);
        dream_pressure_plate = BlockReg.woodenPressurePlate("dream_pressure_plate", GNSBlockSets.DREAM);
        white_pressure_plate = BlockReg.woodenPressurePlate("white_pressure_plate", GNSBlockSets.WHITE);
        dead_pressure_plate = BlockReg.woodenPressurePlate("dead_pressure_plate", GNSBlockSets.DEAD);
        blood_pressure_plate = BlockReg.woodenPressurePlate("blood_pressure_plate", GNSBlockSets.BLOOD);
        delusion_pressure_plate = BlockReg.stonePressurePlate("delusion_pressure_plate", GNSBlockSets.DELUSION_STONE);
        dream_stairs = BlockReg.stairs("dream_stairs", dream_planks);
        white_stairs = BlockReg.stairs("white_stairs", white_planks);
        dead_stairs = BlockReg.stairs("dead_stairs", dead_planks);
        blood_stairs = BlockReg.stairs("blood_stairs", blood_planks);
        delusion_stone_stairs = BlockReg.stairs("delusion_stone_stairs", delusion_stone);
        delusion_cobblestone_stairs = BlockReg.stairs("delusion_cobblestone_stairs", delusion_cobblestone);
        delusion_stone_brick_stairs = BlockReg.stairs("delusion_stone_brick_stairs", delusion_stone_bricks);
        dream_slab = BlockReg.slab("dream_slab", dream_planks);
        white_slab = BlockReg.slab("white_slab", white_planks);
        dead_slab = BlockReg.slab("dead_slab", dead_planks);
        blood_slab = BlockReg.slab("blood_slab", blood_planks);
        delusion_stone_slab = BlockReg.slab("delusion_stone_slab", delusion_stone);
        delusion_cobblestone_slab = BlockReg.slab("delusion_cobblestone_slab", delusion_cobblestone);
        delusion_stone_brick_slab = BlockReg.slab("delusion_stone_brick_slab", delusion_stone_bricks);
        raw_spectrite_block = GNSBlocks.register("raw_spectrite_block", Block::new, () -> GNSBlocks.rawCopy(Blocks.RAW_IRON_BLOCK).lightLevel(state -> 6));
        raw_zitrite_block = GNSBlocks.register("raw_zitrite_block", Block::new, GNSBlocks.copy(Blocks.RAW_IRON_BLOCK));
        hard_candy_block = GNSBlocks.register("hard_candy_block", Block::new, GNSBlocks.copy(Blocks.COAL_BLOCK));
        spectrite_block = GNSBlocks.register("spectrite_block", Block::new, () -> GNSBlocks.rawCopy(Blocks.IRON_BLOCK).lightLevel(state -> 15));
        positite_block = GNSBlocks.register("positite_block", Block::new, GNSBlocks.copy(Blocks.DIAMOND_BLOCK));
        necrum_block = GNSBlocks.register("necrum_block", Block::new, () -> GNSBlocks.rawCopy(Blocks.COARSE_DIRT).sound(SoundType.GRAVEL));
        zitrite_block = GNSBlocks.register("zitrite_block", Block::new, GNSBlocks.copy(Blocks.IRON_BLOCK));
        negatite_block = GNSBlocks.register("negatite_block", Block::new, GNSBlocks.copy(Blocks.DIAMOND_BLOCK));
        present = GNSBlocks.register("present", Block::new, GNSBlocks.copy(Blocks.RED_WOOL));
        pot_of_gold = GNSBlocks.register("pot_of_gold", PotOfGoldBlock::new, GNSBlocks.copy(Blocks.CAULDRON));
        rainbow = GNSBlocks.registerBlock("rainbow", RainbowBlock::new, () -> GNSBlocks.rawCopy(Blocks.NETHER_PORTAL).sound(SoundType.AMETHYST).emissiveRendering((state, level, pos) -> true));
        potted_dream_sapling = BlockReg.flowerPot("potted_dream_sapling", () -> dream_sapling);
        potted_candy_sapling = BlockReg.flowerPot("potted_candy_sapling", () -> candy_sapling);
        potted_hope_mushroom = BlockReg.flowerPot("potted_hope_mushroom", () -> hope_mushroom);
        potted_despair_mushroom = BlockReg.flowerPot("potted_despair_mushroom", () -> despair_mushroom);
        potted_orange_flower = BlockReg.flowerPot("potted_orange_flower", () -> orange_flower);
        potted_cyan_flower = BlockReg.flowerPot("potted_cyan_flower", () -> cyan_flower);
        potted_dead_flower = BlockReg.flowerPot("potted_dead_flower", () -> dead_flower);
        potted_lollipop_bush = BlockReg.flowerPot("potted_lollipop_bush", () -> lollipop_bush);
        potted_prickly_nightmare_grass = BlockReg.flowerPot("potted_prickly_nightmare_grass", () -> prickly_nightmare_grass);
    }

    private static Supplier<BlockBehaviour.Properties> copy(Block from) {
        return () -> GNSBlocks.rawCopy(from);
    }

    private static BlockBehaviour.Properties rawCopy(Block from) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)from);
    }

    public static Block register(String key, Function<BlockBehaviour.Properties, Block> blockFunc, Supplier<BlockBehaviour.Properties> newProps) {
        Block block = GNSBlocks.registerBlock(key, blockFunc, newProps);
        blockItemList.put(key, block);
        return block;
    }

    public static Block registerBlock(String name, Function<BlockBehaviour.Properties, Block> blockFunc, Supplier<BlockBehaviour.Properties> newProps) {
        if (registryEvent != null) {
            BlockBehaviour.Properties props = newProps.get().setId(GNSBlocks.key(name));
            Block block = blockFunc.apply(props);
            registryEvent.register(Registries.BLOCK, GoodNightSleep.locate(name), () -> block);
            return block;
        }
        return Blocks.STONE;
    }

    private static ResourceKey<Block> key(String path) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)GoodNightSleep.locate(path));
    }

    static {
        blockItemList = new HashMap<String, Block>();
        DREAM_GROWER = Lazy.of(() -> new TreeGrower("dream", 0.02f, Optional.empty(), Optional.empty(), Optional.of(GNSFeatures.Configured.BASE_DREAM_TREE.getKey()), Optional.of(GNSFeatures.Configured.BASE_DIAMOND_TREE.getKey()), Optional.empty(), Optional.empty()));
        CANDY_GROWER = Lazy.of(() -> new TreeGrower("candy", 0.3f, Optional.empty(), Optional.empty(), Optional.of(GNSFeatures.Configured.BASE_CANDY_TREE.getKey()), Optional.of(GNSFeatures.Configured.BASE_LARGE_CANDY_TREE.getKey()), Optional.empty(), Optional.empty()));
    }
}

