/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.registry;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.mixin.NoiseRouterDataInvoker;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.util.DimensionHolder;
import com.legacy.good_nights_sleep.world.GNSSurfaceRuleData;
import com.legacy.good_nights_sleep.world.chunkgen.DreamChunkGenerator;
import com.legacy.good_nights_sleep.world.chunkgen.NightmareChunkGenerator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class GNSDimensions {
    public static final ResourceLocation DREAM_ID = GoodNightSleep.locate("dream");
    public static final ResourceLocation NIGHTMARE_ID = GoodNightSleep.locate("nightmare");
    public static final DimensionHolder DREAM = GNSDimensions.createDream();
    public static final DimensionHolder NIGHTMARE = GNSDimensions.createNightmare();

    public static void init() {
    }

    private static DimensionHolder createDream() {
        Function<BootstrapContext<?>, DimensionType> dimType = c -> GNSDimensions.dimType(OptionalLong.of(6000L), 0, DREAM_ID, false, 0);
        Function<BootstrapContext<?>, NoiseGeneratorSettings> noiseSettings = c -> GNSDimensions.newDimensionSettings(GNSDimensions.dummyNoise(), GNSBlocks.delusion_stone.defaultBlockState(), Blocks.WATER.defaultBlockState(), NoiseRouterDataInvoker.overworld((HolderGetter<DensityFunction>)c.lookup(Registries.DENSITY_FUNCTION), (HolderGetter<NormalNoise.NoiseParameters>)c.lookup(Registries.NOISE), false, false), GNSSurfaceRuleData.basicData(false, true, false), 0, false);
        Function<BootstrapContext<?>, ChunkGenerator> chunkGen = c -> new DreamChunkGenerator((HolderGetter<Biome>)c.lookup(Registries.BIOME), (HolderGetter<NoiseGeneratorSettings>)c.lookup(Registries.NOISE_SETTINGS));
        return new DimensionHolder(DREAM_ID, dimType, noiseSettings, chunkGen);
    }

    private static DimensionHolder createNightmare() {
        Function<BootstrapContext<?>, DimensionType> dimType = c -> GNSDimensions.dimType(OptionalLong.of(18000L), 0, NIGHTMARE_ID, false, 7);
        Function<BootstrapContext<?>, NoiseGeneratorSettings> noiseSettings = c -> GNSDimensions.newDimensionSettings(GNSDimensions.dummyNoise(), Blocks.STONE.defaultBlockState(), Blocks.LAVA.defaultBlockState(), NoiseRouterDataInvoker.overworld((HolderGetter<DensityFunction>)c.lookup(Registries.DENSITY_FUNCTION), (HolderGetter<NormalNoise.NoiseParameters>)c.lookup(Registries.NOISE), false, false), GNSSurfaceRuleData.basicData(false, true, true), 0, false);
        Function<BootstrapContext<?>, ChunkGenerator> chunkGen = c -> new NightmareChunkGenerator((HolderGetter<Biome>)c.lookup(Registries.BIOME), (HolderGetter<NoiseGeneratorSettings>)c.lookup(Registries.NOISE_SETTINGS));
        return new DimensionHolder(NIGHTMARE_ID, dimType, noiseSettings, chunkGen);
    }

    private static NoiseSettings dummyNoise() {
        return NoiseSettings.create((int)0, (int)256, (int)1, (int)2);
    }

    public static NoiseGeneratorSettings newDimensionSettings(NoiseSettings noise, BlockState defaultBlock, BlockState defaultFluid, NoiseRouter noiseRouter, SurfaceRules.RuleSource surfaceRule, int seaLevel, boolean useLegacyRandomSource) {
        return new NoiseGeneratorSettings(noise, defaultBlock, defaultFluid, noiseRouter, surfaceRule, List.of(), seaLevel, false, false, false, useLegacyRandomSource);
    }

    public static ResourceKey<Level> dreamKey() {
        return DREAM.getLevelKey();
    }

    public static ResourceKey<Level> nightmareKey() {
        return NIGHTMARE.getLevelKey();
    }

    public static boolean inSleepDimension(@Nullable Entity entity) {
        return entity != null && GNSDimensions.inSleepDimension((ResourceKey<Level>)entity.level().dimension());
    }

    public static boolean inSleepDimension(ResourceKey<Level> levelKey) {
        return levelKey.equals(GNSDimensions.dreamKey()) || levelKey.equals(GNSDimensions.nightmareKey());
    }

    public static boolean hasDreamEffects(ResourceLocation effects) {
        return effects.equals((Object)DREAM_ID) || effects.equals((Object)NIGHTMARE_ID);
    }

    public static DimensionType dimType(OptionalLong fixedTime, int minY, ResourceLocation effects, boolean bedWorks, int monsterSpawnBlockLightLimit) {
        boolean hasSkyLight = true;
        boolean hasCeiling = false;
        boolean ultrawarm = false;
        boolean natural = true;
        double coordinateScale = 1.0;
        boolean respawnAnchorWorks = false;
        int height = 384;
        int logicalHeight = 384;
        TagKey infiniburn = BlockTags.INFINIBURN_OVERWORLD;
        float ambientLight = 0.0f;
        boolean piglinSafe = false;
        boolean hasRaids = true;
        UniformInt monsterSpawnLightTest = UniformInt.of((int)0, (int)7);
        return new DimensionType(fixedTime, hasSkyLight, hasCeiling, ultrawarm, natural, coordinateScale, bedWorks, respawnAnchorWorks, minY, height, logicalHeight, infiniburn, effects, ambientLight, Optional.of(192), new DimensionType.MonsterSettings(piglinSafe, hasRaids, (IntProvider)monsterSpawnLightTest, monsterSpawnBlockLightLimit));
    }

    public static void bootstrapDimType(BootstrapContext<DimensionType> bootstrap) {
        bootstrap.register(DREAM.getType().getKey(), (Object)DREAM.getType().getInstance().apply(bootstrap));
        bootstrap.register(NIGHTMARE.getType().getKey(), (Object)NIGHTMARE.getType().getInstance().apply(bootstrap));
    }

    public static void bootstrapNoiseSettings(BootstrapContext<NoiseGeneratorSettings> bootstrap) {
        bootstrap.register(DREAM.getNoiseSettings().getKey(), (Object)DREAM.getNoiseSettings().getInstance().apply(bootstrap));
        bootstrap.register(NIGHTMARE.getNoiseSettings().getKey(), (Object)NIGHTMARE.getNoiseSettings().getInstance().apply(bootstrap));
    }

    public static void bootstrapLevelStem(BootstrapContext<LevelStem> bootstrap) {
        bootstrap.register(DREAM.getLevelStem().getKey(), (Object)DREAM.getLevelStem().getInstance().apply(bootstrap));
        bootstrap.register(NIGHTMARE.getLevelStem().getKey(), (Object)NIGHTMARE.getLevelStem().getInstance().apply(bootstrap));
    }
}

