/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.registry;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.entity.HerobrineEntity;
import com.legacy.good_nights_sleep.entity.TormenterEntity;
import com.legacy.good_nights_sleep.entity.dream.BabyCreeperEntity;
import com.legacy.good_nights_sleep.entity.dream.UnicornEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

public class GNSEntityTypes {
    public static final EntityType<UnicornEntity> UNICORN = GNSEntityTypes.buildEntity("unicorn", EntityType.Builder.of(UnicornEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.3964844f, 1.6f));
    public static final EntityType<BabyCreeperEntity> BABY_CREEPER = GNSEntityTypes.buildEntity("baby_creeper", EntityType.Builder.of(BabyCreeperEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.3f));
    public static final EntityType<TormenterEntity> TORMENTER = GNSEntityTypes.buildEntity("tormenter", EntityType.Builder.of(TormenterEntity::new, (MobCategory)MobCategory.MONSTER));
    public static final EntityType<HerobrineEntity> HEROBRINE = GNSEntityTypes.buildEntity("herobrine", EntityType.Builder.of(HerobrineEntity::new, (MobCategory)MobCategory.MONSTER).eyeHeight(1.75f));
    private static RegisterEvent registerEvent;

    public static void init(RegisterEvent event) {
        registerEvent = event;
        GNSEntityTypes.register("unicorn", UNICORN);
        GNSEntityTypes.register("baby_creeper", BABY_CREEPER);
        GNSEntityTypes.register("tormenter", TORMENTER);
        GNSEntityTypes.register("herobrine", HEROBRINE);
    }

    private static void register(String name, EntityType<?> type) {
        if (registerEvent == null) {
            return;
        }
        registerEvent.register(Registries.ENTITY_TYPE, GoodNightSleep.locate(name), () -> type);
    }

    public static void onAttributesRegistered(EntityAttributeCreationEvent event) {
        event.put(UNICORN, UnicornEntity.createBaseHorseAttributes().build());
        event.put(BABY_CREEPER, Creeper.createAttributes().build());
        event.put(TORMENTER, TormenterEntity.registerAttributes().build());
        event.put(HEROBRINE, HerobrineEntity.registerAttributes().build());
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)GoodNightSleep.locate(key)));
    }

    public static void registerPlacements(RegisterSpawnPlacementsEvent event) {
        event.register(TORMENTER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(HEROBRINE, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(BABY_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(UNICORN, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static void registerPlacementOverrides(RegisterSpawnPlacementsEvent event) {
    }
}

