/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.registry;

import com.legacy.good_nights_sleep.GoodNightSleep;
import com.legacy.good_nights_sleep.data.GNSBiomeProv;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import com.legacy.good_nights_sleep.util.Pointer;
import com.legacy.good_nights_sleep.world.dream.features.DreamSpongeFeature;
import com.legacy.good_nights_sleep.world.dream.features.FatHopeMushroomFeature;
import com.legacy.good_nights_sleep.world.dream.features.TallHopeMushroomFeature;
import com.legacy.good_nights_sleep.world.general_features.DreamScatteredPlantFeature;
import com.legacy.good_nights_sleep.world.nightmare.features.NetherSplashFeature;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;

public class GNSFeatures {
    public static final Feature<HugeMushroomFeatureConfiguration> TALL_HOPE_MUSHROOM = new TallHopeMushroomFeature((Codec<HugeMushroomFeatureConfiguration>)HugeMushroomFeatureConfiguration.CODEC);
    public static final Feature<HugeMushroomFeatureConfiguration> FAT_HOPE_MUSHROOM = new FatHopeMushroomFeature((Codec<HugeMushroomFeatureConfiguration>)HugeMushroomFeatureConfiguration.CODEC);
    public static final Feature<NoneFeatureConfiguration> SPONGE_GROWTH = new DreamSpongeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC);
    public static final Feature<NoneFeatureConfiguration> SCATTERED_PRESENTS = new DreamScatteredPlantFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, (Lazy<BlockState>)Lazy.of(() -> GNSBlocks.present.defaultBlockState()));
    public static final Feature<NoneFeatureConfiguration> NETHER_SPLASH = new NetherSplashFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC);
    public static final Feature<NoneFeatureConfiguration> SCATTERED_PUMPKINS = new DreamScatteredPlantFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, (Lazy<BlockState>)Lazy.of(() -> Blocks.PUMPKIN.defaultBlockState()));
    public static RegisterEvent registerEvent;

    public static void init(RegisterEvent event) {
        registerEvent = event;
        GNSFeatures.register("sponge_growth", SPONGE_GROWTH);
        GNSFeatures.register("scattered_presents", SCATTERED_PRESENTS);
        GNSFeatures.register("nether_splash", NETHER_SPLASH);
        GNSFeatures.register("scattered_pumpkins", SCATTERED_PUMPKINS);
        Configured.init();
    }

    private static void register(String key, Feature<?> feature) {
        registerEvent.register(Registries.FEATURE, GoodNightSleep.locate(key), () -> feature);
    }

    public static void addDreamOres(GNSBiomeProv.RegistrarBuilder biomeIn) {
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.DREAM_DIRT_BLOB);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.DREAM_COAL_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.DREAM_CANDY_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.DREAM_SPECTRITE_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.DREAM_POSITITE_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.DREAM_LAPIS_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.DREAM_GLOWSTONE_BLOB);
    }

    public static void addDreamTrees(GNSBiomeProv.RegistrarBuilder biomeIn) {
        biomeIn.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.HILLS_DREAM_TREE);
        biomeIn.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.HILLS_CANDY_TREE);
        biomeIn.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.HILLS_DIAMOND_TREE);
    }

    public static void addScatteredDreamFeatures(GNSBiomeProv.RegistrarBuilder biomeIn) {
        GNSFeatures.addDreamSponges(biomeIn);
        biomeIn.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.SCATTERED_PRESENTS);
    }

    public static void addDreamSponges(GNSBiomeProv.RegistrarBuilder biomeIn) {
        biomeIn.addFeature(GenerationStep.Decoration.RAW_GENERATION, Placements.SPONGE_GROWTH);
    }

    public static void addHugeHopeMushrooms(GNSBiomeProv.RegistrarBuilder biomeIn) {
        biomeIn.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.HUGE_HOPE_MUSHROOM);
    }

    public static void addHopeMushroomFields(GNSBiomeProv.RegistrarBuilder biomeIn) {
    }

    public static void addNightmareOres(GNSBiomeProv.RegistrarBuilder biomeIn) {
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.NIGHTMARE_DIRT_BLOB);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.NIGHTMARE_GRAVEL_BLOB);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.NIGHTMARE_COAL_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.NIGHTMARE_NECRUM_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.NIGHTMARE_ZITRITE_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.NIGHTMARE_IRON_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.NIGHTMARE_NEGATITE_ORE);
        biomeIn.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, Placements.NIGHTMARE_LAPIS_ORE);
    }

    public static void addScatteredNightmareFeatures(GNSBiomeProv.RegistrarBuilder biomeIn) {
        biomeIn.addFeature(GenerationStep.Decoration.RAW_GENERATION, Placements.NETHER_SPLASH);
        biomeIn.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, Placements.SCATTERED_PUMPKINS);
    }

    public static void addCarvers(GNSBiomeProv.RegistrarBuilder biomeIn) {
        biomeIn.addCarver(Carvers.CAVE);
        biomeIn.addCarver(Carvers.CAVE_EXTRA_UNDERGROUND);
        biomeIn.addCarver(Carvers.CANYON);
    }

    public static class Configured {
        private static final Map<ResourceLocation, Pointer<ConfiguredFeature<?, ?>>> POINTERS = new HashMap();
        public static final TreeConfiguration DUMMY_CONFIG = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.OAK_LOG.defaultBlockState()), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.OAK_LEAVES.defaultBlockState()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build();
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_DREAM_TREE = Configured.createBasicTree("dream_tree", GNSBlocks.dream_log.defaultBlockState(), GNSBlocks.dream_leaves.defaultBlockState(), 4, 1);
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_CANDY_TREE = Configured.createBasicTree("candy_tree", GNSBlocks.white_log.defaultBlockState(), GNSBlocks.candy_leaves.defaultBlockState(), 5);
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_LARGE_CANDY_TREE = Configured.register("large_candy_tree", Feature.TREE, () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)GNSBlocks.white_log.defaultBlockState()), (TrunkPlacer)new StraightTrunkPlacer(7, 3, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)GNSBlocks.candy_leaves.defaultBlockState()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).ignoreVines().build());
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_DIAMOND_TREE = Configured.register("diamond_tree", Feature.TREE, () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)GNSBlocks.dream_log.defaultBlockState()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)GNSBlocks.diamond_leaves.defaultBlockState()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).ignoreVines().build());
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_DEAD_TREE = Configured.createBasicTree("dead_tree", GNSBlocks.dead_log.defaultBlockState(), Blocks.AIR.defaultBlockState(), 5);
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_BLOOD_TREE = Configured.createBasicTree("blood_tree", GNSBlocks.blood_log.defaultBlockState(), Blocks.AIR.defaultBlockState(), 5);
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_LARGE_DEAD_TREE = Configured.register("large_deaf_tree", Feature.TREE, () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)GNSBlocks.dead_log.defaultBlockState()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.AIR.defaultBlockState()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).ignoreVines().build());
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_LARGE_BLOOD_TREE = Configured.register("large_blood_tree", Feature.TREE, () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)GNSBlocks.blood_log.defaultBlockState()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.AIR.defaultBlockState()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(8))).ignoreVines().build());
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_HUGE_HOPE_MUSHROOM = Configured.register("huge_hope_mushroom", Feature.HUGE_RED_MUSHROOM, () -> new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)GNSBlocks.hope_mushroom_block.defaultBlockState().setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)Blocks.MUSHROOM_STEM.defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)))), 2));
        public static final Pointer<ConfiguredFeature<?, ?>> BASE_HUGE_DESPAIR_MUSHROOM = Configured.register("huge_despair_mushroom", Feature.HUGE_BROWN_MUSHROOM, () -> new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)GNSBlocks.despair_mushroom_block.defaultBlockState().setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)Blocks.MUSHROOM_STEM.defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)))), 3));
        private static final Supplier<BlockMatchTest> DELUSION_RULE_TEST = () -> new BlockMatchTest(GNSBlocks.delusion_stone);
        private static final Supplier<TagMatchTest> STONE_RULE_TEST = () -> new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        public static final Pointer<ConfiguredFeature<?, ?>> DREAM_DIRT_BLOB = Configured.register("dream_dirt_blob", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)DELUSION_RULE_TEST.get()), (BlockState)GNSBlocks.dream_dirt.defaultBlockState())), 33));
        public static final Pointer<ConfiguredFeature<?, ?>> DREAM_CANDY_ORE = Configured.register("dream_candy_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)DELUSION_RULE_TEST.get()), (BlockState)GNSBlocks.candy_ore.defaultBlockState())), 15));
        public static final Pointer<ConfiguredFeature<?, ?>> DREAM_SPECTRITE_ORE = Configured.register("dream_spectrite_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)DELUSION_RULE_TEST.get()), (BlockState)GNSBlocks.spectrite_ore.defaultBlockState())), 9));
        public static final Pointer<ConfiguredFeature<?, ?>> DREAM_POSITITE_ORE = Configured.register("dream_positite_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)DELUSION_RULE_TEST.get()), (BlockState)GNSBlocks.positite_ore.defaultBlockState())), 8));
        public static final Pointer<ConfiguredFeature<?, ?>> DREAM_COAL_ORE = Configured.register("dream_coal_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)DELUSION_RULE_TEST.get()), (BlockState)GNSBlocks.delusion_coal_ore.defaultBlockState())), 17));
        public static final Pointer<ConfiguredFeature<?, ?>> DREAM_LAPIS_ORE = Configured.register("dream_lapis_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)DELUSION_RULE_TEST.get()), (BlockState)GNSBlocks.delusion_lapis_ore.defaultBlockState())), 7));
        public static final Pointer<ConfiguredFeature<?, ?>> DREAM_GLOWSTONE_BLOB = Configured.register("dream_glowstone_blob", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)DELUSION_RULE_TEST.get()), (BlockState)Blocks.GLOWSTONE.defaultBlockState())), 8));
        public static final Pointer<ConfiguredFeature<?, ?>> SCATTERED_PRESENTS = Configured.register("scattered_presents", SCATTERED_PRESENTS, () -> FeatureConfiguration.NONE);
        public static final Pointer<ConfiguredFeature<?, ?>> SPONGE_GROWTH = Configured.register("sponge_growth", SPONGE_GROWTH, () -> FeatureConfiguration.NONE);
        public static final Pointer<ConfiguredFeature<?, ?>> SCATTERED_PUMPKINS = Configured.register("scattered_pumpkins", SCATTERED_PUMPKINS, () -> FeatureConfiguration.NONE);
        public static final Pointer<ConfiguredFeature<?, ?>> NETHER_SPLASH = Configured.register("nether_splash", NETHER_SPLASH, () -> FeatureConfiguration.NONE);
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_DIRT_BLOB = Configured.register("nightmare_dirt_blob", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)STONE_RULE_TEST.get()), (BlockState)Blocks.DIRT.defaultBlockState())), 33));
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_GRAVEL_BLOB = Configured.register("nightmare_gravel_blob", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)STONE_RULE_TEST.get()), (BlockState)Blocks.GRAVEL.defaultBlockState())), 33));
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_NECRUM_ORE = Configured.register("nightmare_necrum_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)STONE_RULE_TEST.get()), (BlockState)GNSBlocks.fossilized_necrum.defaultBlockState())), 15));
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_ZITRITE_ORE = Configured.register("nightmare_zitrite_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)STONE_RULE_TEST.get()), (BlockState)GNSBlocks.zitrite_ore.defaultBlockState())), 8));
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_NEGATITE_ORE = Configured.register("nightmare_negatite_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)STONE_RULE_TEST.get()), (BlockState)GNSBlocks.negatite_ore.defaultBlockState())), 7));
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_COAL_ORE = Configured.register("nightmare_coal_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)STONE_RULE_TEST.get()), (BlockState)Blocks.COAL_ORE.defaultBlockState())), 17));
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_LAPIS_ORE = Configured.register("nightmare_lapis_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)STONE_RULE_TEST.get()), (BlockState)Blocks.LAPIS_ORE.defaultBlockState())), 7));
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_IRON_ORE = Configured.register("nightmare_iron_ore", Feature.ORE, () -> new OreConfiguration(List.of(OreConfiguration.target((RuleTest)((RuleTest)STONE_RULE_TEST.get()), (BlockState)Blocks.IRON_ORE.defaultBlockState())), 9));
        public static final Pointer<ConfiguredFeature<?, ?>> DREAM_GRASS_PATCH = Configured.register("dream_grass_patch", Feature.RANDOM_PATCH, () -> Configs.DREAM_GRASS);
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_GRASS_PATCH = Configured.register("nightmare_grass_patch", Feature.RANDOM_PATCH, () -> Configs.NIGHTMARE_GRASS);
        public static final Pointer<ConfiguredFeature<?, ?>> PRICKLY_NIGHTMARE_GRASS_PATCH = Configured.register("prickly_nightmare_grass_patch", Feature.RANDOM_PATCH, () -> Configs.PRICKLY_NIGHTMARE_GRASS);
        public static final Pointer<ConfiguredFeature<?, ?>> DREAM_FLOWER_PATCH = Configured.register("dream_flower_patch", Feature.RANDOM_PATCH, () -> Configs.DREAM_FLOWERS);
        public static final Pointer<ConfiguredFeature<?, ?>> NIGHTMARE_FLOWER_PATCH = Configured.register("nightmare_flower_patch", Feature.RANDOM_PATCH, () -> Configs.NIGHTMARE_FLOWERS);
        public static final Pointer<ConfiguredFeature<?, ?>> LOLLIPOP_BUSH_PATCH = Configured.register("lollipop_bush_patch", Feature.RANDOM_PATCH, () -> Configs.LOLLIPOP_BUSHES);
        public static final Pointer<ConfiguredFeature<?, ?>> HOPE_MUSHROOM_PATCH = Configured.register("hope_mushroom_patch", Feature.RANDOM_PATCH, () -> Configs.HOPE_MUSHROOMS);
        public static final Pointer<ConfiguredFeature<?, ?>> DESPAIR_MUSHROOM_PATCH = Configured.register("despair_mushroom_patch", Feature.RANDOM_PATCH, () -> Configs.DESPAIR_MUSHROOMS);

        public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> bootstrap) {
            POINTERS.forEach((key, pointer) -> {
                System.out.println("Registering " + pointer.getKey().toString());
                bootstrap.register(pointer.getKey(), (Object)((ConfiguredFeature)pointer.getInstance().apply(bootstrap)));
            });
        }

        public static void init() {
        }

        public static void initCarvers() {
        }

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> Pointer<ConfiguredFeature<?, ?>> register(String key, F feature, Supplier<FC> config) {
            Pointer pointer = new Pointer(Registries.CONFIGURED_FEATURE, key, () -> new ConfiguredFeature(feature, (FeatureConfiguration)config.get()));
            if (DatagenModLoader.isRunningDataGen()) {
                POINTERS.put(GoodNightSleep.locate(key), pointer);
            }
            return pointer;
        }

        public static Pointer<ConfiguredFeature<?, ?>> createBasicTree(String key, BlockState log, BlockState leaves, int height) {
            return Configured.createBasicTree(key, log, leaves, height, 2);
        }

        public static Pointer<ConfiguredFeature<?, ?>> createBasicTree(String key, BlockState log, BlockState leaves, int height, int randHeight) {
            return Configured.register(key, Feature.TREE, () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)log), (TrunkPlacer)new StraightTrunkPlacer(height, randHeight, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)leaves), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build());
        }

        protected static class Configs {
            public static final RandomPatchConfiguration DREAM_GRASS = Configs.simplePatch("dream_grass", GNSBlocks.short_dream_grass.defaultBlockState(), 32);
            public static final RandomPatchConfiguration NIGHTMARE_GRASS = Configs.simplePatch("nightmare_grass", GNSBlocks.short_nightmare_grass.defaultBlockState(), 32);
            public static final RandomPatchConfiguration DREAM_FLOWERS = Configs.weightedPatch("dream_flowers", (WeightedList.Builder<BlockState>)Configs.weighted().add((Object)GNSBlocks.cyan_flower.defaultBlockState(), 1).add((Object)GNSBlocks.orange_flower.defaultBlockState(), 1).add((Object)GNSBlocks.lollipop_bush.defaultBlockState(), 2), 64);
            public static final RandomPatchConfiguration LOLLIPOP_BUSHES = Configs.simplePatch("lollipop_bushes", GNSBlocks.lollipop_bush.defaultBlockState(), 32);
            public static final RandomPatchConfiguration PRICKLY_NIGHTMARE_GRASS = Configs.simplePatch("prickly_nightmare_grass", GNSBlocks.prickly_nightmare_grass.defaultBlockState(), 32);
            public static final RandomPatchConfiguration NIGHTMARE_FLOWERS = Configs.simplePatch("nightmare_flowers", GNSBlocks.dead_flower.defaultBlockState(), 64);
            public static final RandomPatchConfiguration HOPE_MUSHROOMS = Configs.simplePatch("hope_mushrooms", GNSBlocks.hope_mushroom.defaultBlockState(), 64);
            public static final RandomPatchConfiguration DESPAIR_MUSHROOMS = Configs.simplePatch("despair_mushrooms", GNSBlocks.despair_mushroom.defaultBlockState(), 64);

            protected Configs() {
            }

            public static RandomPatchConfiguration simplePatch(String name, BlockState state, int tries) {
                return Configs.simplePatch(name, state, tries, p -> PlacementUtils.onlyWhenEmpty((Feature)((Feature)p.getLeft()), (FeatureConfiguration)((FeatureConfiguration)p.getRight())));
            }

            public static RandomPatchConfiguration filteredPatch(String name, BlockState state, int tries, Block notBlock) {
                return Configs.simplePatch(name, state, tries, p -> PlacementUtils.filtered((Feature)((Feature)p.getLeft()), (FeatureConfiguration)((FeatureConfiguration)p.getRight()), (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.AIR}), (BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)BlockPos.ZERO.below(), (Block[])new Block[]{notBlock})))));
            }

            public static <FC extends FeatureConfiguration, F extends Feature<FC>> RandomPatchConfiguration simplePatch(String name, BlockState state, int tries, Function<Pair<F, FC>, Holder<PlacedFeature>> cons) {
                return Configs.randomPatchConfig(name, tries, cons.apply(Pair.of((Object)Feature.SIMPLE_BLOCK, (Object)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)state)))));
            }

            public static RandomPatchConfiguration weightedPatch(String name, WeightedList.Builder<BlockState> builder, int tries) {
                return Configs.weightedPatch(name, builder, tries, p -> PlacementUtils.onlyWhenEmpty((Feature)((Feature)p.getLeft()), (FeatureConfiguration)((FeatureConfiguration)p.getRight())));
            }

            public static <FC extends FeatureConfiguration, F extends Feature<FC>> RandomPatchConfiguration weightedPatch(String name, WeightedList.Builder<BlockState> builder, int tries, Function<Pair<F, FC>, Holder<PlacedFeature>> cons) {
                return Configs.randomPatchConfig(name, tries, cons.apply(Pair.of((Object)Feature.SIMPLE_BLOCK, (Object)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder)))));
            }

            public static <FC extends FeatureConfiguration, F extends Feature<FC>> RandomPatchConfiguration randomPatchConfig(String name, int tries, Holder<PlacedFeature> placedHolder) {
                return FeatureUtils.simpleRandomPatchConfiguration((int)tries, placedHolder);
            }

            public static WeightedList.Builder<BlockState> weighted() {
                return new WeightedList.Builder();
            }
        }
    }

    public static class Placements {
        private static final Map<ResourceLocation, Pointer<PlacedFeature>> POINTERS = new HashMap<ResourceLocation, Pointer<PlacedFeature>>();
        public static final Pointer<PlacedFeature> HOPE_MUSHROOM_PATCH = Placements.register("hope_mushroom_patch", Configured.HOPE_MUSHROOM_PATCH, Placements.flower(8, true));
        public static final Pointer<PlacedFeature> DESPAIR_MUSHROOM_PATCH = Placements.register("despair_mushroom_patch", Configured.DESPAIR_MUSHROOM_PATCH, Placements.flower(4, true));
        public static final Pointer<PlacedFeature> NETHER_HOPE_MUSHROOM_PATCH = Placements.register("nether_hope_mushroom_patch", Configured.HOPE_MUSHROOM_PATCH, List.of(RarityFilter.onAverageOnceEvery((int)8), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)127)), BiomeFilter.biome()));
        public static final Pointer<PlacedFeature> NETHER_DESPAIR_MUSHROOM_PATCH = Placements.register("nether_despair_mushroom_patch", Configured.DESPAIR_MUSHROOM_PATCH, List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)127)), BiomeFilter.biome()));
        public static final Pointer<PlacedFeature> HILLS_DREAM_TREE = Placements.register("hills_dream_tree", Configured.BASE_DREAM_TREE, VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)2)), (Block)GNSBlocks.dream_sapling));
        public static final Pointer<PlacedFeature> HILLS_CANDY_TREE = Placements.register("hills_candy_tree", Configured.BASE_CANDY_TREE, VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)1)), (Block)GNSBlocks.candy_sapling));
        public static final Pointer<PlacedFeature> HILLS_DIAMOND_TREE = Placements.register("hills_diamond_tree", Configured.BASE_DIAMOND_TREE, VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)5), (Block)GNSBlocks.dream_sapling));
        public static final Pointer<PlacedFeature> DREAM_DIRT_BLOB = Placements.register("dream_dirt_blob", Configured.DREAM_DIRT_BLOB, Placements.countRange(127, 10));
        public static final Pointer<PlacedFeature> DREAM_CANDY_ORE = Placements.register("dream_candy_ore", Configured.DREAM_CANDY_ORE, Placements.countRange(63, 20));
        public static final Pointer<PlacedFeature> DREAM_SPECTRITE_ORE = Placements.register("dream_spectrite_ore", Configured.DREAM_SPECTRITE_ORE, Placements.countRange(63, 20));
        public static final Pointer<PlacedFeature> DREAM_POSITITE_ORE = Placements.register("dream_positite_ore", Configured.DREAM_POSITITE_ORE, Placements.countRange(15, 2));
        public static final Pointer<PlacedFeature> DREAM_COAL_ORE = Placements.register("dream_coal_ore", Configured.DREAM_COAL_ORE, Placements.countRange(127, 20));
        public static final Pointer<PlacedFeature> DREAM_LAPIS_ORE = Placements.register("dream_lapis_ore", Configured.DREAM_LAPIS_ORE, Placements.countRange(HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)30)), 1));
        public static final Pointer<PlacedFeature> DREAM_GLOWSTONE_BLOB = Placements.register("dream_glowstone_blob", Configured.DREAM_GLOWSTONE_BLOB, Placements.countRange(7, 2));
        public static final Pointer<PlacedFeature> SCATTERED_PRESENTS = Placements.register("scattered_presents", Configured.SCATTERED_PRESENTS, List.of(RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
        public static final Pointer<PlacedFeature> SPONGE_GROWTH = Placements.register("sponge_growth", Configured.SPONGE_GROWTH, List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()));
        public static final Pointer<PlacedFeature> HUGE_HOPE_MUSHROOM = Placements.register("huge_hope_mushroom", Configured.BASE_HUGE_HOPE_MUSHROOM, VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)4), (Block)GNSBlocks.hope_mushroom));
        public static final Pointer<PlacedFeature> NIGHTMARE_DIRT_BLOB = Placements.register("nightmare_dirt_blob", Configured.NIGHTMARE_DIRT_BLOB, Placements.countRange(127, 10));
        public static final Pointer<PlacedFeature> NIGHTMARE_GRAVEL_BLOB = Placements.register("nightmare_gravel_blob", Configured.NIGHTMARE_GRAVEL_BLOB, Placements.countRange(127, 8));
        public static final Pointer<PlacedFeature> NIGHTMARE_NECRUM_ORE = Placements.register("nightmare_necrum_ore", Configured.NIGHTMARE_NECRUM_ORE, Placements.countRange(127, 8));
        public static final Pointer<PlacedFeature> NIGHTMARE_ZITRITE_ORE = Placements.register("nightmare_zitrite_ore", Configured.NIGHTMARE_ZITRITE_ORE, Placements.countRange(15, 25));
        public static final Pointer<PlacedFeature> NIGHTMARE_NEGATITE_ORE = Placements.register("nightmare_negatite_ore", Configured.NIGHTMARE_NEGATITE_ORE, Placements.countRange(15, 1));
        public static final Pointer<PlacedFeature> NIGHTMARE_COAL_ORE = Placements.register("nightmare_coal_ore", Configured.NIGHTMARE_COAL_ORE, Placements.countRange(127, 20));
        public static final Pointer<PlacedFeature> NIGHTMARE_LAPIS_ORE = Placements.register("nightmare_lapis_ore", Configured.NIGHTMARE_LAPIS_ORE, Placements.countRange(HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)30)), 1));
        public static final Pointer<PlacedFeature> NIGHTMARE_IRON_ORE = Placements.register("nightmare_iron_ore", Configured.NIGHTMARE_IRON_ORE, Placements.countRange(63, 20));
        public static final Pointer<PlacedFeature> HILLS_DEAD_TREE = Placements.register("hills_dead_tree", Configured.BASE_LARGE_DEAD_TREE, VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)1)), (Block)Blocks.OAK_SAPLING));
        public static final Pointer<PlacedFeature> HILLS_BLOOD_TREE = Placements.register("hills_blood_tree", Configured.BASE_BLOOD_TREE, VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)3), (Block)Blocks.OAK_SAPLING));
        public static final Pointer<PlacedFeature> NETHER_SPLASH = Placements.register("nether_splash", Configured.NETHER_SPLASH, List.of(RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        public static final Pointer<PlacedFeature> SCATTERED_PUMPKINS = Placements.register("scattered_pumpkins", Configured.SCATTERED_PUMPKINS, List.of(RarityFilter.onAverageOnceEvery((int)35), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
        public static final Pointer<PlacedFeature> HUGE_DESPAIR_MUSHROOM = Placements.register("huge_despair_mushroom", Configured.BASE_HUGE_DESPAIR_MUSHROOM, VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)3), (Block)GNSBlocks.despair_mushroom));
        public static final Pointer<PlacedFeature> PLAINS_DIAMOND_TREE = Placements.register("plains_diamond_tree", Configured.BASE_DIAMOND_TREE, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.1f, (int)1), (Block)GNSBlocks.dream_sapling));
        public static final Pointer<PlacedFeature> PLAINS_HOPE_MUSHROOM = Placements.register("plains_hope_mushroom", Configured.BASE_HUGE_HOPE_MUSHROOM, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.1f, (int)1), (Block)GNSBlocks.hope_mushroom));
        public static final Pointer<PlacedFeature> FOREST_DREAM_TREE = Placements.register("forest_dream_tree", Configured.BASE_DREAM_TREE, VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)5), (Block)GNSBlocks.dream_sapling));
        public static final Pointer<PlacedFeature> FOREST_CANDY_TREE = Placements.register("forest_candy_tree", Configured.BASE_CANDY_TREE, VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)1), (Block)GNSBlocks.candy_sapling));
        public static final Pointer<PlacedFeature> LANDS_CANDY_TREE = Placements.register("lands_candy_tree", Configured.BASE_LARGE_CANDY_TREE, VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)5), (Block)GNSBlocks.candy_sapling));
        public static final Pointer<PlacedFeature> LANDS_DREAM_TREE = Placements.register("lands_dream_tree", Configured.BASE_DREAM_TREE, VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)3), (Block)GNSBlocks.dream_sapling));
        public static final Pointer<PlacedFeature> PLAINS_BLOOD_TREE = Placements.register("plains_blood_tree", Configured.BASE_LARGE_BLOOD_TREE, VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)5), (Block)Blocks.OAK_SAPLING));
        public static final Pointer<PlacedFeature> PLAINS_DESPAIR_MUSHROOM = Placements.register("plains_despair_mushroom", Configured.BASE_HUGE_DESPAIR_MUSHROOM, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.1f, (int)1), (Block)GNSBlocks.despair_mushroom));
        public static final Pointer<PlacedFeature> FOREST_DEAD_TREE = Placements.register("forest_dead_tree", Configured.BASE_DEAD_TREE, VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)5), (Block)Blocks.OAK_SAPLING));
        public static final Pointer<PlacedFeature> FOREST_BLOOD_TREE = Placements.register("forest_blood_tree", Configured.BASE_LARGE_BLOOD_TREE, VegetationPlacements.treePlacement((PlacementModifier)CountPlacement.of((int)1), (Block)Blocks.OAK_SAPLING));
        public static final Pointer<PlacedFeature> DREAM_GRASS_NOISE = Placements.register("dream_grass_noise", Configured.DREAM_GRASS_PATCH, Placements.countNoise(-0.8, 5, 10));
        public static final Pointer<PlacedFeature> NIGHTMARE_GRASS_NOISE = Placements.register("nightmare_grass_noise", Configured.NIGHTMARE_GRASS_PATCH, Placements.countNoise(-0.8, 5, 10));
        public static final Pointer<PlacedFeature> DREAM_FLOWERS_3 = Placements.register("dream_flowers_3", Configured.DREAM_FLOWER_PATCH, Placements.flower(3, true));
        public static final Pointer<PlacedFeature> NIGHTMARE_FLOWERS_5 = Placements.register("nightmare_flowers_5", Configured.NIGHTMARE_FLOWER_PATCH, Placements.flower(5, true));
        public static final Pointer<PlacedFeature> DREAM_LOLLIPOPS_5 = Placements.register("dream_lollipops_5", Configured.LOLLIPOP_BUSH_PATCH, Placements.flower(5, true));
        public static final Pointer<PlacedFeature> DREAM_MUSHROOMS_10 = Placements.register("hope_mushrooms_10", Configured.HOPE_MUSHROOM_PATCH, Placements.flower(10, true));
        public static final Pointer<PlacedFeature> NIGHTMARE_GRASS_5 = Placements.register("nightmare_grass_5", Configured.NIGHTMARE_GRASS_PATCH, Placements.flower(5, false));
        public static final Pointer<PlacedFeature> PRICKLY_NIGHTMARE_GRASS_3 = Placements.register("prickly_nightmare_grass_3", Configured.PRICKLY_NIGHTMARE_GRASS_PATCH, Placements.flower(3, true));
        public static final Pointer<PlacedFeature> PRICKLY_NIGHTMARE_GRASS_5 = Placements.register("prickly_nightmare_grass_5", Configured.PRICKLY_NIGHTMARE_GRASS_PATCH, Placements.flower(5, true));

        public static void bootstrap(BootstrapContext<PlacedFeature> bootstrap) {
            POINTERS.forEach((key, pointer) -> bootstrap.register(pointer.getKey(), (Object)((PlacedFeature)pointer.getInstance().apply(bootstrap))));
        }

        public static void init() {
        }

        private static Pointer<PlacedFeature> register(String key, Pointer<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> mods) {
            Pointer<PlacedFeature> pointer = new Pointer<PlacedFeature>(Registries.PLACED_FEATURE, key, c -> new PlacedFeature((Holder)feature.getHolder((BootstrapContext<?>)c).get(), List.copyOf(mods)));
            if (DatagenModLoader.isRunningDataGen()) {
                POINTERS.put(GoodNightSleep.locate(key), pointer);
            }
            return pointer;
        }

        private static List<PlacementModifier> countRange(int height, int count) {
            return List.of(CountPlacement.of((int)count), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)height)), BiomeFilter.biome());
        }

        private static List<PlacementModifier> countRange(HeightRangePlacement heightRange, int count) {
            return List.of(CountPlacement.of((int)count), InSquarePlacement.spread(), heightRange, BiomeFilter.biome());
        }

        private static List<PlacementModifier> flower(int count, boolean average) {
            RarityFilter modifier = average ? RarityFilter.onAverageOnceEvery((int)count) : CountPlacement.of((int)count);
            return List.of(modifier, InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        }

        private static List<PlacementModifier> countNoise(double noise, int x, int y) {
            return Placements.countNoise(noise, x, y, PlacementUtils.HEIGHTMAP);
        }

        private static List<PlacementModifier> countNoise(double noise, int x, int y, PlacementModifier heightmap) {
            return List.of(NoiseThresholdCountPlacement.of((double)noise, (int)x, (int)y), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        }
    }
}

