/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.util;

import com.legacy.good_nights_sleep.util.Pointer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public class DimensionHolder {
    private final Pointer<DimensionType> dimensionType;
    private final Pointer<NoiseGeneratorSettings> noiseSettings;
    private final Pointer<LevelStem> levelStem;
    private final ResourceKey<Level> levelKey;

    public DimensionHolder(ResourceLocation registryName, Function<BootstrapContext<?>, DimensionType> dimensionType, Function<BootstrapContext<?>, NoiseGeneratorSettings> noiseSettings, Function<BootstrapContext<?>, ChunkGenerator> chunkGeneratorFactory) {
        this.dimensionType = new Pointer<DimensionType>(Registries.DIMENSION_TYPE, registryName.getPath(), dimensionType);
        this.noiseSettings = new Pointer<NoiseGeneratorSettings>(Registries.NOISE_SETTINGS, registryName.getPath(), noiseSettings);
        this.levelStem = new Pointer<LevelStem>(Registries.LEVEL_STEM, registryName.getPath(), c -> new LevelStem((Holder)this.dimensionType.getHolder((BootstrapContext<?>)c).get(), (ChunkGenerator)chunkGeneratorFactory.apply((BootstrapContext<?>)c)));
        this.levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)registryName);
    }

    public Pointer<DimensionType> getType() {
        return this.dimensionType;
    }

    public Pointer<NoiseGeneratorSettings> getNoiseSettings() {
        return this.noiseSettings;
    }

    public Pointer<LevelStem> getLevelStem() {
        return this.levelStem;
    }

    public ResourceKey<Level> getLevelKey() {
        return this.levelKey;
    }
}

