/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.world;

import com.google.common.collect.ImmutableList;
import com.legacy.good_nights_sleep.registry.GNSBlocks;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class GNSSurfaceRuleData {
    private static final SurfaceRules.RuleSource BEDROCK = GNSSurfaceRuleData.stateRule(Blocks.BEDROCK);
    private static final SurfaceRules.RuleSource DREAM_GRASS = GNSSurfaceRuleData.stateRule(GNSBlocks.dream_grass_block);
    private static final SurfaceRules.RuleSource DREAM_DIRT = GNSSurfaceRuleData.stateRule(GNSBlocks.dream_dirt);
    private static final SurfaceRules.RuleSource NIGHTMARE_GRASS = GNSSurfaceRuleData.stateRule(GNSBlocks.nightmare_grass_block);
    private static final SurfaceRules.RuleSource NIGHTMARE_DIRT = GNSSurfaceRuleData.stateRule(Blocks.DIRT);

    public static SurfaceRules.RuleSource basicData(boolean preliminarySurface, boolean bedrockFloor, boolean nightmare) {
        SurfaceRules.ConditionSource aboveWater = SurfaceRules.waterBlockCheck((int)-1, (int)0);
        SurfaceRules.RuleSource belowSurfaceSource = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{nightmare ? NIGHTMARE_DIRT : DREAM_DIRT});
        SurfaceRules.RuleSource onSurfaceSource = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)aboveWater, (SurfaceRules.RuleSource)(nightmare ? NIGHTMARE_GRASS : DREAM_GRASS)), belowSurfaceSource});
        SurfaceRules.RuleSource floorModifiers = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)onSurfaceSource), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)belowSurfaceSource)});
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)(preliminarySurface ? SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)floorModifiers) : floorModifiers));
        if (bedrockFloor) {
            builder.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        }
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource stateRule(Block block) {
        return GNSSurfaceRuleData.stateRule(block.defaultBlockState());
    }

    private static SurfaceRules.RuleSource stateRule(BlockState state) {
        return SurfaceRules.state((BlockState)state);
    }
}

