/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.world;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class GNSTeleporter {
    public static void changeDimension(ResourceKey<Level> type, Entity entity, BlockPos pos) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        ResourceKey<Level> transferDimension = entity.level().dimension() == type ? Level.OVERWORLD : type;
        ServerLevel transferWorld = server.getLevel(transferDimension);
        if (!CommonHooks.onTravelToDimension((Entity)entity, transferDimension)) {
            return;
        }
        Entity teleportedEntity = GNSTeleporter.teleportEntity(entity, transferWorld, pos);
        teleportedEntity.fallDistance = 0.0;
    }

    private static Entity teleportEntity(Entity entity, ServerLevel transferWorld, BlockPos pos) {
        transferWorld.getBlockState(pos);
        int height = transferWorld.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos).getY();
        Vec3 endpointPos = Vec3.atBottomCenterOf((Vec3i)pos).with(Direction.Axis.Y, (double)height);
        TeleportTransition transition = new TeleportTransition(transferWorld, endpointPos, Vec3.ZERO, entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING.then(e -> e.placePortalTicket(pos)));
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos newPos = BlockPos.containing((Position)endpointPos.add((double)x, -1.0, (double)z));
                    if (transferWorld.getBlockState(newPos).getBlock() != Blocks.LAVA && transferWorld.getBlockState(newPos).getBlock() != Blocks.LAVA) continue;
                    transferWorld.setBlockAndUpdate(newPos, Blocks.GRASS_BLOCK.defaultBlockState());
                }
            }
            entity.teleport(transition);
            return player;
        }
        entity.unRide();
        entity.teleport(transition);
        return entity;
    }
}

