/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.world.biome_provider;

import com.legacy.good_nights_sleep.registry.GNSBiomes;
import com.legacy.good_nights_sleep.world.biome_provider.GNSBiomeSource;
import com.legacy.good_nights_sleep.world.chunkgen.GNSChunkGenerator;
import com.legacy.good_nights_sleep.world.chunkgen.NightmareChunkGenerator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class NightmareBiomeSource
extends GNSBiomeSource {
    public static final MapCodec<NightmareBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryOps.retrieveGetter((ResourceKey)Registries.BIOME), (App)Biome.LIST_CODEC.fieldOf("biomes").stable().forGetter(biomeSource -> biomeSource.biomeHolderSet())).apply((Applicative)instance, NightmareBiomeSource::new));

    public NightmareBiomeSource(HolderGetter<Biome> biomeRegistry) {
        this(biomeRegistry, (HolderSet<Biome>)HolderSet.direct(r -> biomeRegistry.getOrThrow(r.getKey()), List.of(GNSBiomes.NIGHTMARE_MOUND, GNSBiomes.SHAMEFUL_PLAINS, GNSBiomes.WASTED_FOREST)));
    }

    public NightmareBiomeSource(HolderGetter<Biome> biomeRegistry, HolderSet<Biome> biomes) {
        super(biomeRegistry, biomes);
    }

    @Override
    ResourceKey<Biome> getHill() {
        return GNSBiomes.NIGHTMARE_MOUND.getKey();
    }

    @Override
    ResourceKey<Biome> getPlains() {
        return GNSBiomes.SHAMEFUL_PLAINS.getKey();
    }

    @Override
    ResourceKey<Biome> getForest() {
        return GNSBiomes.WASTED_FOREST.getKey();
    }

    @Override
    ResourceKey<Biome> getDeepForest() {
        return null;
    }

    @Override
    GNSChunkGenerator.TerrainLayout getTerrainLayout() {
        return NightmareChunkGenerator.NIGHTMARE_LAYOUT;
    }

    protected MapCodec<NightmareBiomeSource> codec() {
        return CODEC;
    }
}

