/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.world.chunkgen;

import com.legacy.good_nights_sleep.world.biome_provider.GNSBiomeSource;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class GNSChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<GNSChunkGenerator> GNS_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(chunkGen -> chunkGen.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(chunkGen -> chunkGen.generatorSettings())).apply((Applicative)instance, instance.stable(GNSChunkGenerator::new)));
    public static final TerrainLayout DEFAULT_LAYOUT = new TerrainLayout(70.0, 350.0, 0.1, 8.0, 0.1, 1.0, 1.0);
    protected static final BlockState AIR = Blocks.AIR.defaultBlockState();
    protected SimplexNoise noiseA = null;
    protected SimplexNoise noiseB = null;
    protected SimplexNoise noiseC = null;

    public GNSChunkGenerator(BiomeSource biomeProvider, Holder<NoiseGeneratorSettings> settings) {
        super(biomeProvider, settings);
    }

    protected MapCodec<? extends GNSChunkGenerator> codec() {
        return GNS_CODEC;
    }

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> structureRegistry, RandomState rand, long serverSeed) {
        this.noiseA = new SimplexNoise((RandomSource)new WorldgenRandom(WorldgenRandom.Algorithm.XOROSHIRO.newInstance(serverSeed += this.getSeedOffset())));
        this.noiseB = new SimplexNoise((RandomSource)new WorldgenRandom(WorldgenRandom.Algorithm.XOROSHIRO.newInstance(serverSeed + 7L)));
        this.noiseC = new SimplexNoise((RandomSource)new WorldgenRandom(WorldgenRandom.Algorithm.XOROSHIRO.newInstance(serverSeed + 23L)));
        BiomeSource biomeSource = this.biomeSource;
        if (biomeSource instanceof GNSBiomeSource) {
            GNSBiomeSource b = (GNSBiomeSource)biomeSource;
            b.setNoises(this.noiseA, this.noiseB, this.noiseC);
        }
        return super.createState(structureRegistry, rand, serverSeed);
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        BlockPos cpos = chunkAccess.getPos().getWorldPosition();
        int chunkWidth = 16;
        Heightmap oceanHM = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap surfaceHM = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        for (int x = 0; x < chunkWidth; ++x) {
            int posX = cpos.getX() + x;
            for (int z = 0; z < chunkWidth; ++z) {
                int posZ = cpos.getZ() + z;
                for (int posY = 0; posY <= 200; ++posY) {
                    BlockState state = this.getStateAt(posX, posY, posZ);
                    if (state == AIR) continue;
                    BlockPos newPos = new BlockPos(x, posY, z);
                    chunkAccess.setBlockState(newPos, state);
                    oceanHM.update(x, posY, z, state);
                    surfaceHM.update(x, posY, z, state);
                    if (state.getFluidState().isEmpty()) continue;
                    chunkAccess.markPosForPostprocessing(newPos);
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }

    private BlockState getStateAt(int worldX, int worldY, int worldZ) {
        double groundHeight;
        TerrainLayout layout = this.getTerrainLayout();
        BlockState state = AIR;
        float seaLevel = 63.0f;
        if ((float)worldY <= seaLevel) {
            state = ((NoiseGeneratorSettings)this.generatorSettings().value()).defaultFluid();
        }
        double roughScale = layout.terrainRoughness();
        double roughness = (this.noiseA.getValue((double)worldX / 60.0, (double)worldZ / 60.0) + 1.0) / 2.0 * roughScale;
        double hillWideness = layout.hillWideness();
        double hillScaleDiff = 400.0;
        double hillDif = this.noiseC.getValue((double)worldX / hillScaleDiff, (double)worldZ / hillScaleDiff) / 2.0 * 2.0;
        if (hillDif <= 0.0) {
            hillDif *= layout.hillInversionScale();
        }
        double hillScale = layout.hillScale() * hillDif;
        double hills = this.noiseB.getValue((double)worldX / hillWideness, (double)worldZ / hillWideness) / 2.0 * hillScale;
        double groundAddition = roughness - (hills - hillScale / 2.0);
        double roughPass1 = this.noiseA.getValue((double)worldX / 20.0, (double)worldZ / 20.0) * 20.0 / 4.0;
        double roughPass2 = this.noiseB.getValue((double)worldX / 80.0, (double)worldZ / 80.0) * 50.0 / 4.0;
        double roughPass3 = this.noiseC.getValue((double)worldX / 40.0, (double)worldZ / 40.0) * (20.0 + roughPass1 + roughPass2) / 4.0;
        double highCuts = this.noiseC.getValue((double)worldX / 60.0, (double)worldZ / 60.0) / 4.0;
        double blurScale = 0.03;
        double plainsBlurring = this.noiseC.getValue((double)worldX * blurScale, (double)worldZ * blurScale) * 0.1;
        boolean isHill = hillDif >= 0.0 && hills < -0.5;
        boolean isBlurredHill = isHill && hills >= 0.0 - (2.0 + plainsBlurring * 4.0);
        roughPass3 *= layout.roughnessScale();
        if (GNSChunkGenerator.getBiomeNoise(this.noiseA, worldX, worldZ) <= plainsBlurring && (isBlurredHill && isHill || !isHill)) {
            roughPass3 *= 0.5;
        }
        if ((double)worldY < (groundHeight = (double)seaLevel + (groundAddition += roughPass3 * ((double)(highCuts > layout.highCutRange() ? 2 : 1) * layout.cutScale())))) {
            state = ((NoiseGeneratorSettings)this.generatorSettings().value()).defaultBlock();
        }
        return state;
    }

    public static double getBiomeNoise(SimplexNoise noise, double worldX, double worldZ) {
        double biomeScale = 650.0;
        return noise.getValue(worldX / biomeScale, worldZ / biomeScale);
    }

    protected TerrainLayout getTerrainLayout() {
        return DEFAULT_LAYOUT;
    }

    protected long getSeedOffset() {
        return 0L;
    }

    public int getBaseHeight(int x, int z, Heightmap.Types pType, LevelHeightAccessor level, RandomState pRandom) {
        return level.getMinY() + this.iterateColumn(x, z, new ArrayList<BlockState>(80), pType.isOpaque(), level);
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor level, RandomState randomState) {
        ArrayList<BlockState> states = new ArrayList<BlockState>(60);
        this.iterateColumn(x, z, states, null, level);
        return new NoiseColumn(level.getMinY(), (BlockState[])states.toArray(BlockState[]::new));
    }

    private int iterateColumn(int worldX, int worldZ, List<BlockState> states, @Nullable Predicate<BlockState> stateTest, LevelHeightAccessor level) {
        int maxY = level.getMaxY();
        for (int worldY = level.getMinY(); worldY < maxY; ++worldY) {
            BlockState state = this.getStateAt(worldX, worldY, worldZ);
            if (stateTest != null && !stateTest.test(state)) break;
            states.add(state);
        }
        return states.size();
    }

    public void addDebugScreenInfo(List<String> info, RandomState rand, BlockPos pos) {
        TerrainLayout layout = this.getTerrainLayout();
        info.add("Hill Scale: " + layout.hillScale);
        info.add("Hill Wideness: " + layout.hillWideness);
        info.add("Hill Inversion Scale: " + layout.hillInversionScale);
        info.add("Terrain Roughness: " + layout.terrainRoughness);
        info.add("High Cut Range: " + layout.highCutRange);
        info.add("Cut Scale: " + layout.cutScale);
        info.add("Roughness Scale: " + layout.roughnessScale);
    }

    public record TerrainLayout(double hillScale, double hillWideness, double hillInversionScale, double terrainRoughness, double highCutRange, double cutScale, double roughnessScale) {
    }
}

