/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.world.chunkgen;

import com.legacy.good_nights_sleep.registry.GNSDimensions;
import com.legacy.good_nights_sleep.world.biome_provider.NightmareBiomeSource;
import com.legacy.good_nights_sleep.world.chunkgen.GNSChunkGenerator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public class NightmareChunkGenerator
extends GNSChunkGenerator {
    public static final MapCodec<NightmareChunkGenerator> NIGHTMARE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryOps.retrieveGetter((ResourceKey)Registries.BIOME), (App)RegistryOps.retrieveGetter((ResourceKey)Registries.NOISE_SETTINGS)).apply((Applicative)instance, NightmareChunkGenerator::new));
    public static final GNSChunkGenerator.TerrainLayout NIGHTMARE_LAYOUT = new GNSChunkGenerator.TerrainLayout(130.0, 600.0, 0.1, 10.0, 0.05, 2.0, 1.0);

    public NightmareChunkGenerator(HolderGetter<Biome> biomeRegistry, HolderGetter<NoiseGeneratorSettings> noiseSettingsRegistry) {
        super(new NightmareBiomeSource(biomeRegistry), (Holder<NoiseGeneratorSettings>)noiseSettingsRegistry.getOrThrow(GNSDimensions.NIGHTMARE.getNoiseSettings().getKey()));
    }

    @Override
    protected long getSeedOffset() {
        return 737L;
    }

    @Override
    protected GNSChunkGenerator.TerrainLayout getTerrainLayout() {
        return NIGHTMARE_LAYOUT;
    }

    protected MapCodec<NightmareChunkGenerator> codec() {
        return NIGHTMARE_CODEC;
    }
}

