/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep.world.nightmare.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;
import org.joml.SimplexNoise;

public class NetherSplashFeature
extends Feature<NoneFeatureConfiguration> {
    public NetherSplashFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        Vec3 originVec = origin.getCenter();
        RandomSource rand = context.random();
        int radius = 8 + rand.nextInt(4);
        Block netherrack = Blocks.NETHERRACK;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockState replace;
                    float r;
                    BlockPos pos = origin.offset(x, y, z);
                    Vec3 angle = originVec.subtract(pos.getCenter()).normalize().add(originVec);
                    float noiseScale = 0.4f;
                    float noise = (SimplexNoise.noise((float)((float)angle.x * noiseScale), (float)((float)angle.y * noiseScale), (float)((float)angle.z * noiseScale)) + 1.0f) / 2.0f;
                    float dist = (float)Math.sqrt(pos.distSqr((Vec3i)origin));
                    if (!(dist <= (r = (float)radius * noise)) || !(replace = level.getBlockState(pos)).is(BlockTags.SCULK_REPLACEABLE_WORLD_GEN)) continue;
                    Block block = null;
                    block = dist >= r - 2.0f ? null : (dist >= r - 3.5f ? (rand.nextFloat() < 0.5f ? null : netherrack) : netherrack);
                    if (block == null) continue;
                    level.setBlock(pos, block.defaultBlockState(), 3);
                    if (block != netherrack || !(dist < 2.0f && rand.nextFloat() < 0.6f) && !(rand.nextFloat() < 0.2f) || !level.isEmptyBlock(pos.above())) continue;
                    level.setBlock(pos.above(), Blocks.FIRE.defaultBlockState(), 3);
                }
            }
        }
        return true;
    }
}

