/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.entity.CowJarBlockEntity;
import net.blay09.mods.cookingforblockheads.network.message.SyncedEffectMessage;
import net.blay09.mods.cookingforblockheads.tag.ModEntityTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CowJarHandler {
    public static void onLivingDamage(LivingDamageEvent event) {
        if (!CookingForBlockheadsConfig.getActive().cowJarEnabled) {
            return;
        }
        if (event.getDamageSource().getMsgId().equals("anvil") && event.getEntity().getType().is(ModEntityTypeTags.COW)) {
            LivingEntity entity = event.getEntity();
            Level level = entity.level();
            CowJarHandler.findMilkJar(level, entity.blockPosition()).ifPresent(arg_0 -> CowJarHandler.lambda$onLivingDamage$1(level, (Entity)entity, event, arg_0));
        }
    }

    private static Optional<BlockPos> findMilkJar(Level level, BlockPos pos) {
        if (level.getBlockState(pos).is(ModBlocks.milkJar)) {
            return Optional.of(pos);
        }
        BlockPos posBelow = pos.below();
        if (level.getBlockState(posBelow).is(ModBlocks.milkJar)) {
            return Optional.of(posBelow);
        }
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    mutablePos.setWithOffset((Vec3i)pos, x, y, z);
                    if (!level.getBlockState((BlockPos)mutablePos).is(ModBlocks.milkJar)) continue;
                    return Optional.of(mutablePos.immutable());
                }
            }
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$onLivingDamage$1(Level level, Entity entity, LivingDamageEvent event, BlockPos pos) {
        boolean wasCompressed;
        level.setBlockAndUpdate(pos, ModBlocks.cowJar.defaultBlockState());
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof CowJarBlockEntity && entity.getCustomName() != null) {
            MutableComponent textComponent = Component.translatable((String)"container.cookingforblockheads.cow_jar_custom", (Object[])new Object[]{entity.getCustomName()});
            ((CowJarBlockEntity)tileEntity).setCustomName((Component)textComponent);
        }
        if ((wasCompressed = Balm.getHooks().getPersistentData((Entity)event.getEntity()).getCompound("excompressum").flatMap(it -> it.getBoolean("Compressed")).orElse(false).booleanValue()) && tileEntity instanceof CowJarBlockEntity) {
            ((CowJarBlockEntity)tileEntity).setCompressedCow(true);
        }
        Balm.getNetworking().sendToTracking(entity, (CustomPacketPayload)new SyncedEffectMessage(pos, SyncedEffectMessage.Type.COW_IN_A_JAR));
        entity.remove(Entity.RemovalReason.DISCARDED);
        event.setCanceled(true);
    }
}

