/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.entity.CookingTableBlockEntity;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CookingTableBlock
extends BaseKitchenBlock {
    public static final MapCodec<CookingTableBlock> CODEC = RecordCodecBuilder.mapCodec(it -> it.group((App)DyeColor.CODEC.fieldOf("color").orElse(null).forGetter(CookingTableBlock::getColor), (App)CookingTableBlock.propertiesCodec()).apply((Applicative)it, CookingTableBlock::new));
    private final DyeColor color;

    public CookingTableBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.STONE).strength(2.5f));
        this.color = color;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CookingTableBlockEntity) {
            ItemStack noFilterBook;
            CookingTableBlockEntity cookingTable = (CookingTableBlockEntity)blockEntity;
            if (player.isShiftKeyDown() && !(noFilterBook = cookingTable.getNoFilterBook()).isEmpty()) {
                if (!player.getInventory().add(noFilterBook)) {
                    player.drop(noFilterBook, false);
                }
                cookingTable.setNoFilterBook(ItemStack.EMPTY);
                return InteractionResult.SUCCESS;
            }
            if (!level.isClientSide) {
                Balm.getNetworking().openMenu(player, (MenuProvider)cookingTable);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CookingTableBlockEntity) {
            CookingTableBlockEntity cookingTable = (CookingTableBlockEntity)blockEntity;
            if (this.tryRecolorBlock(state, itemStack, level, pos, player, blockHitResult)) {
                return InteractionResult.SUCCESS;
            }
            if (!cookingTable.hasNoFilterBook() && itemStack.getItem() == ModItems.noFilterBook) {
                cookingTable.setNoFilterBook(itemStack.split(1));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CookingTableBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected BlockState getDyedStateOf(BlockState state, @Nullable DyeColor color) {
        CookingTableBlock block = color == null ? ModBlocks.cookingTable : ModBlocks.dyedCookingTables[color.ordinal()];
        return (BlockState)block.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
    }
}

