/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OvenBlock
extends BaseKitchenBlock {
    public static final MapCodec<OvenBlock> CODEC = RecordCodecBuilder.mapCodec(it -> it.group((App)DyeColor.CODEC.fieldOf("color").forGetter(OvenBlock::getColor), (App)OvenBlock.propertiesCodec()).apply((Applicative)it, OvenBlock::new));
    public static BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private static final Random random = new Random();
    private final DyeColor color;

    public OvenBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.METAL).strength(5.0f, 10.0f));
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ACTIVE});
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof OvenBlockEntity)) {
            return InteractionResult.FAIL;
        }
        OvenBlockEntity oven = (OvenBlockEntity)blockEntity;
        if (itemStack.getItem() == ModItems.heatingUnit) {
            return InteractionResult.PASS;
        }
        if (this.tryRecolorBlock(state, itemStack, level, pos, player, blockHitResult)) {
            return InteractionResult.SUCCESS;
        }
        if (blockHitResult.getDirection() == Direction.UP && itemStack.is(ModItemTags.UTENSILS)) {
            OvenBlockEntity tileOven;
            Direction stateFacing = (Direction)state.getValue((Property)FACING);
            double hx = blockHitResult.getLocation().x;
            double hz = blockHitResult.getLocation().z;
            switch (stateFacing) {
                case NORTH: {
                    hx = 1.0 - blockHitResult.getLocation().x;
                    hz = 1.0 - blockHitResult.getLocation().z;
                    break;
                }
                case WEST: {
                    hz = 1.0 - blockHitResult.getLocation().x;
                    hx = blockHitResult.getLocation().z;
                    break;
                }
                case EAST: {
                    hz = blockHitResult.getLocation().x;
                    hx = 1.0 - blockHitResult.getLocation().z;
                }
            }
            int index = -1;
            if (hx < 0.5 && hz < 0.5) {
                index = 1;
            } else if (hx >= 0.5 && hz < 0.5) {
                index = 0;
            } else if (hx < 0.5 && hz >= 0.5) {
                index = 3;
            } else if (hx >= 0.5 && hz >= 0.5) {
                index = 2;
            }
            if (index != -1 && (tileOven = (OvenBlockEntity)level.getBlockEntity(pos)) != null && tileOven.getToolItem(index).isEmpty()) {
                ItemStack toolItem = itemStack.split(1);
                tileOven.setToolItem(index, toolItem);
            }
            return InteractionResult.SUCCESS;
        }
        if (blockHitResult.getDirection() == state.getValue((Property)FACING) && oven.getDoorAnimator().isForcedOpen()) {
            itemStack = ContainerUtils.insertItemStacked((Container)oven.getInputContainer(), (ItemStack)itemStack, (boolean)false);
            if (!itemStack.isEmpty()) {
                itemStack = ContainerUtils.insertItemStacked((Container)oven.getFuelContainer(), (ItemStack)itemStack, (boolean)false);
            }
            player.setItemInHand(hand, itemStack);
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof OvenBlockEntity)) {
            return InteractionResult.FAIL;
        }
        OvenBlockEntity oven = (OvenBlockEntity)blockEntity;
        if (rayTraceResult.getDirection() == state.getValue((Property)FACING) && player.isShiftKeyDown()) {
            oven.getDoorAnimator().toggleForcedOpen();
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide) {
            Balm.getNetworking().openMenu(player, (MenuProvider)oven);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OvenBlockEntity(pos, state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        OvenBlockEntity tileEntity = (OvenBlockEntity)level.getBlockEntity(pos);
        if (tileEntity != null && tileEntity.isBurning()) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            float x = (float)pos.getX() + 0.5f;
            float y = (float)pos.getY() + 0.0f + OvenBlock.random.nextFloat() * 6.0f / 16.0f;
            float z = (float)pos.getZ() + 0.5f;
            float f3 = 0.52f;
            float f4 = OvenBlock.random.nextFloat() * 0.6f - 0.3f;
            if (facing == Direction.WEST) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(x - f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == Direction.EAST) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(x + f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(x + f4), (double)y, (double)(z - f3), 0.0, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(x + f4), (double)y, (double)(z + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? OvenBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.oven.get()), OvenBlockEntity::clientTick) : OvenBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.oven.get()), OvenBlockEntity::serverTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected BlockState getDyedStateOf(BlockState state, @Nullable DyeColor color) {
        OvenBlock block = color == null ? ModBlocks.ovens[0] : ModBlocks.ovens[color.ordinal()];
        return (BlockState)((BlockState)block.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)ACTIVE, (Comparable)((Boolean)state.getValue((Property)ACTIVE)));
    }
}

