/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import java.util.Collection;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.DefaultFluidTank;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProviderHolder;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class MilkJarBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider,
KitchenItemProviderHolder {
    protected static final int MILK_CAPACITY = 32000;
    protected final DefaultFluidTank milkTank = new DefaultFluidTank(32000){

        public boolean canFill(Fluid fluid) {
            return fluid.isSame(Compat.getMilkFluid()) && super.canFill(fluid);
        }

        public void setChanged() {
            MilkJarBlockEntity.this.setChanged();
            MilkJarBlockEntity.this.sync();
        }
    };
    private final MilkJarItemProvider itemProvider = new MilkJarItemProvider(this);

    public MilkJarBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends MilkJarBlockEntity>)((BlockEntityType)ModBlockEntities.milkJar.get()), pos, state);
    }

    protected MilkJarBlockEntity(BlockEntityType<? extends MilkJarBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void saveAdditional(ValueOutput output) {
        this.milkTank.serialize(output.child("FluidTank"));
    }

    public void loadAdditional(ValueInput input) {
        input.child("FluidTank").ifPresent(arg_0 -> ((DefaultFluidTank)this.milkTank).deserialize(arg_0));
    }

    public void writeUpdateTag(ValueOutput output) {
        this.saveAdditional(output);
    }

    public FluidTank getFluidTank() {
        return this.milkTank;
    }

    @Override
    public KitchenItemProvider getKitchenItemProvider() {
        return this.itemProvider;
    }

    private record MilkJarItemProvider(MilkJarBlockEntity milkJar) implements KitchenItemProvider
    {
        @Override
        public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (Holder milkItem : BuiltInRegistries.ITEM.getTagOrEmpty(ModItemTags.MILK)) {
                if (!ingredient.acceptsItem(milkItem)) continue;
                int milkUnitsUsed = ingredientTokens.size();
                int milkUnitsAvailable = this.milkJar.getFluidTank().getAmount() / 1000 - milkUnitsUsed;
                if (milkUnitsAvailable > 1) {
                    return new MilkJarIngredientToken(this.milkJar, new ItemStack(milkItem));
                }
                return null;
            }
            return null;
        }

        @Override
        public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            if (!itemStack.is(ModItemTags.MILK)) {
                return null;
            }
            int milkUnitsUsed = ingredientTokens.size();
            int milkUnitsAvailable = this.milkJar.getFluidTank().getAmount() / 1000 - milkUnitsUsed;
            if (milkUnitsAvailable > 1) {
                return new MilkJarIngredientToken(this.milkJar, itemStack);
            }
            return null;
        }

        @Override
        public CacheHint getCacheHint(IngredientToken ingredientToken) {
            return CacheHint.NONE;
        }
    }

    private record MilkJarIngredientToken(MilkJarBlockEntity milkJar, ItemStack itemStack) implements IngredientToken
    {
        @Override
        public ItemStack peek() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, true);
            return drained >= 1000 ? this.itemStack : ItemStack.EMPTY;
        }

        @Override
        public ItemStack consume() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, false);
            return drained >= 1000 ? this.itemStack : ItemStack.EMPTY;
        }

        @Override
        public ItemStack restore(ItemStack itemStack) {
            if (itemStack.is(ModItemTags.MILK)) {
                this.milkJar.getFluidTank().fill(Compat.getMilkFluid(), 1000, false);
            }
            return ItemStack.EMPTY;
        }
    }
}

