/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.world.item.DyeColor;

public class ModModels {
    public static DeferredObject<BlockStateModel> milkJarLiquid;
    public static DeferredObject<BlockStateModel> cowJarLiquid;
    public static DeferredObject<BlockStateModel> sinkLiquid;
    public static List<DeferredObject<BlockStateModel>> ovenDoors;
    public static List<DeferredObject<BlockStateModel>> ovenDoorHandles;
    public static List<DeferredObject<BlockStateModel>> ovenDoorsActive;
    public static List<DeferredObject<BlockStateModel>> fridgeDoors;
    public static List<DeferredObject<BlockStateModel>> fridgeDoorsFlipped;
    public static List<DeferredObject<BlockStateModel>> fridgeDoorsLargeLower;
    public static List<DeferredObject<BlockStateModel>> fridgeDoorsLargeUpper;
    public static List<DeferredObject<BlockStateModel>> fridgeDoorsLargeLowerFlipped;
    public static List<DeferredObject<BlockStateModel>> fridgeDoorsLargeUpperFlipped;
    public static List<DeferredObject<BlockStateModel>> counterDoors;
    public static List<DeferredObject<BlockStateModel>> counterDoorsFlipped;
    public static List<DeferredObject<BlockStateModel>> cabinetDoors;
    public static List<DeferredObject<BlockStateModel>> cabinetDoorsFlipped;

    public static void initialize(BalmModels models) {
        String colorPrefix;
        DyeColor[] colors = DyeColor.values();
        milkJarLiquid = models.loadModel(CookingForBlockheads.id("block/milk_jar_liquid"));
        cowJarLiquid = models.loadModel(CookingForBlockheads.id("block/cow_jar_liquid"));
        sinkLiquid = models.loadModel(CookingForBlockheads.id("block/sink_liquid"));
        ovenDoors = new ArrayList<DeferredObject<BlockStateModel>>(colors.length);
        ovenDoorHandles = new ArrayList<DeferredObject<BlockStateModel>>(colors.length);
        ovenDoorsActive = new ArrayList<DeferredObject<BlockStateModel>>(colors.length);
        fridgeDoors = new ArrayList<DeferredObject<BlockStateModel>>(colors.length);
        fridgeDoorsFlipped = new ArrayList<DeferredObject<BlockStateModel>>(colors.length);
        fridgeDoorsLargeLower = new ArrayList<DeferredObject<BlockStateModel>>(colors.length);
        fridgeDoorsLargeUpper = new ArrayList<DeferredObject<BlockStateModel>>(colors.length);
        fridgeDoorsLargeLowerFlipped = new ArrayList<DeferredObject<BlockStateModel>>(colors.length);
        fridgeDoorsLargeUpperFlipped = new ArrayList<DeferredObject<BlockStateModel>>(colors.length);
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            ovenDoors.add(color.getId(), (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "oven_door")));
            ovenDoorsActive.add(color.getId(), (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "oven_door_active")));
            ovenDoorHandles.add(color.getId(), (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "oven_door_handle")));
            fridgeDoors.add(color.getId(), (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "fridge_door")));
            fridgeDoorsFlipped.add(color.getId(), (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "fridge_door_flipped")));
            fridgeDoorsLargeLower.add(color.getId(), (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "fridge_large_door_lower")));
            fridgeDoorsLargeLowerFlipped.add(color.getId(), (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "fridge_large_door_lower_flipped")));
            fridgeDoorsLargeUpper.add(color.getId(), (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "fridge_large_door_upper")));
            fridgeDoorsLargeUpperFlipped.add(color.getId(), (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "fridge_large_door_upper_flipped")));
        }
        counterDoors = new ArrayList<DeferredObject<BlockStateModel>>(colors.length + 1);
        counterDoors.add(0, (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/counter_door")));
        counterDoorsFlipped = new ArrayList<DeferredObject<BlockStateModel>>(colors.length + 1);
        counterDoorsFlipped.add(0, (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/counter_door_flipped")));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            counterDoors.add(color.getId() + 1, (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "counter_door")));
            counterDoorsFlipped.add(color.getId() + 1, (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "counter_door_flipped")));
        }
        cabinetDoors = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        cabinetDoors.add(0, (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/cabinet_door")));
        cabinetDoorsFlipped = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        cabinetDoorsFlipped.add(0, (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/cabinet_door_flipped")));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            cabinetDoors.add(color.getId() + 1, (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "cabinet_door")));
            cabinetDoorsFlipped.add(color.getId() + 1, (DeferredObject<BlockStateModel>)models.loadModel(CookingForBlockheads.id("block/" + colorPrefix + "cabinet_door_flipped")));
        }
    }
}

