/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.gui.screen;

import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.menu.OvenMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3x2fStack;

public class OvenScreen
extends AbstractContainerScreen<OvenMenu> {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"textures/gui/oven.png");

    public OvenScreen(OvenMenu container, Inventory playerInventory, Component displayName) {
        super((AbstractContainerMenu)container, playerInventory, displayName);
        this.imageWidth += 22;
        this.imageHeight = 193;
        this.titleLabelX += 22;
        this.inventoryLabelX += 22;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        OvenBlockEntity tileEntity = ((OvenMenu)this.menu).getOven();
        if (tileEntity.hasPowerUpgrade() && mouseX >= this.leftPos + this.imageWidth - 25 && mouseY >= this.topPos + 22 && mouseX < this.leftPos + this.imageWidth - 25 + 35 + 18 && mouseY < this.topPos + 22 + 72) {
            EnergyStorage energyStorage = tileEntity.getEnergyStorage();
            guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"tooltip.cookingforblockheads.energy_stored", (Object[])new Object[]{energyStorage.getEnergy(), energyStorage.getCapacity()}), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        OvenBlockEntity oven = ((OvenMenu)this.menu).getOven();
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack;
            Slot slot = (Slot)((OvenMenu)this.menu).slots.get(i + 7);
            if (!slot.hasItem() || (itemStack = (ItemStack)((OvenMenu)this.menu).getResultItems().get(i)).isEmpty()) continue;
            Matrix3x2fStack pose = guiGraphics.pose();
            pose.pushMatrix();
            pose.popMatrix();
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos + 22, this.topPos, 0.0f, 0.0f, this.imageWidth - 22, this.imageHeight, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos, this.topPos + 10, 176.0f, 30.0f, 25, 87, 256, 256);
        OvenBlockEntity tileEntity = ((OvenMenu)this.menu).getOven();
        int offsetX = tileEntity.hasPowerUpgrade() ? -5 : 0;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos + 22 + 61 + offsetX, this.topPos + 18, 176.0f, 117.0f, 76, 76, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos + 22 + 38 + offsetX, this.topPos + 43, 205.0f, 84.0f, 18, 33, 256, 256);
        if (tileEntity.isBurning()) {
            int burnTime = (int)(12.0f * tileEntity.getBurnTimeProgress());
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos + 22 + 40 + offsetX, this.topPos + 43 + 12 - burnTime, 176.0f, (float)(12 - burnTime), 14, burnTime + 1, 256, 256);
        }
        if (tileEntity.hasPowerUpgrade()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos + this.imageWidth - 25, this.topPos + 22, 205.0f, 0.0f, 18, 72, 256, 256);
            EnergyStorage energyStorage = tileEntity.getEnergyStorage();
            float energyPercentage = (float)energyStorage.getEnergy() / (float)energyStorage.getCapacity();
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos + this.imageWidth - 25 + 1, this.topPos + 22 + 1 + 70 - (int)(energyPercentage * 70.0f), 223.0f, 0.0f, 16, (int)(energyPercentage * 70.0f), 256, 256);
        }
    }
}

