/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class FridgeRenderer
implements BlockEntityRenderer<FridgeBlockEntity> {
    private static final RandomSource random = RandomSource.create();

    public FridgeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FridgeBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 cameraPos) {
        Level level = tileEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockState state = tileEntity.getBlockState();
        FridgeBlock.FridgeModelType fridgeModelType = (FridgeBlock.FridgeModelType)((Object)state.getValue(FridgeBlock.MODEL_TYPE));
        if (fridgeModelType == FridgeBlock.FridgeModelType.LARGE_UPPER) {
            return;
        }
        float doorAngle = tileEntity.getDoorAnimator().getRenderAngle(partialTicks);
        this.renderDoor(level, tileEntity, poseStack, buffer, state, fridgeModelType, doorAngle);
        if (doorAngle > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(poseStack, tileEntity.getBlockState());
            poseStack.scale(0.3f, 0.3f, 0.3f);
            float topY = fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER ? 3.25f : 0.45f;
            Container container = tileEntity.getCombinedContainer();
            for (int i = container.getContainerSize() - 1; i >= 0; --i) {
                float offsetZ;
                float offsetY;
                float offsetX;
                ItemStack itemStack = container.getItem(i);
                if (itemStack.isEmpty()) continue;
                if (fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER) {
                    rowIndex = i % 18;
                    offsetX = 0.7f - (float)(rowIndex % 9) * 0.175f;
                    offsetY = topY - (float)((int)((float)i / 18.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                } else {
                    rowIndex = i % 13;
                    offsetX = 0.7f;
                    float spacing = 0.175f;
                    if (rowIndex / 9 > 0) {
                        offsetX -= 0.2f;
                        spacing *= 2.0f;
                    }
                    offsetX -= (float)(rowIndex % 9) * spacing;
                    offsetY = topY - (float)((int)((float)i / 14.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                }
                poseStack.pushPose();
                poseStack.translate(offsetX, offsetY, offsetZ);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
                RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer, level);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    private void renderDoor(Level level, FridgeBlockEntity tileEntity, PoseStack poseStack, MultiBufferSource buffer, BlockState state, FridgeBlock.FridgeModelType fridgeModelType, float doorAngle) {
        BlockStateModel lowerModel;
        DyeColor dyeColor;
        boolean isFlipped = (Boolean)state.getValue((Property)FridgeBlock.FLIPPED);
        boolean isLarge = fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER;
        poseStack.pushPose();
        RenderUtils.applyBlockAngle(poseStack, tileEntity.getBlockState());
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        float originX = 0.90625f;
        float originZ = 0.09375f;
        if (isFlipped) {
            originX = 1.0f - originX;
            doorAngle *= -1.0f;
        }
        poseStack.translate(originX, 0.0f, originZ);
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees((float)Math.toDegrees(doorAngle)));
        poseStack.translate(-originX, 0.0f, -originZ);
        Block block = state.getBlock();
        if (block instanceof FridgeBlock) {
            FridgeBlock fridge = (FridgeBlock)block;
            dyeColor = fridge.getColor();
        } else {
            dyeColor = DyeColor.WHITE;
        }
        DyeColor blockColor = dyeColor;
        int colorIndex = blockColor.getId();
        BlockStateModel upperModel = null;
        if (isLarge) {
            lowerModel = isFlipped ? (BlockStateModel)ModModels.fridgeDoorsLargeLowerFlipped.get(colorIndex).get() : (BlockStateModel)ModModels.fridgeDoorsLargeLower.get(colorIndex).get();
            upperModel = isFlipped ? (BlockStateModel)ModModels.fridgeDoorsLargeUpperFlipped.get(colorIndex).get() : (BlockStateModel)ModModels.fridgeDoorsLargeUpper.get(colorIndex).get();
        } else {
            lowerModel = isFlipped ? (BlockStateModel)ModModels.fridgeDoorsFlipped.get(colorIndex).get() : (BlockStateModel)ModModels.fridgeDoors.get(colorIndex).get();
        }
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, lowerModel.collectParts(random), tileEntity.getBlockState(), tileEntity.getBlockPos(), poseStack, buffer.getBuffer(RenderType.solid()), false, 0);
        if (upperModel != null) {
            poseStack.translate(0.0f, 1.0f, 0.0f);
            dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, upperModel.collectParts(random), tileEntity.getBlockState(), tileEntity.getBlockPos().above(), poseStack, buffer.getBuffer(RenderType.solid()), false, 0);
        }
        poseStack.popPose();
    }
}

