/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.blay09.mods.cookingforblockheads.block.entity.SpiceRackBlockEntity;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class SpiceRackRenderer
implements BlockEntityRenderer<SpiceRackBlockEntity> {
    public SpiceRackRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SpiceRackBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 cameraPos) {
        if (!blockEntity.hasLevel()) {
            return;
        }
        Level level = blockEntity.getLevel();
        poseStack.pushPose();
        RenderUtils.applyBlockAngle(poseStack, blockEntity.getBlockState());
        poseStack.translate(-0.4, 0.75, 0.3);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (int i = 0; i < blockEntity.getContainer().getContainerSize(); ++i) {
            ItemStack itemStack = blockEntity.getContainer().getItem(i);
            if (itemStack.isEmpty()) continue;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.2f * (float)i);
            poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(20.0f));
            RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer, level);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

