/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeHandler;
import net.blay09.mods.cookingforblockheads.crafting.CraftingContext;
import net.blay09.mods.cookingforblockheads.registry.CookingForBlockheadsRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class CraftingOperation {
    private final CraftingContext context;
    private final RecipeHolder<?> recipe;
    private final Multimap<IngredientTokenKey, IngredientToken> tokensByIngredient = ArrayListMultimap.create();
    private final List<IngredientToken> ingredientTokens = new ArrayList<IngredientToken>();
    private final List<Ingredient> missingIngredients = new ArrayList<Ingredient>();
    private NonNullList<ItemStack> lockedInputs;
    private int missingIngredientsMask;

    public CraftingOperation(CraftingContext context, RecipeHolder<?> recipe) {
        this.context = context;
        this.recipe = recipe;
    }

    public CraftingOperation withLockedInputs(@Nullable NonNullList<ItemStack> lockedInputs) {
        this.lockedInputs = lockedInputs;
        return this;
    }

    public CraftingOperation prepare() {
        this.tokensByIngredient.clear();
        this.ingredientTokens.clear();
        this.missingIngredients.clear();
        this.missingIngredientsMask = 0;
        KitchenRecipeHandler recipeMapper = CookingForBlockheadsAPI.getKitchenRecipeHandler(this.recipe.value());
        List<Optional<Ingredient>> ingredients = recipeMapper.getIngredients((Recipe)this.recipe);
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack lockedInput;
            if (ingredients.get(i).isEmpty()) {
                this.ingredientTokens.add(IngredientToken.EMPTY);
                continue;
            }
            Ingredient ingredient = ingredients.get(i).get();
            IngredientToken ingredientToken = this.accountForIngredient(ingredient, lockedInput = this.lockedInputs != null ? (ItemStack)this.lockedInputs.get(i) : ItemStack.EMPTY);
            if (ingredientToken != null) {
                if (ingredient.items().count() <= 1L) continue;
                if (this.lockedInputs == null) {
                    this.lockedInputs = NonNullList.withSize((int)ingredients.size(), (Object)ItemStack.EMPTY);
                }
                this.lockedInputs.set(i, (Object)ingredientToken.peek());
                continue;
            }
            this.missingIngredients.add(ingredient);
            this.missingIngredientsMask |= 1 << i;
        }
        return this;
    }

    @Nullable
    private IngredientToken accountForIngredient(Ingredient ingredient, ItemStack lockedInput) {
        KitchenItemProvider itemProvider;
        IngredientToken ingredientToken;
        List<KitchenItemProvider> itemProviders = this.context.getItemProviders();
        int cachedProviderIndex = this.context.getCachedItemProviderIndexFor(ingredient);
        if (cachedProviderIndex != -1 && (ingredientToken = this.accountForIngredient(cachedProviderIndex, itemProvider = itemProviders.get(cachedProviderIndex), ingredient, lockedInput, true)) != null) {
            return ingredientToken;
        }
        for (int j = 0; j < itemProviders.size(); ++j) {
            KitchenItemProvider itemProvider2 = itemProviders.get(j);
            IngredientToken ingredientToken2 = this.accountForIngredient(j, itemProvider2, ingredient, lockedInput, false);
            if (ingredientToken2 == null) continue;
            return ingredientToken2;
        }
        return null;
    }

    @Nullable
    private IngredientToken accountForIngredient(int itemProviderIndex, KitchenItemProvider itemProvider, Ingredient ingredient, ItemStack lockedInput, boolean useCache) {
        CacheHint cacheHint;
        IngredientTokenKey ingredientTokenKey = new IngredientTokenKey(itemProviderIndex, ingredient);
        Collection scopedIngredientTokens = this.tokensByIngredient.get((Object)ingredientTokenKey);
        IngredientToken ingredientToken = this.findIngredient(itemProvider, ingredient, lockedInput, scopedIngredientTokens, cacheHint = useCache ? this.context.getCacheHintFor(ingredientTokenKey) : CacheHint.NONE);
        if (ingredientToken != null) {
            this.tokensByIngredient.put((Object)ingredientTokenKey, (Object)ingredientToken);
            this.context.cache(ingredientTokenKey, itemProviderIndex, itemProvider.getCacheHint(ingredientToken));
            this.ingredientTokens.add(ingredientToken);
            return ingredientToken;
        }
        return null;
    }

    @Nullable
    private IngredientToken findIngredient(KitchenItemProvider itemProvider, Ingredient ingredient, ItemStack lockedInput, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        IngredientToken ingredientToken = lockedInput.isEmpty() ? itemProvider.findIngredient(ingredient, ingredientTokens, cacheHint) : itemProvider.findIngredient(lockedInput, ingredientTokens, cacheHint);
        return ingredientToken;
    }

    public boolean canCraft() {
        return this.missingIngredients.isEmpty();
    }

    public ItemStack craft(AbstractContainerMenu menu, RegistryAccess registryAccess) {
        return this.craft(menu, registryAccess, this.recipe);
    }

    private ItemStack craft(AbstractContainerMenu menu, RegistryAccess registryAccess, RecipeHolder<?> recipe) {
        Object recipeTypeHandler = CookingForBlockheadsRegistry.getKitchenRecipeHandler(recipe.value());
        if (recipeTypeHandler == null) {
            return ItemStack.EMPTY;
        }
        return recipeTypeHandler.assemble(this.context, recipe, this.ingredientTokens, registryAccess);
    }

    public NonNullList<ItemStack> getLockedInputs() {
        return this.lockedInputs;
    }

    public List<Ingredient> getMissingIngredients() {
        return this.missingIngredients;
    }

    public int getMissingIngredientsMask() {
        return this.missingIngredientsMask;
    }

    public record IngredientTokenKey(int providerIndex, Ingredient ingredient) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IngredientTokenKey that = (IngredientTokenKey)o;
            return this.providerIndex == that.providerIndex && Objects.equals(this.ingredient, that.ingredient);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.providerIndex, this.ingredient);
        }
    }
}

